/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import java.util.List;
import org.jetbrains.jet.internal.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilationError;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerListener;
import org.jetbrains.jet.internal.com.google.dart.compiler.ErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDeclaration;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartField;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFieldDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionTypeAlias;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNodeTraverser;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.LibraryUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.SourceInfo;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Elements;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FunctionAliasElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ResolverErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Scope;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Types;

public class TopLevelElementBuilder {
    public void exec(LibraryUnit library, DartCompilerContext context) {
        assert (library.getElement().getScope().isClear());
        for (DartUnit unit : library.getUnits()) {
            unit.accept(new Builder(library.getElement()));
        }
    }

    public void exec(DartUnit unit, DartCompilerContext context) {
        unit.accept(new Builder());
    }

    public void exec(DartClass cls, DartCompilerContext context) {
        cls.accept(new Builder());
    }

    public void fillInLibraryScope(LibraryUnit library, DartCompilerListener listener) {
        Scope scope = library.getElement().getScope();
        assert (scope.getElements().isEmpty());
        for (LibraryUnit lib : library.getImports()) {
            String prefix = library.getPrefixOf(lib);
            if (prefix != null) {
                scope.declareElement(prefix, lib.getElement());
                continue;
            }
            for (DartUnit unit : lib.getUnits()) {
                this.fillInUnitScope(unit, listener, scope);
            }
        }
        for (DartUnit unit : library.getUnits()) {
            this.fillInUnitScope(unit, listener, scope);
        }
    }

    @VisibleForTesting
    void fillInUnitScope(DartUnit unit, DartCompilerListener listener, Scope scope) {
        for (DartNode node : unit.getTopLevelNodes()) {
            if (node instanceof DartFieldDefinition) {
                for (DartField field : ((DartFieldDefinition)node).getFields()) {
                    this.declare(field.getSymbol(), listener, scope);
                }
                continue;
            }
            this.declare((Element)node.getSymbol(), listener, scope);
        }
    }

    void compilationError(DartCompilerListener listener, SourceInfo node, ErrorCode errorCode, Object ... args) {
        DartCompilationError error = new DartCompilationError(node, errorCode, args);
        listener.onError(error);
    }

    private void declare(Element newElement, DartCompilerListener listener, Scope scope) {
        Element oldElement = scope.declareElement(newElement.getName(), newElement);
        if (oldElement != null) {
            if (newElement.getModifiers().isAbstractField() && oldElement.getModifiers().isAbstractField()) {
                if (newElement.getModifiers().isGetter() && !oldElement.getModifiers().isGetter()) {
                    return;
                }
                if (newElement.getModifiers().isSetter() && !oldElement.getModifiers().isSetter()) {
                    return;
                }
            }
            this.reportDuplicateDeclaration(listener, oldElement);
            this.reportDuplicateDeclaration(listener, newElement);
        }
    }

    private void reportDuplicateDeclaration(DartCompilerListener listener, Element element) {
        DartNode node = element.getNode();
        if (node instanceof DartDeclaration) {
            Object nameNode = ((DartDeclaration)node).getName();
            this.compilationError(listener, (SourceInfo)nameNode, ResolverErrorCode.DUPLICATE_TOP_LEVEL_DEFINITION, nameNode);
        }
    }

    private class Builder
    extends DartNodeTraverser<Void> {
        private LibraryElement library;

        public Builder() {
            this(null);
        }

        public Builder(LibraryElement library) {
            this.library = library;
        }

        @Override
        public Void visitClass(DartClass node) {
            ClassElement element = Elements.classFromNode(node, this.library);
            List<DartTypeParameter> parameterNodes = node.getTypeParameters();
            element.setType(Types.interfaceType(element, Elements.makeTypeVariables(parameterNodes, element)));
            node.setSymbol(element);
            return null;
        }

        @Override
        public Void visitFunctionTypeAlias(DartFunctionTypeAlias node) {
            FunctionAliasElement element = Elements.functionTypeAliasFromNode(node, this.library);
            List<DartTypeParameter> parameterNodes = node.getTypeParameters();
            element.setType(Types.functionAliasType(element, Elements.makeTypeVariables(parameterNodes, element)));
            node.setSymbol(element);
            return null;
        }

        @Override
        public Void visitMethodDefinition(DartMethodDefinition node) {
            node.setSymbol(Elements.methodFromMethodNode(node, this.library));
            return null;
        }

        @Override
        public Void visitField(DartField node) {
            Modifiers modifiers = node.getModifiers();
            if (modifiers.isFinal()) {
                modifiers = modifiers.makeConstant();
            }
            node.setSymbol(Elements.fieldFromNode(node, this.library, modifiers));
            return null;
        }
    }
}

