/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import java.util.Collections;
import java.util.List;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartLabel;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ConstructorElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CoreTypeProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.EnclosingElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.VariableElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.FunctionType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Types;

public class SyntheticDefaultConstructorElement
implements ConstructorElement {
    private final DartMethodDefinition method;
    private final ClassElement enclosingClass;
    private final FunctionType functionType;
    private ConstructorElement defaultConstructor;

    public SyntheticDefaultConstructorElement(DartMethodDefinition method, ClassElement enclosingClass, CoreTypeProvider typeProvider) {
        this.method = method;
        this.enclosingClass = enclosingClass;
        this.functionType = typeProvider != null ? Types.makeFunctionType(null, typeProvider.getFunctionType().getElement(), this.getParameters(), typeProvider.getDynamicType()) : null;
    }

    @Override
    public String getOriginalSymbolName() {
        return this.getName();
    }

    @Override
    public DartNode getNode() {
        return this.method;
    }

    @Override
    public void setNode(DartLabel node) {
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public Type getType() {
        return this.functionType;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public Modifiers getModifiers() {
        return Modifiers.NONE;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.CONSTRUCTOR;
    }

    @Override
    public EnclosingElement getEnclosingElement() {
        return this.enclosingClass;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    @Override
    public ConstructorElement getDefaultConstructor() {
        return this.defaultConstructor;
    }

    @Override
    public void setDefaultConstructor(ConstructorElement defaultConstructor) {
        this.defaultConstructor = defaultConstructor;
    }

    @Override
    public Type getReturnType() {
        return this.functionType.getReturnType();
    }

    @Override
    public List<VariableElement> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public FunctionType getFunctionType() {
        return this.functionType;
    }

    @Override
    public ClassElement getConstructorType() {
        return this.enclosingClass;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public Iterable<Element> getMembers() {
        return Collections.emptyList();
    }

    @Override
    public Element lookupLocalElement(String name) {
        return null;
    }
}

