/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LabelElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;

public class Scope {
    private final Map<String, Element> elements = new LinkedHashMap<String, Element>();
    private final Scope parent;
    private final String name;
    private LabelElement label;
    private LibraryElement library;

    @VisibleForTesting
    public Scope(String name, LibraryElement library, Scope parent) {
        this.name = name;
        this.parent = parent;
        this.library = library;
    }

    @VisibleForTesting
    public Scope(String name, LibraryElement element) {
        this(name, element, null);
    }

    public void clear() {
        this.elements.clear();
    }

    public Element declareElement(String name, Element element) {
        return this.elements.put(name, element);
    }

    public Element findLocalElement(String name) {
        return this.elements.get(name);
    }

    public Element findElement(LibraryElement fromLibrary, String name) {
        Element element = null;
        if (fromLibrary == null || !DartIdentifier.isPrivateName(name) || fromLibrary.equals(this.library)) {
            element = this.findLocalElement(name);
        }
        if (element == null) {
            element = this.parent != null ? this.parent.findElement(fromLibrary, name) : null;
        }
        return element;
    }

    public LibraryElement getLibrary() {
        return this.library;
    }

    public Element findLabel(String targetName, MethodElement innermostFunction) {
        if (this.label != null && this.label.getName().equals(targetName) && innermostFunction == this.label.getEnclosingFunction()) {
            return this.label;
        }
        return this.parent == null ? null : this.parent.findLabel(targetName, innermostFunction);
    }

    public Map<String, Element> getElements() {
        return this.elements;
    }

    public Element getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public Scope getParent() {
        return this.parent;
    }

    public boolean isClear() {
        return this.elements.size() == 0;
    }

    public void setLabel(LabelElement label) {
        this.label = label;
    }

    public String toString() {
        return this.getName() + " : \n" + this.elements.toString();
    }
}

