/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jet.internal.com.google.dart.compiler.ErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartCatchBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionTypeAlias;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNodeTraverser;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CoreTypeProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Elements;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FunctionAliasElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ResolutionContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ResolverErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.TypeErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.TypeVariableElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.VariableElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.DynamicType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.FunctionType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Types;

abstract class ResolveVisitor
extends DartNodeTraverser<Element> {
    private final CoreTypeProvider typeProvider;

    ResolveVisitor(CoreTypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    abstract ResolutionContext getContext();

    final MethodElement resolveFunction(DartFunction node, MethodElement element) {
        for (DartParameter parameter : node.getParams()) {
            Elements.addParameter(element, (VariableElement)parameter.accept(this));
        }
        Type returnType = this.resolveType(node.getReturnTypeNode(), element.getModifiers().isStatic(), element.getModifiers().isFactory(), TypeErrorCode.NO_SUCH_TYPE);
        ClassElement functionElement = this.typeProvider.getFunctionType().getElement();
        FunctionType type = Types.makeFunctionType(this.getContext(), functionElement, element.getParameters(), returnType);
        Elements.setType(element, type);
        return element;
    }

    private void bindReturnGenerics(DartTypeNode node) {
        for (DartTypeNode typeNode : node.getTypeArguments()) {
            if (ElementKind.of(typeNode.getType().getElement()) != ElementKind.TYPE_VARIABLE) {
                this.bindReturnGenerics(typeNode);
                continue;
            }
            this.bindTypeVariable((TypeVariableElement)typeNode.getType().getElement());
        }
    }

    final FunctionAliasElement resolveFunctionAlias(DartFunctionTypeAlias node) {
        DartTypeNode returnNode = node.getReturnTypeNode();
        if (returnNode != null) {
            this.bindReturnGenerics(returnNode);
        }
        FunctionAliasElement funcAlias = node.getSymbol();
        for (Type type : funcAlias.getTypeParameters()) {
            TypeVariableElement typeVar = (TypeVariableElement)type.getElement();
            this.getContext().getScope().declareElement(typeVar.getName(), typeVar);
        }
        for (DartTypeParameter dartTypeParameter : node.getTypeParameters()) {
            dartTypeParameter.accept(this);
        }
        return null;
    }

    void bindTypeVariable(TypeVariableElement variable) {
        Type bound;
        DartTypeParameter typeParameterNode = (DartTypeParameter)variable.getNode();
        DartTypeNode boundNode = typeParameterNode.getBound();
        if (boundNode != null) {
            bound = this.getContext().resolveType(boundNode, true, this.isFactoryContext(), ResolverErrorCode.NO_SUCH_TYPE);
            boundNode.setType(bound);
        } else {
            bound = this.typeProvider.getObjectType();
        }
        variable.setBound(bound);
    }

    abstract boolean isStaticContext();

    abstract boolean isFactoryContext();

    @Override
    public Element visitParameter(DartParameter node) {
        Enum typeErrorCode = node.getParent() instanceof DartCatchBlock ? ResolverErrorCode.NO_SUCH_TYPE : TypeErrorCode.NO_SUCH_TYPE;
        Type type = this.resolveType(node.getTypeNode(), this.isStaticContext(), this.isFactoryContext(), (ErrorCode)((Object)typeErrorCode));
        VariableElement element = Elements.parameterElement(node, node.getParameterName(), node.getModifiers());
        List<DartParameter> functionParameters = node.getFunctionParameters();
        if (functionParameters != null) {
            ArrayList<VariableElement> parameterElements = new ArrayList<VariableElement>(functionParameters.size());
            for (DartParameter parameter : functionParameters) {
                parameterElements.add((VariableElement)parameter.accept(this));
            }
            ClassElement functionElement = this.typeProvider.getFunctionType().getElement();
            type = Types.makeFunctionType(this.getContext(), functionElement, parameterElements, type);
        }
        Elements.setType(element, type);
        return this.recordElement(node, element);
    }

    final Type resolveType(DartTypeNode node, boolean isStatic, boolean isFactory, ErrorCode errorCode) {
        if (node == null) {
            return this.getTypeProvider().getDynamicType();
        }
        assert (node.getType() == null || node.getType() instanceof DynamicType);
        Type type = this.getContext().resolveType(node, isStatic, isFactory, errorCode);
        if (type == null) {
            type = this.getTypeProvider().getDynamicType();
        }
        node.setType(type);
        this.recordElement(node.getIdentifier(), type.getElement());
        return type;
    }

    protected <E extends Element> E recordElement(DartNode node, E element) {
        node.getClass();
        if (element == null) {
            return null;
        }
        node.setSymbol(element);
        return element;
    }

    CoreTypeProvider getTypeProvider() {
        return this.typeProvider;
    }
}

