/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.jet.internal.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilationError;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionTypeAlias;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNodeTraverser;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPropertyAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassScope;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CoreTypeProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Elements;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ResolutionErrorListener;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ResolverErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Scope;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.TypeErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.TypeVariableElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeVariable;

@VisibleForTesting
public class ResolutionContext
implements ResolutionErrorListener {
    private Scope scope;
    private final DartCompilerContext context;
    private final CoreTypeProvider typeProvider;

    @VisibleForTesting
    public ResolutionContext(Scope scope, DartCompilerContext context, CoreTypeProvider typeProvider) {
        this.scope = scope;
        this.context = context;
        this.typeProvider = typeProvider;
    }

    @VisibleForTesting
    public ResolutionContext extend(ClassElement element) {
        return new ResolutionContext(new ClassScope(element, this.scope), this.context, this.typeProvider);
    }

    ResolutionContext extend(String name) {
        return new ResolutionContext(new Scope(name, this.scope.getLibrary(), this.scope), this.context, this.typeProvider);
    }

    Scope getScope() {
        return this.scope;
    }

    void declare(Element element, ErrorCode errorCode, ErrorCode warningCode) {
        Element existingElement;
        String name = element.getName();
        Element existingLocalElement = this.scope.findLocalElement(name);
        if (!(existingLocalElement != null || warningCode == null || (existingElement = this.scope.findElement(this.scope.getLibrary(), name)) == null || Elements.isConstructorParameter(element) || Elements.isParameterOfMethodWithoutBody(element) || Elements.isStaticContext(element) && !Elements.isStaticContext(existingElement) || existingElement.getModifiers().isAbstractField())) {
            DartNode nameNode = Elements.getNameNode(element);
            String existingLocation = Elements.getRelativeElementLocation(element, existingElement);
            this.onError(nameNode, warningCode, name, existingElement, existingLocation);
        }
        if (existingLocalElement != null && errorCode != null) {
            DartNode nameNode = Elements.getNameNode(element);
            String existingLocation = Elements.getRelativeElementLocation(element, existingLocalElement);
            this.onError(nameNode, errorCode, name, existingLocation);
        }
        this.scope.declareElement(name, element);
    }

    void pushScope(String name) {
        this.scope = new Scope(name, this.scope.getLibrary(), this.scope);
    }

    void popScope() {
        this.scope = this.scope.getParent();
    }

    private boolean isInterfaceEquals(Type type, boolean isInterface) {
        switch (type.getKind()) {
            case DYNAMIC: {
                return true;
            }
            case INTERFACE: {
                InterfaceType interfaceType = (InterfaceType)type;
                ClassElement element = interfaceType.getElement();
                return element != null && element.isInterface() == isInterface;
            }
        }
        return false;
    }

    private boolean isClassType(Type type) {
        return this.isInterfaceEquals(type, false);
    }

    private boolean isClassOrInterfaceType(Type type) {
        return type.getKind() == TypeKind.INTERFACE && ((InterfaceType)type).getElement() != null;
    }

    InterfaceType resolveClass(DartTypeNode node, boolean isStatic, boolean isFactory) {
        if (node == null) {
            return null;
        }
        Type type = this.resolveType(node, isStatic, isFactory, ResolverErrorCode.NO_SUCH_TYPE);
        if (!this.isClassType(type)) {
            this.onError(node.getIdentifier(), ResolverErrorCode.NOT_A_CLASS, type);
            type = this.typeProvider.getDynamicType();
        }
        node.setType(type);
        return (InterfaceType)type;
    }

    InterfaceType resolveInterface(DartTypeNode node, boolean isStatic, boolean isFactory) {
        Type type = this.resolveType(node, isStatic, isFactory, ResolverErrorCode.NO_SUCH_TYPE);
        if (type.getKind() != TypeKind.DYNAMIC && !this.isClassOrInterfaceType(type)) {
            this.onError(node.getIdentifier(), ResolverErrorCode.NOT_A_CLASS_OR_INTERFACE, type);
            type = this.typeProvider.getDynamicType();
        }
        node.setType(type);
        return (InterfaceType)type;
    }

    Type resolveType(DartTypeNode node, boolean isStatic, boolean isFactory, ErrorCode errorCode) {
        if (node == null) {
            return null;
        }
        return this.resolveType(node, node.getIdentifier(), node.getTypeArguments(), isStatic, isFactory, errorCode);
    }

    Type resolveType(DartNode diagnosticNode, DartNode identifier, List<DartTypeNode> typeArguments, boolean isStatic, boolean isFactory, ErrorCode errorCode) {
        Element element = this.resolveName(identifier);
        ElementKind elementKind = ElementKind.of(element);
        switch (elementKind) {
            case TYPE_VARIABLE: {
                TypeVariableElement typeVariableElement = (TypeVariableElement)element;
                if (!isFactory && isStatic && typeVariableElement.getDeclaringElement().getKind().equals((Object)ElementKind.CLASS)) {
                    this.onError(identifier, ResolverErrorCode.TYPE_VARIABLE_IN_STATIC_CONTEXT, identifier);
                    return this.typeProvider.getDynamicType();
                }
                return this.makeTypeVariable(typeVariableElement, typeArguments);
            }
            case CLASS: 
            case FUNCTION_TYPE_ALIAS: {
                return this.instantiateParameterizedType((ClassElement)element, diagnosticNode, typeArguments, isStatic, isFactory, errorCode);
            }
            case NONE: {
                if (identifier.toString().equals("void")) {
                    return this.typeProvider.getVoidType();
                }
                if (!identifier.toString().equals("Dynamic")) break;
                return this.typeProvider.getDynamicType();
            }
            default: {
                this.onError(identifier, TypeErrorCode.NOT_A_TYPE, new Object[]{identifier, elementKind});
            }
        }
        this.onError(identifier, errorCode, identifier);
        return this.typeProvider.getDynamicType();
    }

    InterfaceType instantiateParameterizedType(ClassElement element, DartNode node, List<DartTypeNode> typeArgumentNodes, boolean isStatic, boolean isFactory, ErrorCode errorCode) {
        Type[] typeArguments;
        List<? extends Type> typeParameters;
        block6: {
            block5: {
                typeParameters = element.getTypeParameters();
                if (typeArgumentNodes != null && typeArgumentNodes.size() == typeParameters.size()) break block5;
                typeArguments = new Type[typeParameters.size()];
                for (int i = 0; i < typeArguments.length; ++i) {
                    typeArguments[i] = this.typeProvider.getDynamicType();
                }
                if (typeArgumentNodes != null && typeArgumentNodes.size() > 0) {
                    Enum wrongNumberErrorCode = errorCode instanceof ResolverErrorCode ? ResolverErrorCode.WRONG_NUMBER_OF_TYPE_ARGUMENTS : TypeErrorCode.WRONG_NUMBER_OF_TYPE_ARGUMENTS;
                    this.onError(node, (ErrorCode)((Object)wrongNumberErrorCode), new Object[]{element.getType(), typeParameters.size()});
                }
                int index = 0;
                if (typeArgumentNodes == null) break block6;
                for (DartTypeNode typeNode : typeArgumentNodes) {
                    Type type = this.resolveType(typeNode, isStatic, isFactory, errorCode);
                    typeNode.setType(type);
                    if (index < typeArguments.length) {
                        typeArguments[index] = type;
                    }
                    ++index;
                }
                break block6;
            }
            typeArguments = new Type[typeArgumentNodes.size()];
            for (int i = 0; i < typeArguments.length; ++i) {
                typeArguments[i] = this.resolveType(typeArgumentNodes.get(i), isStatic, isFactory, errorCode);
                typeArgumentNodes.get(i).setType(typeArguments[i]);
            }
        }
        return element.getType().subst(Arrays.asList(typeArguments), typeParameters);
    }

    private TypeVariable makeTypeVariable(TypeVariableElement element, List<DartTypeNode> typeArguments) {
        for (DartTypeNode typeArgument : typeArguments) {
            this.onError(typeArgument, ResolverErrorCode.EXTRA_TYPE_ARGUMENT, new Object[0]);
        }
        return element.getTypeVariable();
    }

    Element resolveName(DartNode node) {
        return node.accept(new Selector());
    }

    MethodElement declareFunction(DartFunctionExpression node) {
        MethodElement element = Elements.methodFromFunctionExpression(node, Modifiers.NONE);
        if (node.getFunctionName() != null) {
            this.declare(element, ResolverErrorCode.DUPLICATE_FUNCTION_EXPRESSION, ResolverErrorCode.DUPLICATE_FUNCTION_EXPRESSION_WARNING);
        }
        return element;
    }

    void pushFunctionScope(DartFunctionExpression x) {
        this.pushScope(x.getFunctionName() == null ? "<function>" : x.getFunctionName());
    }

    void pushFunctionAliasScope(DartFunctionTypeAlias x) {
        this.pushScope(((DartIdentifier)x.getName()).getTargetName() == null ? "<function>" : ((DartIdentifier)x.getName()).getTargetName());
    }

    AssertionError internalError(DartNode node, String message, Object ... arguments) {
        message = String.format(message, arguments);
        this.context.onError(new DartCompilationError(node, (ErrorCode)ResolverErrorCode.INTERNAL_ERROR, message));
        return new AssertionError((Object)("Internal error: " + message));
    }

    @Override
    public void onError(DartNode node, ErrorCode errorCode, Object ... arguments) {
        this.context.onError(new DartCompilationError(node, errorCode, arguments));
    }

    public boolean shouldWarnOnNoSuchType() {
        return this.context.shouldWarnOnNoSuchType();
    }

    class Selector
    extends DartNodeTraverser<Element> {
        Selector() {
        }

        @Override
        public Element visitNode(DartNode node) {
            throw ResolutionContext.this.internalError(node, "Unexpected node: %s", node);
        }

        @Override
        public Element visitPropertyAccess(DartPropertyAccess node) {
            Element element = node.getQualifier().accept(this);
            if (element != null) {
                switch (element.getKind()) {
                    case LIBRARY: {
                        Scope elementScope = ((LibraryElement)element).getScope();
                        return elementScope.findElement(ResolutionContext.this.scope.getLibrary(), node.getPropertyName());
                    }
                    case CLASS: {
                        return Elements.findElement((ClassElement)element, node.getPropertyName());
                    }
                }
            }
            return null;
        }

        @Override
        public Element visitIdentifier(DartIdentifier node) {
            String name = node.getTargetName();
            return ResolutionContext.this.scope.findElement(ResolutionContext.this.scope.getLibrary(), name);
        }
    }
}

