/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.jet.internal.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.AbstractElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.EnclosingElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.VariableElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.FunctionType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;

class MethodElementImplementation
extends AbstractElement
implements MethodElement {
    private final Modifiers modifiers;
    private final EnclosingElement holder;
    private final ElementKind kind;
    private final List<VariableElement> parameters = new ArrayList<VariableElement>();
    private FunctionType type;

    @VisibleForTesting
    MethodElementImplementation(DartFunctionExpression node, String name, Modifiers modifiers) {
        super(node, name);
        this.modifiers = modifiers;
        this.holder = MethodElementImplementation.findParentEnclosingElement(node);
        this.kind = ElementKind.FUNCTION_OBJECT;
    }

    protected MethodElementImplementation(DartMethodDefinition node, String name, EnclosingElement holder) {
        super(node, name);
        this.modifiers = node != null ? node.getModifiers() : Modifiers.NONE;
        this.holder = holder;
        this.kind = ElementKind.METHOD;
    }

    protected MethodElementImplementation(String name, EnclosingElement holder, Modifiers modifiers) {
        super(null, name);
        this.modifiers = modifiers;
        this.holder = holder;
        this.kind = ElementKind.METHOD;
    }

    @Override
    public Modifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public ElementKind getKind() {
        return this.kind;
    }

    @Override
    public EnclosingElement getEnclosingElement() {
        return this.holder;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return this.getModifiers().isStatic();
    }

    @Override
    public List<VariableElement> getParameters() {
        return this.parameters;
    }

    void addParameter(VariableElement parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public Type getReturnType() {
        return this.getType().getReturnType();
    }

    @Override
    void setType(Type type) {
        this.type = (FunctionType)type;
    }

    @Override
    public FunctionType getType() {
        return this.type;
    }

    @Override
    public FunctionType getFunctionType() {
        return this.getType();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public Iterable<Element> getMembers() {
        return Collections.emptyList();
    }

    @Override
    public Element lookupLocalElement(String name) {
        return null;
    }

    public static MethodElementImplementation fromMethodNode(DartMethodDefinition node, EnclosingElement holder) {
        String targetName = node.getName() instanceof DartIdentifier ? ((DartIdentifier)node.getName()).getTargetName() : node.toSource();
        return new MethodElementImplementation(node, targetName, holder);
    }

    public static MethodElementImplementation fromFunctionExpression(DartFunctionExpression node, Modifiers modifiers) {
        return new MethodElementImplementation(node, node.getFunctionName(), modifiers);
    }

    private static EnclosingElement findParentEnclosingElement(DartNode node) {
        while (node != null && node.getParent() != null) {
            if (!((node = node.getParent()).getSymbol() instanceof EnclosingElement)) continue;
            return (EnclosingElement)node.getSymbol();
        }
        return null;
    }
}

