/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import java.util.Collection;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.LibraryUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.AbstractElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FieldElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Scope;

class LibraryElementImplementation
extends AbstractElement
implements LibraryElement {
    private final Scope scope = new Scope("library", this);
    private LibraryUnit libraryUnit;
    private MethodElement entryPoint;

    public LibraryElementImplementation(LibraryUnit libraryUnit) {
        super(null, libraryUnit.getSource().getName());
        this.libraryUnit = libraryUnit;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.LIBRARY;
    }

    @Override
    public LibraryUnit getLibraryUnit() {
        return this.libraryUnit;
    }

    @Override
    public void setEntryPoint(MethodElement element) {
        this.entryPoint = element;
    }

    @Override
    public MethodElement getEntryPoint() {
        return this.entryPoint;
    }

    public Collection<Element> getMembers() {
        return this.scope.getElements().values();
    }

    @Override
    public Element lookupLocalElement(String name) {
        return this.scope.findLocalElement(name);
    }

    void addField(FieldElement field) {
        this.scope.declareElement(field.getName(), field);
    }

    void addMethod(MethodElement method) {
        this.scope.declareElement(method.getName(), method);
    }
}

