/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartField;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.AbstractElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.EnclosingElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FieldElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;

class FieldElementImplementation
extends AbstractElement
implements FieldElement {
    private final EnclosingElement holder;
    private Modifiers modifiers;
    private Type type;
    private MethodElement getter;
    private MethodElement setter;

    FieldElementImplementation(DartNode node, String name, EnclosingElement holder, Modifiers modifiers) {
        super(node, name);
        this.holder = holder;
        this.modifiers = modifiers;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.FIELD;
    }

    @Override
    public EnclosingElement getEnclosingElement() {
        return this.holder;
    }

    @Override
    public Modifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean isStatic() {
        return this.modifiers.isStatic();
    }

    public static FieldElementImplementation fromNode(DartField node, EnclosingElement holder, Modifiers modifiers) {
        return new FieldElementImplementation(node, ((DartIdentifier)node.getName()).getTargetName(), holder, modifiers);
    }

    public static FieldElementImplementation fromNode(DartMethodDefinition node, EnclosingElement holder, Modifiers modifiers) {
        return new FieldElementImplementation(node, ((DartIdentifier)node.getName()).getTargetName(), holder, modifiers);
    }

    @Override
    public MethodElement getGetter() {
        return this.getter;
    }

    @Override
    public MethodElement getSetter() {
        return this.setter;
    }

    void setGetter(MethodElement getter) {
        this.getter = getter;
    }

    void setSetter(MethodElement setter) {
        this.setter = setter;
    }
}

