/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.jet.internal.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.Source;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClassMember;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDeclaration;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartField;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionTypeAlias;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartLabel;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNativeBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParameterizedTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPropertyAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSuperExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVariable;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.LibraryUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.SourceInfo;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.AbstractElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElementImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ConstructorElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ConstructorElementImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.DynamicElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.DynamicElementImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.EnclosingElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FieldElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FieldElementImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FunctionAliasElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FunctionAliasElementImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LabelElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LabelElementImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElementImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElementImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.SuperElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.SuperElementImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.TypeVariableElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.TypeVariableElementImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.VariableElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.VariableElementImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.VoidElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeVariable;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.Paths;

public class Elements {
    private Elements() {
    }

    static void setParameterInitializerElement(VariableElement varElement, FieldElement element) {
        ((VariableElementImplementation)varElement).setParameterInitializerElement(element);
    }

    static void setDefaultClass(ClassElement classElement, InterfaceType defaultClass) {
        ((ClassElementImplementation)classElement).setDefaultClass(defaultClass);
    }

    static void addInterface(ClassElement classElement, InterfaceType type) {
        ((ClassElementImplementation)classElement).addInterface(type);
    }

    static LabelElement labelElement(DartLabel node, String name, MethodElement enclosingFunction) {
        return new LabelElementImplementation(node, name, enclosingFunction);
    }

    public static LibraryElement libraryElement(LibraryUnit libraryUnit) {
        return new LibraryElementImplementation(libraryUnit);
    }

    public static LibraryElement getLibraryElement(Element element) {
        while (!ElementKind.of(element).equals((Object)ElementKind.LIBRARY) && (element = element.getEnclosingElement()) != null && element.getEnclosingElement() != element) {
        }
        return (LibraryElement)element;
    }

    @VisibleForTesting
    public static MethodElement methodElement(DartFunctionExpression node, String name) {
        return new MethodElementImplementation(node, name, Modifiers.NONE);
    }

    public static TypeVariableElement typeVariableElement(DartNode node, String name, Element owner) {
        return new TypeVariableElementImplementation(node, name, owner);
    }

    public static VariableElement variableElement(DartVariable node, String name, Modifiers modifiers) {
        return new VariableElementImplementation(node, name, ElementKind.VARIABLE, modifiers, false, null);
    }

    public static VariableElement parameterElement(DartParameter node, String name, Modifiers modifiers) {
        return new VariableElementImplementation(node, name, ElementKind.PARAMETER, modifiers, node.getModifiers().isNamed(), node.getDefaultExpr());
    }

    public static VariableElement makeVariable(String name) {
        return new VariableElementImplementation(null, name, ElementKind.VARIABLE, Modifiers.NONE, false, null);
    }

    public static SuperElement superElement(DartSuperExpression node, ClassElement cls) {
        return new SuperElementImplementation(node, cls);
    }

    static void addConstructor(ClassElement cls, ConstructorElement constructor) {
        ((ClassElementImplementation)cls).addConstructor(constructor);
    }

    static void addField(EnclosingElement holder, FieldElement field) {
        if (ElementKind.of(holder).equals((Object)ElementKind.CLASS)) {
            ((ClassElementImplementation)holder).addField(field);
        } else if (ElementKind.of(holder).equals((Object)ElementKind.LIBRARY)) {
            ((LibraryElementImplementation)holder).addField(field);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @VisibleForTesting
    public static void addMethod(EnclosingElement holder, MethodElement method) {
        if (ElementKind.of(holder).equals((Object)ElementKind.CLASS)) {
            ((ClassElementImplementation)holder).addMethod(method);
        } else if (ElementKind.of(holder).equals((Object)ElementKind.LIBRARY)) {
            ((LibraryElementImplementation)holder).addMethod(method);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static void addParameter(MethodElement method, VariableElement parameter) {
        ((MethodElementImplementation)method).addParameter(parameter);
    }

    static Element findElement(ClassElement cls, String name) {
        if (cls instanceof ClassElementImplementation) {
            return ((ClassElementImplementation)cls).findElement(name);
        }
        return null;
    }

    public static MethodElement methodFromFunctionExpression(DartFunctionExpression node, Modifiers modifiers) {
        return MethodElementImplementation.fromFunctionExpression(node, modifiers);
    }

    @VisibleForTesting
    public static MethodElement methodFromMethodNode(DartMethodDefinition node, EnclosingElement holder) {
        return MethodElementImplementation.fromMethodNode(node, holder);
    }

    static ConstructorElement constructorFromMethodNode(DartMethodDefinition node, String name, ClassElement declaringClass, ClassElement constructorType) {
        return ConstructorElementImplementation.fromMethodNode(node, name, declaringClass, constructorType);
    }

    @VisibleForTesting
    public static void setType(Element element, Type type) {
        ((AbstractElement)element).setType(type);
    }

    static FieldElementImplementation fieldFromNode(DartField node, EnclosingElement holder, Modifiers modifiers) {
        return FieldElementImplementation.fromNode(node, holder, modifiers);
    }

    static ClassElement classFromNode(DartClass node, LibraryElement library) {
        return ClassElementImplementation.fromNode(node, library);
    }

    public static ClassElement classNamed(String name) {
        return ClassElementImplementation.named(name);
    }

    static TypeVariableElement typeVariableFromNode(DartTypeParameter node, Element element) {
        return TypeVariableElementImplementation.fromNode(node, element);
    }

    public static DynamicElement dynamicElement() {
        return DynamicElementImplementation.getInstance();
    }

    static ConstructorElement lookupConstructor(ClassElement cls, String name) {
        if (cls instanceof ClassElementImplementation) {
            return ((ClassElementImplementation)cls).lookupConstructor(name);
        }
        return null;
    }

    public static MethodElement lookupLocalMethod(ClassElement cls, String name) {
        return ((ClassElementImplementation)cls).lookupLocalMethod(name);
    }

    public static FieldElement lookupLocalField(ClassElement cls, String name) {
        return ((ClassElementImplementation)cls).lookupLocalField(name);
    }

    public static FunctionAliasElement functionTypeAliasFromNode(DartFunctionTypeAlias node, LibraryElement library) {
        return FunctionAliasElementImplementation.fromNode(node, library);
    }

    public static boolean isConstructorParameter(Element element) {
        DartMethodDefinition parentMethod;
        DartNode parentNode;
        return element instanceof VariableElement && (parentNode = element.getNode().getParent()) instanceof DartFunction && parentNode.getParent() instanceof DartMethodDefinition && (parentMethod = (DartMethodDefinition)parentNode.getParent()).getSymbol().isConstructor();
    }

    public static boolean isParameterOfSameNameSetter(Element element) {
        DartMethodDefinition parentMethod;
        DartNode parentNode;
        return element instanceof VariableElement && (parentNode = element.getNode().getParent()) instanceof DartFunction && parentNode.getParent() instanceof DartMethodDefinition && (parentMethod = (DartMethodDefinition)parentNode.getParent()).getSymbol().getName().equals(element.getName());
    }

    public static boolean isParameterOfMethodWithoutBody(Element element) {
        DartFunction parentFunction;
        DartNode parentNode;
        return element instanceof VariableElementImplementation && (parentNode = element.getNode().getParent()) instanceof DartFunction && ((parentFunction = (DartFunction)parentNode).getBody() == null || parentFunction.getBody() instanceof DartNativeBlock);
    }

    public static boolean isStaticContext(Element element) {
        for (DartNode node = element.getNode(); node != null; node = node.getParent()) {
            if (node instanceof DartUnit) {
                return true;
            }
            if (node instanceof DartClass) break;
            if (!(node instanceof DartClassMember) || !((DartClassMember)node).getModifiers().isStatic()) continue;
            return true;
        }
        return false;
    }

    public static boolean isNonFactoryConstructor(Element method) {
        return !method.getModifiers().isFactory() && ElementKind.of(method).equals((Object)ElementKind.CONSTRUCTOR);
    }

    public static boolean isTopLevel(Element element) {
        return ElementKind.of(element.getEnclosingElement()).equals((Object)ElementKind.LIBRARY);
    }

    static List<TypeVariable> makeTypeVariables(List<DartTypeParameter> parameterNodes, Element element) {
        if (parameterNodes == null) {
            return Arrays.asList(new TypeVariable[0]);
        }
        TypeVariable[] typeVariables = new TypeVariable[parameterNodes.size()];
        int i = 0;
        for (DartTypeParameter parameterNode : parameterNodes) {
            typeVariables[i++] = Elements.typeVariableFromNode(parameterNode, element).getTypeVariable();
        }
        return Arrays.asList(typeVariables);
    }

    public static Element voidElement() {
        return VoidElement.getInstance();
    }

    public static boolean needsImplicitDefaultConstructor(ClassElement classElement) {
        return !classElement.isObject() && classElement.getConstructors().isEmpty() && (!classElement.isInterface() || classElement.getDefaultClass() != null);
    }

    public static boolean implementsType(ClassElement classElement, ClassElement interfaceElement) {
        try {
            for (InterfaceType supertype : classElement.getAllSupertypes()) {
                if (!supertype.getElement().equals(interfaceElement)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static String getRawMethodName(MethodElement methodElement) {
        DartMethodDefinition method = (DartMethodDefinition)methodElement.getNode();
        if (method == null) {
            return methodElement.getEnclosingElement().getName();
        }
        Object nameExpression = method.getName();
        return Elements.getRawName(nameExpression);
    }

    private static String getRawName(DartNode name) {
        if (name instanceof DartIdentifier) {
            return ((DartIdentifier)name).getTargetName();
        }
        if (name instanceof DartParameterizedTypeNode) {
            return Elements.getRawName(((DartParameterizedTypeNode)name).getExpression());
        }
        DartPropertyAccess propertyAccess = (DartPropertyAccess)name;
        return Elements.getRawName(propertyAccess.getQualifier()) + "." + Elements.getRawName(propertyAccess.getName());
    }

    public static int getNumberOfRequiredParameters(MethodElement method) {
        int num = 0;
        List<VariableElement> parameters = method.getParameters();
        for (VariableElement parameter : parameters) {
            if (parameter.isNamed()) continue;
            ++num;
        }
        return num;
    }

    public static List<String> getNamedParameters(MethodElement method) {
        ArrayList<String> names = Lists.newArrayList();
        List<VariableElement> parameters = method.getParameters();
        for (VariableElement parameter : parameters) {
            if (!parameter.isNamed()) continue;
            names.add(parameter.getName());
        }
        return names;
    }

    public static List<String> getParameterTypeNames(MethodElement method) {
        ArrayList<String> names = Lists.newArrayList();
        List<VariableElement> parameters = method.getParameters();
        for (VariableElement parameter : parameters) {
            String typeName = parameter.getType().getElement().getName();
            names.add(typeName);
        }
        return names;
    }

    public static DartNode getNameNode(Element element) {
        DartNode node = element.getNode();
        if (node instanceof DartDeclaration) {
            node = ((DartDeclaration)node).getName();
        }
        if (node instanceof DartFunctionExpression) {
            node = ((DartFunctionExpression)node).getName();
        }
        return node;
    }

    public static String getRelativeElementLocation(Element source, Element target) {
        DartNode targetNode = Elements.getNameNode(target);
        if (targetNode == null) {
            return "unknown";
        }
        SourceInfo targetInfo = targetNode.getSourceInfo();
        SourceInfo sourceInfo = source.getNode().getSourceInfo();
        String sourceName = Elements.getSourceName(sourceInfo);
        String targetName = Elements.getSourceName(targetInfo);
        String relativePath = Paths.relativePathFor(new File(sourceName), new File(targetName));
        ClassElement targetClass = Elements.getEnclosingClassElement(target);
        String targetClassName = targetClass != null ? targetClass.getName() : "";
        return MessageFormat.format("{0}:{1}:{2}:{3}", relativePath, targetClassName, targetInfo.getSourceLine(), targetInfo.getSourceColumn());
    }

    private static String getSourceName(SourceInfo sourceInfo) {
        Source source = sourceInfo.getSource();
        if (source != null) {
            return source.getName();
        }
        return "";
    }

    public static ClassElement getEnclosingClassElement(Element element) {
        for (DartNode node = element.getNode(); node != null; node = node.getParent()) {
            if (!(node instanceof DartClass)) continue;
            return ((DartClass)node).getSymbol();
        }
        return null;
    }
}

