/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ConstructorElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElementImplementation;

class ConstructorElementImplementation
extends MethodElementImplementation
implements ConstructorElement {
    private final ClassElement constructorType;
    private ConstructorElement defaultConstructor;

    private ConstructorElementImplementation(DartMethodDefinition node, String name, ClassElement declaringClass, ClassElement constructorType) {
        super(node, name, declaringClass);
        this.constructorType = constructorType;
    }

    private ConstructorElementImplementation(String name, ClassElement declaringClass, ClassElement constructorType) {
        super(name, declaringClass, Modifiers.NONE.makeFactory());
        this.constructorType = constructorType;
    }

    @Override
    public ClassElement getConstructorType() {
        return this.constructorType;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.CONSTRUCTOR;
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    @Override
    public ConstructorElement getDefaultConstructor() {
        return this.defaultConstructor;
    }

    @Override
    public void setDefaultConstructor(ConstructorElement defaultConstructor) {
        this.defaultConstructor = defaultConstructor;
    }

    public static ConstructorElementImplementation fromMethodNode(DartMethodDefinition node, String name, ClassElement declaringClass, ClassElement constructorType) {
        return new ConstructorElementImplementation(node, name, declaringClass, constructorType);
    }

    public static ConstructorElementImplementation named(String name, ClassElement declaringClass, ClassElement constructorType) {
        return new ConstructorElementImplementation(name, declaringClass, constructorType);
    }
}

