/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import java.util.List;
import org.jetbrains.jet.internal.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartField;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNewExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNodeTraverser;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPropertyAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartRedirectConstructorInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSuperConstructorInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVariable;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVariableStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ConstructorElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CoreTypeProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Elements;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.EnclosingElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ResolutionContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ResolveVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Scope;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;

public class CompileTimeConstantResolver {
    public void exec(DartUnit unit, DartCompilerContext compilerContext, CoreTypeProvider typeProvider) {
        this.exec(unit, compilerContext, unit.getLibrary().getElement().getScope(), typeProvider);
    }

    @VisibleForTesting
    public void exec(DartUnit unit, DartCompilerContext compilerContext, Scope scope, CoreTypeProvider typeProvider) {
        unit.accept(new ConstResolveVisitor(unit, compilerContext, scope, typeProvider));
    }

    private class ConstResolveVisitor
    extends ResolveVisitor {
        private final LibraryElement libraryElement;
        private EnclosingElement currentHolder;
        private final ResolutionContext topLevelContext;
        private ResolutionContext context;

        private ConstResolveVisitor(DartUnit unit, DartCompilerContext compilerContext, Scope scope, CoreTypeProvider typeProvider) {
            super(typeProvider);
            this.libraryElement = unit.getLibrary() == null ? null : unit.getLibrary().getElement();
            this.topLevelContext = this.context = new ResolutionContext(scope, compilerContext, typeProvider);
            this.currentHolder = this.libraryElement;
        }

        private void beginClassContext(DartClass node) {
            assert (!ElementKind.of(this.currentHolder).equals((Object)ElementKind.CLASS)) : "nested class?";
            this.currentHolder = node.getSymbol();
            this.context = this.context.extend((ClassElement)this.currentHolder);
        }

        private void endClassContext() {
            this.currentHolder = this.libraryElement;
            this.context = this.topLevelContext;
        }

        @Override
        ResolutionContext getContext() {
            return this.context;
        }

        @Override
        boolean isStaticContext() {
            return true;
        }

        @Override
        boolean isFactoryContext() {
            return false;
        }

        private void resolveConstantExpression(DartExpression expression) {
            if (expression != null) {
                expression.accept(new ConstExpressionVisitor());
            }
        }

        @Override
        public Element visitClass(DartClass node) {
            assert (!ElementKind.of(this.currentHolder).equals((Object)ElementKind.CLASS)) : "nested class?";
            this.beginClassContext(node);
            this.visit(node.getMembers());
            this.endClassContext();
            return null;
        }

        @Override
        public Element visitField(DartField node) {
            this.resolveConstantExpression(node.getValue());
            return null;
        }

        @Override
        public Element visitMethodDefinition(DartMethodDefinition node) {
            MethodElement member = node.getSymbol();
            ResolutionContext previousContext = this.context;
            this.context = this.context.extend(member.getName());
            DartFunction functionNode = node.getFunction();
            List<DartParameter> parameters = functionNode.getParams();
            for (DartParameter parameter : parameters) {
                this.getContext().declare(parameter.getSymbol(), null, null);
                this.resolveConstantExpression(parameter.getDefaultExpr());
            }
            MethodElement element = node.getSymbol();
            if (ElementKind.of(element) == ElementKind.CONSTRUCTOR && node.getModifiers().isConstant()) {
                for (DartInitializer initializer : node.getInitializers()) {
                    DartExpression initializerValue = initializer.getValue();
                    this.resolveConstantExpression(initializerValue);
                }
            }
            this.context = previousContext;
            return null;
        }

        @Override
        public Element visitNewExpression(DartNewExpression node) {
            if (node.isConst()) {
                for (DartExpression arg : node.getArgs()) {
                    this.resolveConstantExpression(arg);
                }
            }
            return null;
        }

        @Override
        public Element visitParameter(DartParameter node) {
            this.resolveConstantExpression(node.getDefaultExpr());
            return null;
        }

        @Override
        public Element visitVariableStatement(DartVariableStatement node) {
            for (DartVariable variable : node.getVariables()) {
                Modifiers modifiers = node.getModifiers();
                if (!modifiers.isStatic() || !modifiers.isFinal() || variable.getValue() == null) continue;
                this.resolveConstantExpression(variable.getValue());
            }
            return null;
        }

        private class ConstExpressionVisitor
        extends DartNodeTraverser<Void> {
            private ConstExpressionVisitor() {
            }

            @Override
            public Void visitPropertyAccess(DartPropertyAccess x) {
                DartNode qualifierNode = x.getQualifier();
                Element qualifier = null;
                if (qualifierNode instanceof DartIdentifier) {
                    DartIdentifier qualifierIdent = (DartIdentifier)qualifierNode;
                    qualifier = ConstResolveVisitor.this.getContext().getScope().findElement(ConstResolveVisitor.this.libraryElement, qualifierIdent.getTargetName());
                    qualifierNode.setSymbol(qualifier);
                }
                if (qualifier != null) {
                    Element element = null;
                    switch (ElementKind.of(qualifier)) {
                        case CLASS: {
                            element = Elements.findElement((ClassElement)qualifier, x.getPropertyName());
                            break;
                        }
                        case LIBRARY: {
                            Scope scope = ((LibraryElement)qualifier).getScope();
                            element = scope.findElement(scope.getLibrary(), x.getPropertyName());
                            break;
                        }
                    }
                    if (element != null) {
                        ConstResolveVisitor.this.recordElement(x, element);
                    }
                }
                return null;
            }

            @Override
            public Void visitIdentifier(DartIdentifier x) {
                x.visitChildren(this);
                Element element = ConstResolveVisitor.this.getContext().getScope().findElement(ConstResolveVisitor.this.libraryElement, x.getTargetName());
                if (element != null) {
                    ConstResolveVisitor.this.recordElement(x, element);
                }
                return null;
            }

            @Override
            public Void visitSuperConstructorInvocation(DartSuperConstructorInvocation x) {
                ConstructorElement element;
                x.visitChildren(this);
                String name = x.getName() == null ? "" : x.getName().getTargetName();
                InterfaceType supertype = ((ClassElement)ConstResolveVisitor.this.currentHolder).getSupertype();
                ConstructorElement constructorElement = element = supertype == null ? null : Elements.lookupConstructor(supertype.getElement(), name);
                if (element != null) {
                    ConstResolveVisitor.this.recordElement(x, element);
                }
                return null;
            }

            @Override
            public Void visitRedirectConstructorInvocation(DartRedirectConstructorInvocation x) {
                ConstructorElement element;
                x.visitChildren(this);
                String name = x.getName() == null ? "" : x.getName().getTargetName();
                InterfaceType supertype = ((ClassElement)ConstResolveVisitor.this.currentHolder).getSupertype();
                ConstructorElement constructorElement = element = supertype == null ? null : Elements.lookupConstructor(supertype.getElement(), name);
                if (element != null) {
                    ConstResolveVisitor.this.recordElement(x, element);
                }
                return null;
            }
        }
    }
}

