/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Elements;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.EnclosingElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Scope;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;

class ClassScope
extends Scope {
    private final ClassElement classElement;

    ClassScope(ClassElement classElement, Scope parent) {
        super(classElement.getName(), parent.getLibrary(), parent);
        this.classElement = classElement;
    }

    @Override
    public Element declareElement(String name, Element element) {
        throw new AssertionError((Object)"not supported yet");
    }

    @Override
    public Element findElement(LibraryElement inLibrary, String name) {
        Element element = super.findElement(inLibrary, name);
        if (element != null) {
            return element;
        }
        InterfaceType superclass = this.classElement.getSupertype();
        if (superclass != null) {
            EnclosingElement enclosing = superclass.getElement().getEnclosingElement();
            ClassScope scope = new ClassScope(superclass.getElement(), new Scope("library", (LibraryElement)enclosing));
            element = scope.findElement(inLibrary, name);
            switch (ElementKind.of(element)) {
                case TYPE_VARIABLE: {
                    return null;
                }
                case NONE: {
                    break;
                }
                default: {
                    return element;
                }
            }
        }
        for (InterfaceType supertype : this.classElement.getInterfaces()) {
            EnclosingElement enclosing = supertype.getElement().getEnclosingElement();
            ClassScope scope = new ClassScope(supertype.getElement(), new Scope("library", (LibraryElement)enclosing));
            element = scope.findElement(inLibrary, name);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public Element findLocalElement(String name) {
        return Elements.findElement(this.classElement, name);
    }
}

