/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.jet.internal.com.google.common.collect.LinkedHashMultimap;
import org.jetbrains.jet.internal.com.google.common.collect.Multimap;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDeclaration;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartStringLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.AbstractElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ConstructorElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CyclicDeclarationException;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.DuplicatedInterfaceException;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.EnclosingElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FieldElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeKind;

class ClassElementImplementation
extends AbstractElement
implements ClassElement {
    private InterfaceType type;
    private InterfaceType supertype;
    private InterfaceType defaultClass;
    private List<InterfaceType> interfaces;
    private Set<InterfaceType> immediateSubtypes = new HashSet<InterfaceType>();
    private final boolean isInterface;
    private final String nativeName;
    private final Modifiers modifiers;
    private final AtomicReference<List<InterfaceType>> allSupertypes = new AtomicReference();
    private volatile Set<InterfaceType> subtypes;
    private final List<ConstructorElement> constructors;
    private final Multimap<String, Element> members;
    private final LibraryElement library;
    private static ThreadLocal<Set<Element>> seenSupertypes = new ThreadLocal<Set<Element>>(){

        @Override
        protected Set<Element> initialValue() {
            return new HashSet<Element>();
        }
    };

    ClassElementImplementation(DartClass node, String name, String nativeName, LibraryElement library) {
        super(node, name);
        this.nativeName = nativeName;
        this.library = library;
        this.constructors = new ArrayList<ConstructorElement>();
        this.members = LinkedHashMultimap.create();
        this.interfaces = new ArrayList<InterfaceType>();
        if (node != null) {
            this.isInterface = node.isInterface();
            this.modifiers = node.getModifiers();
        } else {
            this.isInterface = false;
            this.modifiers = Modifiers.NONE;
        }
    }

    @Override
    public DartDeclaration<?> getNode() {
        return (DartClass)super.getNode();
    }

    @Override
    public void setType(InterfaceType type) {
        this.type = type;
    }

    @Override
    public InterfaceType getType() {
        return this.type;
    }

    @Override
    public List<? extends Type> getTypeParameters() {
        return this.getType().getArguments();
    }

    private void computeTransitiveSubtypes(Set<InterfaceType> computedSubtypes) {
        if (computedSubtypes.addAll(this.immediateSubtypes)) {
            for (InterfaceType subtype : this.immediateSubtypes) {
                ClassElementImplementation classElement = (ClassElementImplementation)subtype.getElement();
                classElement.computeTransitiveSubtypes(computedSubtypes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InterfaceType> getSubtypes() {
        if (this.subtypes == null) {
            ClassElementImplementation classElementImplementation = this;
            synchronized (classElementImplementation) {
                if (this.subtypes == null) {
                    HashSet<InterfaceType> newSubtypes = new HashSet<InterfaceType>();
                    newSubtypes.add(this.getType());
                    this.computeTransitiveSubtypes(newSubtypes);
                    this.subtypes = newSubtypes;
                }
            }
        }
        return this.subtypes;
    }

    @Override
    public InterfaceType getSupertype() {
        return this.supertype;
    }

    @Override
    public InterfaceType getDefaultClass() {
        return this.defaultClass;
    }

    @Override
    public void setSupertype(InterfaceType supertype) {
        this.supertype = supertype;
        if (TypeKind.of(supertype) == TypeKind.INTERFACE) {
            ClassElementImplementation superClassElement = (ClassElementImplementation)supertype.getElement();
            superClassElement.immediateSubtypes.add(this.getType());
        }
    }

    void setDefaultClass(InterfaceType element) {
        this.defaultClass = element;
    }

    @Override
    public Iterable<Element> getMembers() {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return ClassElementImplementation.this.members.values().iterator();
            }
        };
    }

    @Override
    public List<ConstructorElement> getConstructors() {
        return this.constructors;
    }

    @Override
    public List<InterfaceType> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.CLASS;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public Modifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public LibraryElement getLibrary() {
        return this.library;
    }

    @Override
    public String getNativeName() {
        return this.nativeName;
    }

    void addMethod(MethodElement member) {
        String name = member.getName();
        if (member.getModifiers().isOperator()) {
            name = "operator " + name;
        }
        this.members.put(name, member);
    }

    void addConstructor(ConstructorElement member) {
        this.constructors.add(member);
    }

    void addField(FieldElement member) {
        this.members.put(member.getName(), member);
    }

    void addInterface(InterfaceType type) {
        this.interfaces.add(type);
        if (TypeKind.of(type) == TypeKind.INTERFACE) {
            ClassElementImplementation interfaceElement = (ClassElementImplementation)type.getElement();
            interfaceElement.immediateSubtypes.add(this.getType());
        }
    }

    Element findElement(String name) {
        Element element = this.lookupLocalMethod(name);
        if (element != null) {
            return element;
        }
        element = this.lookupLocalField(name);
        if (element != null) {
            return element;
        }
        if (this.type != null) {
            for (Type type : this.type.getArguments()) {
                if (!type.getElement().getName().equals(name)) continue;
                return type.getElement();
            }
        }
        return null;
    }

    ConstructorElement lookupConstructor(ClassElement type, String name) {
        for (ConstructorElement element : this.constructors) {
            if (!element.getConstructorType().equals(type) || !element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    @Override
    public ConstructorElement lookupConstructor(String name) {
        return this.lookupConstructor(this, name);
    }

    @Override
    public Element lookupLocalElement(String name) {
        Iterator<Element> iterator = this.members.get(name).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    FieldElement lookupLocalField(String name) {
        for (Element element : this.members.get(name)) {
            if (!ElementKind.of(element).equals((Object)ElementKind.FIELD)) continue;
            return (FieldElement)element;
        }
        return null;
    }

    MethodElement lookupLocalMethod(String name) {
        for (Element element : this.members.get(name)) {
            if (!ElementKind.of(element).equals((Object)ElementKind.METHOD)) continue;
            return (MethodElement)element;
        }
        return null;
    }

    public static ClassElementImplementation fromNode(DartClass node, LibraryElement library) {
        DartStringLiteral nativeName = node.getNativeName();
        String nativeNameString = nativeName == null ? null : nativeName.getValue();
        return new ClassElementImplementation(node, node.getClassName(), nativeNameString, library);
    }

    public static ClassElementImplementation named(String name) {
        return new ClassElementImplementation(null, name, null, null);
    }

    @Override
    public boolean isObject() {
        return this.supertype == null;
    }

    @Override
    public boolean isObjectChild() {
        return this.supertype != null && this.supertype.getElement().isObject();
    }

    @Override
    public boolean isAbstract() {
        if (this.modifiers.isAbstract()) {
            return true;
        }
        for (Element element : this.getMembers()) {
            if (!element.getModifiers().isAbstract()) continue;
            return true;
        }
        return false;
    }

    @Override
    public EnclosingElement getEnclosingElement() {
        return this.library;
    }

    @Override
    public List<InterfaceType> getAllSupertypes() throws CyclicDeclarationException, DuplicatedInterfaceException {
        List<InterfaceType> list = this.allSupertypes.get();
        if (list == null) {
            this.allSupertypes.compareAndSet(null, this.computeAllSupertypes());
            list = this.allSupertypes.get();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InterfaceType> computeAllSupertypes() throws CyclicDeclarationException, DuplicatedInterfaceException {
        HashMap<ClassElement, InterfaceType> interfaces = new HashMap<ClassElement, InterfaceType>();
        if (!seenSupertypes.get().add(this)) {
            throw new CyclicDeclarationException(this);
        }
        ArrayList<InterfaceType> supertypes = new ArrayList<InterfaceType>();
        try {
            for (InterfaceType intf : this.getInterfaces()) {
                this.addCheckDuplicated(interfaces, supertypes, intf);
            }
            for (InterfaceType intf : this.getInterfaces()) {
                for (InterfaceType t : intf.getElement().getAllSupertypes()) {
                    if (t.getElement().isObject()) continue;
                    this.addCheckDuplicated(interfaces, supertypes, t.subst(intf.getArguments(), intf.getElement().getTypeParameters()));
                }
            }
            if (this.supertype != null) {
                for (InterfaceType t : this.supertype.getElement().getAllSupertypes()) {
                    if (!t.getElement().isInterface()) continue;
                    this.addCheckDuplicated(interfaces, supertypes, t.subst(this.supertype.getArguments(), this.supertype.getElement().getTypeParameters()));
                }
                supertypes.add(this.supertype);
                for (InterfaceType t : this.supertype.getElement().getAllSupertypes()) {
                    if (t.getElement().isInterface()) continue;
                    supertypes.add(t.subst(this.supertype.getArguments(), this.supertype.getElement().getTypeParameters()));
                }
            }
        }
        finally {
            seenSupertypes.get().remove(this);
        }
        return supertypes;
    }

    private void addCheckDuplicated(Map<ClassElement, InterfaceType> interfaces, ArrayList<InterfaceType> supertypes, InterfaceType intf) throws DuplicatedInterfaceException {
        InterfaceType existing = interfaces.put(intf.getElement(), intf);
        if (existing == null) {
            supertypes.add(intf);
        } else if (!existing.equals(intf)) {
            throw new DuplicatedInterfaceException(existing, intf);
        }
    }
}

