/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.resolver;

import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartLabel;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.EnclosingElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Types;

abstract class AbstractElement
implements Element {
    private DartNode node;
    private final String name;

    AbstractElement(DartNode node, String name) {
        this.node = node;
        this.name = name;
    }

    @Override
    public DartNode getNode() {
        return this.node;
    }

    @Override
    public void setNode(DartLabel node) {
        this.node = node;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOriginalSymbolName() {
        return this.name;
    }

    @Override
    public abstract ElementKind getKind();

    public final String toString() {
        return (Object)((Object)this.getKind()) + " " + this.getName();
    }

    @Override
    public Type getType() {
        return Types.newDynamicType();
    }

    void setType(Type type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public Modifiers getModifiers() {
        return Modifiers.NONE;
    }

    @Override
    public EnclosingElement getEnclosingElement() {
        return null;
    }
}

