/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.parser;

import java.util.HashMap;
import java.util.Map;

public enum Token {
    EOS(null, 0),
    LPAREN("(", 0),
    RPAREN(")", 0),
    LBRACK("[", 0),
    RBRACK("]", 0),
    LBRACE("{", 0),
    RBRACE("}", 0),
    COLON(":", 0),
    SEMICOLON(";", 0),
    PERIOD(".", 0),
    ELLIPSIS("...", 0),
    COMMA(",", 0),
    CONDITIONAL("?", 3),
    ARROW("=>", 0),
    ASSIGN("=", 2),
    ASSIGN_BIT_OR("|=", 2),
    ASSIGN_BIT_XOR("^=", 2),
    ASSIGN_BIT_AND("&=", 2),
    ASSIGN_SHL("<<=", 2),
    ASSIGN_SAR(">>=", 2),
    ASSIGN_SHR(">>>=", 2),
    ASSIGN_ADD("+=", 2),
    ASSIGN_SUB("-=", 2),
    ASSIGN_MUL("*=", 2),
    ASSIGN_DIV("/=", 2),
    ASSIGN_MOD("%=", 2),
    ASSIGN_TRUNC("~/=", 2),
    OR("||", 4),
    AND("&&", 5),
    BIT_OR("|", 6),
    BIT_XOR("^", 7),
    BIT_AND("&", 8),
    SHL("<<", 11),
    SAR(">>", 11),
    SHR(">>>", 11),
    ADD("+", 12),
    SUB("-", 12),
    MUL("*", 13),
    DIV("/", 13),
    TRUNC("~/", 13),
    MOD("%", 13),
    EQ("==", 9),
    NE("!=", 9),
    EQ_STRICT("===", 9),
    NE_STRICT("!==", 9),
    LT("<", 10),
    GT(">", 10),
    LTE("<=", 10),
    GTE(">=", 10),
    IS("is", 10),
    NOT("!", 0),
    BIT_NOT("~", 0),
    INC("++", 0),
    DEC("--", 0),
    INDEX("[]", 0),
    ASSIGN_INDEX("[]=", 0),
    BREAK("break", 0),
    CASE("case", 0),
    CATCH("catch", 0),
    CLASS("class", 0),
    CONST("const", 0),
    CONTINUE("continue", 0),
    DEFAULT("default", 0),
    DO("do", 0),
    ELSE("else", 0),
    FINAL("final", 0),
    FINALLY("finally", 0),
    FOR("for", 0),
    IF("if", 0),
    IN("in", 0),
    NEW("new", 0),
    RETURN("return", 0),
    SUPER("super", 0),
    SWITCH("switch", 0),
    THIS("this", 0),
    THROW("throw", 0),
    TRY("try", 0),
    VAR("var", 0),
    VOID("void", 0),
    WHILE("while", 0),
    NULL_LITERAL("null", 0),
    TRUE_LITERAL("true", 0),
    FALSE_LITERAL("false", 0),
    HEX_LITERAL(null, 0),
    INTEGER_LITERAL(null, 0),
    DOUBLE_LITERAL(null, 0),
    STRING(null, 0),
    STRING_SEGMENT(null, 0),
    STRING_LAST_SEGMENT(null, 0),
    STRING_EMBED_EXP_START(null, 0),
    STRING_EMBED_EXP_END(null, 0),
    LIBRARY("#library", 0),
    IMPORT("#import", 0),
    SOURCE("#source", 0),
    RESOURCE("#resource", 0),
    NATIVE("#native", 0),
    IDENTIFIER(null, 0),
    WHITESPACE(null, 0),
    ILLEGAL(null, 0),
    COMMENT(null, 0),
    NON_TOKEN(null, 0);

    private static Map<String, Token> tokens;
    private final String syntax_;
    private final int precedence_;

    public static Token lookup(String syntax) {
        Token token = tokens.get(syntax);
        if (token == null) {
            return IDENTIFIER;
        }
        return token;
    }

    private Token(String syntax, int precedence) {
        this.syntax_ = syntax;
        this.precedence_ = precedence;
    }

    public Token asBinaryOperator() {
        int ordinal = this.ordinal() - ASSIGN_BIT_OR.ordinal() + BIT_OR.ordinal();
        return Token.values()[ordinal];
    }

    public int getPrecedence() {
        return this.precedence_;
    }

    public String getSyntax() {
        return this.syntax_;
    }

    public boolean isEqualityOperator() {
        int ordinal = this.ordinal();
        return EQ.ordinal() <= ordinal && ordinal <= NE_STRICT.ordinal();
    }

    public boolean isRelationalOperator() {
        int ordinal = this.ordinal();
        return LT.ordinal() <= ordinal && ordinal <= GTE.ordinal();
    }

    public boolean isAssignmentOperator() {
        int ordinal = this.ordinal();
        return ASSIGN.ordinal() <= ordinal && ordinal <= ASSIGN_TRUNC.ordinal();
    }

    public boolean isBinaryOperator() {
        int ordinal = this.ordinal();
        return ASSIGN.ordinal() <= ordinal && ordinal <= IS.ordinal() || ordinal == COMMA.ordinal();
    }

    public boolean isCountOperator() {
        int ordinal = this.ordinal();
        return INC.ordinal() <= ordinal && ordinal <= DEC.ordinal();
    }

    public boolean isUnaryOperator() {
        int ordinal = this.ordinal();
        return NOT.ordinal() <= ordinal && ordinal <= DEC.ordinal();
    }

    public boolean isUserDefinableOperator() {
        int ordinal = this.ordinal();
        return (BIT_OR.ordinal() <= ordinal && ordinal <= GTE.ordinal() || this == BIT_NOT || this == INDEX || this == ASSIGN_INDEX) && this != NE && this != EQ_STRICT && this != NE_STRICT;
    }

    public String toString() {
        String result = this.getSyntax();
        if (result == null) {
            return this.name();
        }
        return result;
    }

    static {
        tokens = new HashMap<String, Token>();
        for (Token tok : Token.values()) {
            if (tok.syntax_ == null) continue;
            tokens.put(tok.syntax_, tok);
        }
    }
}

