/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.parser;

import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilationError;
import org.jetbrains.jet.internal.com.google.dart.compiler.ErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.DartScanner;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.ParserContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.ParserErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.Token;

abstract class AbstractParser {
    protected final ParserContext ctx;
    private int lastErrorPosition = Integer.MIN_VALUE;

    protected AbstractParser(ParserContext ctx) {
        this.ctx = ctx;
    }

    protected boolean EOS() {
        return this.match(Token.EOS) || this.match(Token.ILLEGAL);
    }

    protected boolean expect(Token expectedToken) {
        if (!this.optional(expectedToken)) {
            Token actualToken = this.peek(0);
            this.ctx.advance();
            this.reportUnexpectedToken(this.position(), expectedToken, actualToken);
            return false;
        }
        return true;
    }

    protected String getPeekTokenValue(int n) {
        assert (n >= 0);
        String value = this.ctx.peekTokenString(n);
        return value;
    }

    protected boolean match(Token token) {
        return this.peek(0) == token;
    }

    protected Token next() {
        this.ctx.advance();
        return this.ctx.getCurrentToken();
    }

    protected boolean optionalPseudoKeyword(String keyword) {
        if (!this.peekPseudoKeyword(0, keyword)) {
            return false;
        }
        this.next();
        return true;
    }

    protected boolean optional(Token token) {
        if (this.peek(0) != token) {
            return false;
        }
        this.next();
        return true;
    }

    protected Token peek(int n) {
        return this.ctx.peek(n);
    }

    protected boolean peekPseudoKeyword(int n, String keyword) {
        return this.peek(n) == Token.IDENTIFIER && keyword.equals(this.getPeekTokenValue(n));
    }

    protected DartScanner.Position position() {
        DartScanner.Location tokenLocation = this.ctx.getTokenLocation();
        return tokenLocation != null ? tokenLocation.getBegin() : new DartScanner.Position(0, 1, 1);
    }

    protected void reportError(DartScanner.Position position, ErrorCode errorCode, Object ... arguments) {
        DartScanner.Location location = this.ctx.getTokenLocation();
        if (location.getBegin().getPos() <= this.lastErrorPosition) {
            return;
        }
        DartCompilationError dartError = new DartCompilationError(this.ctx.getSource(), location, errorCode, arguments);
        this.lastErrorPosition = position.getPos();
        this.ctx.error(dartError);
    }

    protected void reportUnexpectedToken(DartScanner.Position position, Token expected, Token actual) {
        if (expected == Token.EOS) {
            this.reportError(position, ParserErrorCode.EXPECTED_EOS, new Object[]{actual});
        } else if (expected == null) {
            this.reportError(position, ParserErrorCode.UNEXPECTED_TOKEN, new Object[]{actual});
        } else {
            this.reportError(position, ParserErrorCode.EXPECTED_TOKEN, new Object[]{actual, expected});
        }
    }

    protected void setPeek(int n, Token token) {
        assert (n == 0);
        this.ctx.replaceNextToken(token);
    }

    protected boolean consume(Token token) {
        boolean result;
        boolean bl = result = this.peek(0) == token;
        assert (result);
        this.next();
        return result;
    }
}

