/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.metrics;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.metrics.SpeedTracerEventType;
import org.jetbrains.jet.internal.org.json.JSONArray;
import org.jetbrains.jet.internal.org.json.JSONException;
import org.jetbrains.jet.internal.org.json.JSONObject;

public final class Tracer {
    private static final String logFile = System.getProperty("dart.speedtracerlog");
    private static final String defaultFormatString = System.getProperty("dart.speedtracerformat");
    private static final boolean logProcessCpuTime = Tracer.getBooleanProperty("dart.speedtracer.logProcessCpuTime");
    private static final boolean logThreadCpuTime = Tracer.getBooleanProperty("dart.speedtracer.logThreadCpuTime");
    private static final boolean logGcTime = Tracer.getBooleanProperty("dart.speedtracer.logGcTime");
    private static final boolean logOverheadTime = Tracer.getBooleanProperty("dart.speedtracer.logOverheadTime");
    private final boolean enabled;
    private final DummyEvent dummyEvent = new DummyEvent();
    private BlockingQueue<TraceEvent> eventsToWrite;
    private final boolean fileLoggingEnabled;
    private CountDownLatch flushLatch;
    private TraceEvent flushSentinel;
    private Format outputFormat;
    private ThreadLocal<Stack<TraceEvent>> pendingEvents;
    private CountDownLatch shutDownLatch;
    private TraceEvent shutDownSentinel;
    private List<GarbageCollectorMXBean> gcMXBeans;
    private Map<String, Long> lastGcTimes;
    private final ElapsedNormalizedTimeKeeper elapsedTimeKeeper;
    private final ProcessNormalizedTimeKeeper processCpuTimeKeeper;
    private final ThreadNormalizedTimeKeeper threadCpuTimeKeeper;

    public static void addData(String ... data) {
        Tracer.get().addDataImpl(data);
    }

    public static void init() {
        Tracer.get();
    }

    public static boolean canTrace() {
        return logFile != null;
    }

    public static void markTimeline(String message) {
        Tracer.get().markTimelineImpl(message);
    }

    public static TraceEvent start(EventType type, String ... data) {
        return Tracer.get().startImpl(type, data);
    }

    private static double convertToMilliseconds(long nanos) {
        return (double)nanos / 1000000.0;
    }

    public static void end(TraceEvent event, String ... data) {
        if (event != null) {
            event.end(data);
        }
    }

    private static Tracer get() {
        return LazySpeedTracerLoggerHolder.singleton;
    }

    private static boolean getBooleanProperty(String propName) {
        try {
            return System.getProperty(propName) != null;
        }
        catch (RuntimeException ruEx) {
            return false;
        }
    }

    private Tracer() {
        this.enabled = this.fileLoggingEnabled = logFile != null;
        if (this.enabled) {
            this.elapsedTimeKeeper = new ElapsedNormalizedTimeKeeper();
            this.processCpuTimeKeeper = new ProcessNormalizedTimeKeeper();
            this.threadCpuTimeKeeper = new ThreadNormalizedTimeKeeper();
            if (this.fileLoggingEnabled) {
                Format format = Format.HTML;
                if (defaultFormatString != null) {
                    for (Format value : Format.values()) {
                        if (!value.name().toLowerCase().equals(defaultFormatString.toLowerCase())) continue;
                        format = value;
                        break;
                    }
                }
                this.outputFormat = format;
                this.eventsToWrite = this.openDefaultLogWriter();
                this.shutDownSentinel = new TraceEvent();
                this.flushSentinel = new TraceEvent();
                this.shutDownLatch = new CountDownLatch(1);
            }
            if (logGcTime) {
                this.gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
                this.lastGcTimes = new ConcurrentHashMap<String, Long>();
            }
            this.pendingEvents = this.initPendingEvents();
        } else {
            this.elapsedTimeKeeper = null;
            this.processCpuTimeKeeper = null;
            this.threadCpuTimeKeeper = null;
        }
    }

    public void addDataImpl(String ... data) {
        Stack<TraceEvent> threadPendingEvents = this.pendingEvents.get();
        if (threadPendingEvents.isEmpty()) {
            throw new IllegalStateException("Tried to add data to an event that never started!");
        }
        TraceEvent currentEvent = threadPendingEvents.peek();
        currentEvent.addData(data);
    }

    public void markTimelineImpl(String message) {
        Stack<TraceEvent> threadPendingEvents = this.pendingEvents.get();
        TraceEvent parent = null;
        if (!threadPendingEvents.isEmpty()) {
            parent = threadPendingEvents.peek();
        }
        MarkTimelineEvent newEvent = new MarkTimelineEvent(parent);
        threadPendingEvents.push(newEvent);
        newEvent.end("message", message);
    }

    void addGcEvents(TraceEvent refEvent) {
        if (!this.fileLoggingEnabled) {
            return;
        }
        for (GarbageCollectorMXBean gcMXBean : this.gcMXBeans) {
            String gcName = gcMXBean.getName();
            Long lastGcTime = this.lastGcTimes.get(gcName);
            long currGcTime = gcMXBean.getCollectionTime();
            if (lastGcTime == null) {
                lastGcTime = 0L;
            }
            if (currGcTime <= lastGcTime) continue;
            long gcDurationNanos = (currGcTime - lastGcTime) * 1000000L;
            GcEvent gcEvent = new GcEvent(refEvent, gcName, gcMXBean.getCollectionCount(), gcDurationNanos);
            this.eventsToWrite.add(gcEvent);
            this.lastGcTimes.put(gcName, currGcTime);
        }
    }

    void addOverheadEvent(TraceEvent refEvent) {
        TraceEvent overheadEvent = new TraceEvent(refEvent, SpeedTracerEventType.OVERHEAD, new String[0]);
        overheadEvent.setStartsAfter(refEvent);
        overheadEvent.updateDuration();
        refEvent.extendDuration(overheadEvent);
    }

    void endImpl(TraceEvent event, String ... data) {
        if (!this.enabled) {
            return;
        }
        if (data.length % 2 == 1) {
            throw new IllegalArgumentException("Unmatched data argument");
        }
        Stack<TraceEvent> threadPendingEvents = this.pendingEvents.get();
        if (threadPendingEvents.isEmpty()) {
            throw new IllegalStateException("Tried to end an event that never started!");
        }
        TraceEvent currentEvent = threadPendingEvents.pop();
        currentEvent.updateDuration();
        while (currentEvent != event && !threadPendingEvents.isEmpty()) {
            currentEvent.addData("Missed", "This event was closed without an explicit call to Event.end()");
            currentEvent = threadPendingEvents.pop();
            currentEvent.updateDuration();
        }
        if (threadPendingEvents.isEmpty() && currentEvent != event) {
            currentEvent.addData("Missed", "Fell off the end of the threadPending events");
        }
        if (logGcTime) {
            this.addGcEvents(currentEvent);
        }
        currentEvent.addData(data);
        if (logOverheadTime) {
            this.addOverheadEvent(currentEvent);
        }
        if (threadPendingEvents.isEmpty() && this.fileLoggingEnabled) {
            this.eventsToWrite.add(currentEvent);
        }
    }

    TraceEvent startImpl(EventType type, String ... data) {
        if (!this.enabled) {
            return this.dummyEvent;
        }
        if (data.length % 2 == 1) {
            throw new IllegalArgumentException("Unmatched data argument");
        }
        Stack<TraceEvent> threadPendingEvents = this.pendingEvents.get();
        TraceEvent parent = null;
        if (!threadPendingEvents.isEmpty()) {
            parent = threadPendingEvents.peek();
        } else {
            this.threadCpuTimeKeeper.resetTimeBase();
        }
        TraceEvent newEvent = new TraceEvent(parent, type, data);
        if (threadPendingEvents.size() == 0) {
            long baseTime = logProcessCpuTime ? this.processCpuTimeKeeper.zeroTimeMillis() : (logThreadCpuTime ? this.threadCpuTimeKeeper.zeroTimeMillis() : this.elapsedTimeKeeper.zeroTimeMillis());
            newEvent.addData("baseTime", "" + baseTime);
        }
        threadPendingEvents.push(newEvent);
        return newEvent;
    }

    private ThreadLocal<Stack<TraceEvent>> initPendingEvents() {
        return new ThreadLocal<Stack<TraceEvent>>(){

            @Override
            protected Stack<TraceEvent> initialValue() {
                return new Stack<TraceEvent>();
            }
        };
    }

    private BlockingQueue<TraceEvent> openDefaultLogWriter() {
        BufferedWriter writer = null;
        if (this.enabled) {
            try {
                writer = new BufferedWriter(new FileWriter(logFile));
                return this.openLogWriter(writer, logFile);
            }
            catch (IOException e) {
                System.err.println("Unable to open dart.speedtracerlog '" + logFile + "'");
                e.printStackTrace();
            }
        }
        return null;
    }

    private BlockingQueue<TraceEvent> openLogWriter(Writer writer, String fileName) {
        try {
            if (this.outputFormat.equals((Object)Format.HTML)) {
                writer.write("<HTML isdump=\"true\"><body><style>body {font-family:Helvetica; margin-left:15px;}</style><h2>Performance dump from GWT</h2><div>This file contains data that can be viewed with the <a href=\"http://code.google.com/speedtracer\">SpeedTracer</a> extension under the <a href=\"http://chrome.google.com/\">Chrome</a> browser.</div><p><span id=\"info\">(You must install the SpeedTracer extension to open this file)</span></p><div style=\"display: none\" id=\"traceData\" version=\"0.17\">\n");
            }
        }
        catch (IOException e) {
            System.err.println("Unable to write to dart.speedtracerlog '" + (fileName == null ? "" : fileName) + "'");
            e.printStackTrace();
            return null;
        }
        final LinkedBlockingQueue<TraceEvent> eventQueue = new LinkedBlockingQueue<TraceEvent>();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    eventQueue.add(Tracer.this.shutDownSentinel);
                    Tracer.this.shutDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        LogWriterThread logWriterWorker = new LogWriterThread(writer, fileName, eventQueue);
        logWriterWorker.setPriority(3);
        logWriterWorker.setDaemon(true);
        logWriterWorker.setName("SpeedTracerLogger writer");
        logWriterWorker.start();
        return eventQueue;
    }

    static {
        if (logProcessCpuTime && logThreadCpuTime) {
            throw new RuntimeException("System properties are misconfigured: Specify one or the other of 'dart.speedtracer.logProcessCpuTime' or 'dart.speedtracer.logThreadCpuTime', not both.");
        }
    }

    private class MarkTimelineEvent
    extends TraceEvent {
        public MarkTimelineEvent(TraceEvent parent) {
            if (parent != null) {
                parent.children.add(this);
            }
        }

        @Override
        JSONObject toJson() throws JSONException {
            JSONObject json = new JSONObject();
            json.put("type", 11);
            double startMs = Tracer.convertToMilliseconds(this.getStartTimeNanos());
            json.put("time", startMs);
            json.put("duration", 0.0);
            JSONObject jsonData = new JSONObject();
            for (int i = 0; i < this.data.size(); i += 2) {
                jsonData.put((String)this.data.get(i), this.data.get(i + 1));
            }
            json.put("data", jsonData);
            return json;
        }
    }

    private class LogWriterThread
    extends Thread {
        private final String fileName;
        private final BlockingQueue<TraceEvent> threadEventQueue;
        private final Writer writer;

        public LogWriterThread(Writer writer, String fileName, BlockingQueue<TraceEvent> eventQueue) {
            this.writer = writer;
            this.fileName = fileName;
            this.threadEventQueue = eventQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long nextFlush = System.currentTimeMillis() + 10000L;
            try {
                while (true) {
                    TraceEvent event;
                    if ((event = this.threadEventQueue.poll(nextFlush - System.currentTimeMillis(), TimeUnit.MILLISECONDS)) != null) {
                        if (event == Tracer.this.shutDownSentinel) break;
                        if (event == Tracer.this.flushSentinel) {
                            this.writer.flush();
                            Tracer.this.flushLatch.countDown();
                        } else {
                            JSONObject json = event.toJson();
                            json.write(this.writer);
                            this.writer.write(10);
                        }
                    }
                    if (System.currentTimeMillis() < nextFlush) continue;
                    this.writer.flush();
                    nextFlush = System.currentTimeMillis() + 10000L;
                }
                if (Tracer.this.outputFormat.equals((Object)Format.HTML)) {
                    this.writer.write("</div></body></html>\n");
                }
                this.writer.close();
            }
            catch (InterruptedException event) {
            }
            catch (IOException e) {
                System.err.println("Unable to write to dart.speedtracerlog '" + (this.fileName == null ? "" : this.fileName) + "'");
                e.printStackTrace();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            finally {
                Tracer.this.shutDownLatch.countDown();
            }
        }
    }

    private static class LazySpeedTracerLoggerHolder {
        public static Tracer singleton = new Tracer();

        private LazySpeedTracerLoggerHolder() {
        }
    }

    private class ThreadNormalizedTimeKeeper {
        private final ThreadMXBean threadMXBean;
        private final ThreadLocal<Long> resettableTimeBase = new ThreadLocal();
        private final long zeroTimeNanos;
        private final long zeroTimeMillis;

        public ThreadNormalizedTimeKeeper() {
            this.threadMXBean = ManagementFactory.getThreadMXBean();
            if (!this.threadMXBean.isCurrentThreadCpuTimeSupported()) {
                throw new RuntimeException("Current thread cpu time not supported");
            }
            this.zeroTimeNanos = System.nanoTime();
            this.zeroTimeMillis = (long)Tracer.convertToMilliseconds(this.zeroTimeNanos);
        }

        public long normalizedTimeNanos() {
            return this.threadMXBean.getCurrentThreadCpuTime() + this.resettableTimeBase.get();
        }

        public void resetTimeBase() {
            this.resettableTimeBase.set(System.nanoTime() - this.zeroTimeNanos - this.threadMXBean.getCurrentThreadCpuTime());
        }

        public long zeroTimeMillis() {
            return this.zeroTimeMillis;
        }
    }

    private class ProcessNormalizedTimeKeeper {
        private final OperatingSystemMXBean osMXBean;
        private final Method getProcessCpuTimeMethod;
        private final long zeroTimeNanos;
        private final long zeroTimeMillis;

        public ProcessNormalizedTimeKeeper() {
            try {
                this.osMXBean = ManagementFactory.getOperatingSystemMXBean();
                this.getProcessCpuTimeMethod = this.osMXBean.getClass().getMethod("getProcessCpuTime", new Class[0]);
                this.getProcessCpuTimeMethod.setAccessible(true);
                this.zeroTimeNanos = (Long)this.getProcessCpuTimeMethod.invoke((Object)this.osMXBean, new Object[0]);
                this.zeroTimeMillis = (long)Tracer.convertToMilliseconds(this.zeroTimeNanos);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public long normalizedTimeNanos() {
            try {
                return (Long)this.getProcessCpuTimeMethod.invoke((Object)this.osMXBean, new Object[0]) - this.zeroTimeNanos;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public long zeroTimeMillis() {
            return this.zeroTimeMillis;
        }
    }

    private class ElapsedNormalizedTimeKeeper {
        private final long zeroTimeMillis = System.currentTimeMillis();

        public long normalizedTimeNanos() {
            return (System.currentTimeMillis() - this.zeroTimeMillis) * 1000000L;
        }

        public long zeroTimeMillis() {
            return this.zeroTimeMillis;
        }
    }

    private class GcEvent
    extends TraceEvent {
        private TraceEvent refEvent;

        GcEvent(TraceEvent refEvent, String gcType, long collectionCount, long durationNanos) {
            super(null, SpeedTracerEventType.GC, "Collector Type", gcType, "Cumulative Collection Count", Long.toString(collectionCount));
            this.refEvent = refEvent;
            this.elapsedDurationNanos = durationNanos;
        }

        @Override
        public long getDurationNanos() {
            return this.getElapsedDurationNanos();
        }

        @Override
        public long getElapsedStartTimeNanos() {
            return this.refEvent.getElapsedStartTimeNanos() + this.refEvent.getElapsedDurationNanos() - this.getElapsedDurationNanos();
        }

        @Override
        public long getStartTimeNanos() {
            return this.refEvent.getStartTimeNanos() + this.refEvent.getDurationNanos() - this.getDurationNanos();
        }
    }

    private class DummyEvent
    extends TraceEvent {
        private DummyEvent() {
        }

        @Override
        public void addData(String ... data) {
        }

        @Override
        public void end(String ... data) {
        }

        @Override
        public String toString() {
            return "Dummy";
        }
    }

    static enum Format {
        HTML,
        RAW;

    }

    public static interface EventType {
        public String getColor();

        public String getName();
    }

    public class TraceEvent {
        protected final EventType type;
        List<TraceEvent> children;
        List<String> data;
        long elapsedDurationNanos;
        long elapsedStartTimeNanos;
        long processCpuDurationNanos;
        long processCpuStartTimeNanos;
        long threadCpuDurationNanos;
        long threadCpuStartTimeNanos;

        TraceEvent() {
            if (Tracer.this.enabled) {
                Tracer.this.threadCpuTimeKeeper.resetTimeBase();
                this.recordStartTime();
                this.data = new ArrayList<String>();
                this.children = new ArrayList<TraceEvent>();
            } else {
                this.processCpuStartTimeNanos = 0L;
                this.threadCpuStartTimeNanos = 0L;
                this.elapsedStartTimeNanos = 0L;
                this.data = null;
                this.children = null;
            }
            this.type = null;
        }

        TraceEvent(TraceEvent parent, EventType type, String ... data) {
            if (parent != null) {
                parent.children.add(this);
            }
            this.type = type;
            assert (data.length % 2 == 0);
            this.recordStartTime();
            this.data = new ArrayList<String>();
            this.data.addAll(Arrays.asList(data));
            this.children = new ArrayList<TraceEvent>();
        }

        public void addData(String ... data) {
            if (data != null) {
                assert (data.length % 2 == 0);
                this.data.addAll(Arrays.asList(data));
            }
        }

        public void end(String ... data) {
            Tracer.this.endImpl(this, data);
        }

        public long getDurationNanos() {
            return logProcessCpuTime ? this.processCpuDurationNanos : (logThreadCpuTime ? this.threadCpuDurationNanos : this.elapsedDurationNanos);
        }

        public long getElapsedDurationNanos() {
            return this.elapsedDurationNanos;
        }

        public long getElapsedStartTimeNanos() {
            return this.elapsedStartTimeNanos;
        }

        public long getStartTimeNanos() {
            return logProcessCpuTime ? this.processCpuStartTimeNanos : (logThreadCpuTime ? this.threadCpuStartTimeNanos : this.elapsedStartTimeNanos);
        }

        public EventType getType() {
            return this.type;
        }

        public String toString() {
            return this.type.getName();
        }

        void extendDuration(TraceEvent refEvent) {
            this.elapsedDurationNanos += refEvent.elapsedDurationNanos;
            this.processCpuDurationNanos += refEvent.processCpuDurationNanos;
            this.threadCpuDurationNanos += refEvent.threadCpuDurationNanos;
        }

        void setStartsAfter(TraceEvent refEvent) {
            this.elapsedStartTimeNanos = refEvent.elapsedStartTimeNanos + refEvent.elapsedDurationNanos;
            this.processCpuStartTimeNanos = refEvent.processCpuStartTimeNanos + refEvent.processCpuDurationNanos;
            this.threadCpuStartTimeNanos = refEvent.threadCpuStartTimeNanos + refEvent.threadCpuDurationNanos;
        }

        JSONObject toJson() throws JSONException {
            JSONObject json = new JSONObject();
            json.put("type", -2);
            json.put("typeName", this.type.getName());
            json.put("color", this.type.getColor());
            double startMs = Tracer.convertToMilliseconds(this.getStartTimeNanos());
            json.put("time", startMs);
            double durationMs = Tracer.convertToMilliseconds(this.getDurationNanos());
            json.put("duration", durationMs);
            JSONObject jsonData = new JSONObject();
            for (int i = 0; i < this.data.size(); i += 2) {
                jsonData.put(this.data.get(i), this.data.get(i + 1));
            }
            json.put("data", jsonData);
            JSONArray jsonChildren = new JSONArray();
            for (TraceEvent child : this.children) {
                jsonChildren.put(child.toJson());
            }
            json.put("children", jsonChildren);
            return json;
        }

        void updateDuration() {
            long elapsedEndTimeNanos = Tracer.this.elapsedTimeKeeper.normalizedTimeNanos();
            assert (elapsedEndTimeNanos >= this.elapsedStartTimeNanos);
            this.elapsedDurationNanos = elapsedEndTimeNanos - this.elapsedStartTimeNanos;
            if (logProcessCpuTime) {
                long processCpuEndTimeNanos = Tracer.this.processCpuTimeKeeper.normalizedTimeNanos();
                assert (processCpuEndTimeNanos >= this.processCpuStartTimeNanos);
                this.processCpuDurationNanos = processCpuEndTimeNanos - this.processCpuStartTimeNanos;
            } else if (logThreadCpuTime) {
                long threadCpuEndTimeNanos = Tracer.this.threadCpuTimeKeeper.normalizedTimeNanos();
                assert (threadCpuEndTimeNanos >= this.threadCpuStartTimeNanos);
                this.threadCpuDurationNanos = threadCpuEndTimeNanos - this.threadCpuStartTimeNanos;
            }
        }

        private void recordStartTime() {
            this.elapsedStartTimeNanos = Tracer.this.elapsedTimeKeeper.normalizedTimeNanos();
            if (logProcessCpuTime) {
                this.processCpuStartTimeNanos = Tracer.this.processCpuTimeKeeper.normalizedTimeNanos();
            } else if (logThreadCpuTime) {
                this.threadCpuStartTimeNanos = Tracer.this.threadCpuTimeKeeper.normalizedTimeNanos();
            }
        }
    }
}

