/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.metrics;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.atomic.AtomicLong;

public final class CompilerMetrics {
    private AtomicLong charactersParsed = new AtomicLong();
    private AtomicLong charactersParsedExcludingComments = new AtomicLong();
    private long compileLibrariesTime = 0L;
    private long compileLibrariesTimeStart = 0L;
    private AtomicLong linesParsed = new AtomicLong();
    private AtomicLong linesParsedExcludingComments = new AtomicLong();
    private long milliEndTime = -1L;
    private final long milliStartTime;
    private long nanoParseWallTime = 0L;
    private AtomicLong nanoTotalParseTime = new AtomicLong();
    private long nativeLibCharCount;
    private long packageAppTime = 0L;
    private long packageAppTimeStart = 0L;
    private long totalJsOutputCharCount;
    private AtomicLong unitsParsed = new AtomicLong();
    private long updateAndResolveTime = 0L;
    private long updateAndResolveTimeStart = 0L;

    public static long getCPUTime() {
        return System.currentTimeMillis() * 1000000L;
    }

    public static long getThreadTime() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean.isThreadCpuTimeSupported()) {
            return threadMXBean.getCurrentThreadCpuTime();
        }
        return -1L;
    }

    private static double nanoToMillis(long nanoTime) {
        return (double)nanoTime / 1000000.0;
    }

    public CompilerMetrics() {
        this.milliStartTime = System.currentTimeMillis();
    }

    public void addParseTimeNano(long nanoTotalParseTime) {
        this.nanoTotalParseTime.addAndGet(nanoTotalParseTime);
    }

    public void addParseWallTimeNano(long nanoWallParseTime) {
        this.nanoParseWallTime = nanoWallParseTime;
    }

    public void done() {
        if (this.milliEndTime == -1L) {
            this.milliEndTime = System.currentTimeMillis();
        }
    }

    public void endCompileLibrariesTime() {
        this.compileLibrariesTime = System.currentTimeMillis() - this.compileLibrariesTimeStart;
    }

    public void endPackageAppTime() {
        this.packageAppTime = System.currentTimeMillis() - this.packageAppTimeStart;
    }

    public void endUpdateAndResolveTime() {
        this.updateAndResolveTime = System.currentTimeMillis() - this.updateAndResolveTimeStart;
    }

    public long getCompileLibrariesTime() {
        return this.compileLibrariesTime;
    }

    public long getJSNativeLibCharSize() {
        return this.nativeLibCharCount;
    }

    public long getJSOutputCharSize() {
        return this.totalJsOutputCharCount;
    }

    public double getLinesPerMS() {
        return (double)this.getNumLinesParsed() / this.getTotalCompilationTime();
    }

    public double getNonCommentLinesPerMS() {
        return (double)this.getNumNonCommentLines() / this.getTotalCompilationTime();
    }

    public long getNumCharsParsed() {
        return this.charactersParsed.get();
    }

    public long getNumLinesParsed() {
        return this.linesParsed.get();
    }

    public long getNumNonCommentChars() {
        return this.charactersParsedExcludingComments.get();
    }

    public long getNumNonCommentLines() {
        return this.linesParsedExcludingComments.get();
    }

    public double getNumUnitsParsed() {
        return this.unitsParsed.get();
    }

    public long getPackageAppTime() {
        return this.packageAppTime;
    }

    public double getParseTime() {
        return CompilerMetrics.nanoToMillis(this.nanoTotalParseTime.get());
    }

    public double getParseWallTime() {
        return CompilerMetrics.nanoToMillis(this.nanoParseWallTime);
    }

    public double getPercentCharsConsumedByNativeLibraries() {
        return (double)(this.getJSNativeLibCharSize() / this.getNumCharsParsed()) * 100.0;
    }

    public double getPercentTimeParsing() {
        return this.getParseTime() / this.getTotalCompilationTime();
    }

    public double getRatioOutputToInput() {
        if (this.getNumCharsParsed() == 0L) {
            return 0.0;
        }
        return this.getJSOutputCharSize() / this.getNumCharsParsed();
    }

    public double getRatioOutputToInputExcludingComments() {
        if (this.getNumNonCommentChars() == 0L) {
            return 0.0;
        }
        return this.getJSOutputCharSize() / this.getNumNonCommentChars();
    }

    public double getTimeSpentPerUnit() {
        if (this.getNumUnitsParsed() == 0.0) {
            return 0.0;
        }
        return this.getTotalCompilationTime() / this.getNumUnitsParsed();
    }

    public double getTotalCompilationTime() {
        return this.milliEndTime - this.milliStartTime;
    }

    public long getUpdateAndResolveTime() {
        return this.updateAndResolveTime;
    }

    public void packagedJsApplication(long totalJsOutputCharSize, long nativeLibCharCount) {
        this.totalJsOutputCharCount = totalJsOutputCharSize;
        this.nativeLibCharCount = nativeLibCharCount;
    }

    public void startCompileLibrariesTime() {
        this.compileLibrariesTimeStart = System.currentTimeMillis();
    }

    public void startPackageAppTime() {
        this.packageAppTimeStart = System.currentTimeMillis();
    }

    public void startUpdateAndResolveTime() {
        this.updateAndResolveTimeStart = System.currentTimeMillis();
    }

    public void unitParsed(int charactersParsed, int charactersParsedExcludingComments, int linesParsed, int linesParsedExcludingComments) {
        this.unitsParsed.incrementAndGet();
        this.charactersParsed.addAndGet(charactersParsed);
        this.charactersParsedExcludingComments.addAndGet(charactersParsedExcludingComments);
        this.linesParsed.addAndGet(linesParsed);
        this.linesParsedExcludingComments.addAndGet(linesParsedExcludingComments);
    }

    public void write(PrintStream out) {
        this.done();
        out.format("Compile-time-total-ms          : %1$.2f%n", this.getTotalCompilationTime());
        out.format("# Update-and-resolve-time-ms     : %d\n", this.getUpdateAndResolveTime());
        out.format("# Compile-libraries-time-ms      : %d\n", this.getCompileLibrariesTime());
        out.format("# Package-app-time-ms            : %d\n", this.getPackageAppTime());
        out.println("# Compile-time-unit-average-ms  : " + this.getTimeSpentPerUnit());
        out.format("# Parse-wall-time-ms             : %1$.2f%n", this.getParseWallTime());
        out.format("# Parse-time-ms                  : %1$.2f%n", this.getParseTime());
        out.println("# Parsed-units                   : " + this.getNumUnitsParsed());
        out.println("# Parsed-src-chars               : " + this.getNumCharsParsed());
        out.println("# Parsed-src-lines               : " + this.getNumLinesParsed());
        out.println("# Parsed-code-chars              : " + this.getNumNonCommentChars());
        out.println("# Parsed-code-lines              : " + this.getNumNonCommentLines());
        out.println("# Output-js-chars                : " + this.getJSOutputCharSize());
        double jsNativeLibCharSize = this.getJSNativeLibCharSize() == -1L ? 0.0 : (double)this.getJSNativeLibCharSize();
        out.println("# Output-js-native-lib-chars     : " + jsNativeLibCharSize);
        out.println("# Processed-total-lines-ms       : " + this.getLinesPerMS());
        out.println("# Processed-code-lines-ms        : " + this.getNonCommentLinesPerMS());
        out.println("# Ratio-output-intput-total      : " + this.getRatioOutputToInput());
        out.println("# Ratio-output-intput-code       : " + this.getRatioOutputToInputExcludingComments());
        out.println("# Ratio-parsing-compile-percent  : " + this.getPercentTimeParsing() * 100.0);
    }
}

