/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.NameFactory;

public final class Name
implements Serializable {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private static final NameFactory factory = new NameFactory();
    final char[] data;
    private final transient int hashCode;

    public static Name of(char[] data) {
        return factory.of(data);
    }

    public static Name of(char[] data, int offset, int length) {
        return factory.of(data, offset, length);
    }

    static int computeHashCode(char[] data, int offset, int length) {
        int result = 89;
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            result *= 31;
            result += data[i];
        }
        return result;
    }

    Name(char[] data, int hashCode) {
        this.data = data;
        this.hashCode = hashCode;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.valueOf(this.data);
    }

    public void writeBytesTo(OutputStream out) throws IOException {
        out.write(new String(this.data).getBytes(CHARSET));
    }

    public void writeCharsTo(PrintStream out) {
        out.print(this.data);
    }

    public void writeCharsTo(Writer writer) throws IOException {
        writer.write(this.data);
    }
}

