/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.common;

import java.io.IOException;
import java.util.List;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPropertyAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.HasName;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.HasSourceInfo;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.SourceInfo;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.FilePosition;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapFormat;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapGenerator;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.SourceMapSection;

public class GenerateSourceMap {
    private final SourceMapGenerator generator = SourceMapGeneratorFactory.getInstance(SourceMapFormat.V3);

    public void addMapping(HasSourceInfo node, FilePosition startPosition, FilePosition endPosition) {
        SourceInfo sourceInfo = node.getSourceInfo();
        if (sourceInfo.getSource() == null || sourceInfo.getSourceLine() < 0) {
            return;
        }
        String sourceFile = sourceInfo.getSource().getName();
        String originalName = null;
        if (node instanceof HasName) {
            Symbol symbol = ((HasName)((Object)node)).getSymbol();
            if (symbol != null) {
                originalName = symbol.getOriginalSymbolName();
            }
        } else if (node instanceof DartIdentifier) {
            originalName = ((DartIdentifier)node).getTargetName();
        } else if (node instanceof DartPropertyAccess) {
            originalName = ((DartPropertyAccess)node).getPropertyName();
        }
        this.generator.addMapping(sourceFile, originalName, new FilePosition(sourceInfo.getSourceLine(), sourceInfo.getSourceColumn()), startPosition, endPosition);
    }

    public void appendTo(Appendable out, String name) throws IOException {
        this.generator.appendTo(out, name);
    }

    public void appendIndexMapTo(Appendable out, String name, List<SourceMapSection> appSections) throws IOException {
        this.generator.appendIndexMapTo(out, name, appSections);
    }
}

