/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBooleanLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsDebugger;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsEmpty;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsProgramFragment;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsRootScope;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.NodeKind;

public final class JsProgram
extends JsNode {
    private final JsStatement debuggerStmt;
    private final JsEmpty emptyStmt;
    private final JsBooleanLiteral falseLiteral;
    private JsProgramFragment[] fragments;
    private final Map<String, JsFunction> indexedFunctions = new HashMap<String, JsFunction>();
    private final JsNullLiteral nullLiteral;
    private final Map<Double, JsNumberLiteral> numberLiteralMap = new HashMap<Double, JsNumberLiteral>();
    private final JsScope objectScope;
    private final JsRootScope rootScope;
    private final Map<String, JsStringLiteral> stringLiteralMap = new HashMap<String, JsStringLiteral>();
    private final JsScope topScope;
    private final JsBooleanLiteral trueLiteral;

    public JsProgram(String unitId) {
        this.rootScope = new JsRootScope(this);
        this.topScope = new JsScope(this.rootScope, "Global", unitId);
        this.objectScope = new JsScope(this.rootScope, "Object");
        this.setFragmentCount(1);
        this.debuggerStmt = new JsDebugger();
        this.emptyStmt = new JsEmpty();
        this.falseLiteral = new JsBooleanLiteral(false);
        this.nullLiteral = new JsNullLiteral();
        this.trueLiteral = new JsBooleanLiteral(true);
    }

    public JsBooleanLiteral getBooleanLiteral(boolean truth) {
        if (truth) {
            return this.getTrueLiteral();
        }
        return this.getFalseLiteral();
    }

    public JsStatement getDebuggerStmt() {
        return this.debuggerStmt;
    }

    public JsEmpty getEmptyStmt() {
        return this.emptyStmt;
    }

    public JsBooleanLiteral getFalseLiteral() {
        return this.falseLiteral;
    }

    public JsBlock getFragmentBlock(int fragment) {
        if (fragment < 0 || fragment >= this.fragments.length) {
            throw new IllegalArgumentException("Invalid fragment: " + fragment);
        }
        return this.fragments[fragment].getGlobalBlock();
    }

    public int getFragmentCount() {
        return this.fragments.length;
    }

    public JsBlock getGlobalBlock() {
        return this.getFragmentBlock(0);
    }

    public JsFunction getIndexedFunction(String name) {
        return this.indexedFunctions.get(name);
    }

    public JsNullLiteral getNullLiteral() {
        return this.nullLiteral;
    }

    public JsNumberLiteral getNumberLiteral(double value) {
        JsNumberLiteral lit = this.numberLiteralMap.get(value);
        if (lit == null) {
            lit = new JsNumberLiteral(value);
            this.numberLiteralMap.put(value, lit);
        }
        return lit;
    }

    public JsScope getObjectScope() {
        return this.objectScope;
    }

    public JsRootScope getRootScope() {
        return this.rootScope;
    }

    public JsScope getScope() {
        return this.topScope;
    }

    public JsStringLiteral getStringLiteral(String value) {
        JsStringLiteral lit = this.stringLiteralMap.get(value);
        if (lit == null) {
            lit = new JsStringLiteral(value);
            this.stringLiteralMap.put(value, lit);
        }
        return lit;
    }

    public JsBooleanLiteral getTrueLiteral() {
        return this.trueLiteral;
    }

    public JsNameRef getUndefinedLiteral() {
        return new JsNameRef("$Dart$Null");
    }

    public void setFragmentCount(int fragments) {
        this.fragments = new JsProgramFragment[fragments];
        for (int i = 0; i < fragments; ++i) {
            this.fragments[i] = new JsProgramFragment();
        }
    }

    public void setIndexedFunctions(Map<String, JsFunction> indexedFunctions) {
        this.indexedFunctions.clear();
        this.indexedFunctions.putAll(indexedFunctions);
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            for (JsProgramFragment fragment : this.fragments) {
                v.accept(fragment);
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.PROGRAM;
    }
}

