/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast;

import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.CanBooleanEval;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsUnaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.NodeKind;

public final class JsPrefixOperation
extends JsUnaryOperation
implements CanBooleanEval {
    public JsPrefixOperation(JsUnaryOperator op) {
        this(op, null);
    }

    public JsPrefixOperation(JsUnaryOperator op, JsExpression arg) {
        super(op, arg);
    }

    @Override
    public boolean isBooleanFalse() {
        if (this.getOperator() == JsUnaryOperator.VOID) {
            return true;
        }
        if (this.getOperator() == JsUnaryOperator.NOT && this.getArg() instanceof CanBooleanEval) {
            CanBooleanEval eval = (CanBooleanEval)((Object)this.getArg());
            return eval.isBooleanTrue();
        }
        return false;
    }

    @Override
    public boolean isBooleanTrue() {
        if (this.getOperator() == JsUnaryOperator.NOT && this.getArg() instanceof CanBooleanEval) {
            CanBooleanEval eval = (CanBooleanEval)((Object)this.getArg());
            return eval.isBooleanFalse();
        }
        return this.getOperator() == JsUnaryOperator.TYPEOF;
    }

    @Override
    public boolean isDefinitelyNotNull() {
        if (this.getOperator() == JsUnaryOperator.TYPEOF) {
            return true;
        }
        return this.getOperator() != JsUnaryOperator.VOID;
    }

    @Override
    public boolean isDefinitelyNull() {
        return this.getOperator() == JsUnaryOperator.VOID;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            super.traverse(v, ctx);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.PREFIX_OP;
    }
}

