/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast;

import java.util.List;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVisitable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.Hack;

public class JsModVisitor
extends JsVisitor {
    protected boolean didChange = false;

    protected static <T extends JsVisitable> void checkReplacement(T origNode, T newNode) {
        if (newNode == null) {
            throw new RuntimeException("Cannot replace with null");
        }
        if (newNode == origNode) {
            throw new RuntimeException("The replacement is the same as the original");
        }
    }

    @Override
    public boolean didChange() {
        return this.didChange;
    }

    @Override
    protected <T extends JsVisitable> T doAccept(T node) {
        return new NodeContext<T>().traverse(node);
    }

    @Override
    protected <T extends JsVisitable> void doAcceptList(List<T> collection) {
        NodeContext<JsVisitable> ctx = new NodeContext<JsVisitable>();
        int c = collection.size();
        for (int i = 0; i < c; ++i) {
            ctx.traverse((JsVisitable)collection.get(i));
            if (!((NodeContext)ctx).replaced) continue;
            collection.set(i, ((NodeContext)ctx).node);
        }
    }

    @Override
    protected JsExpression doAcceptLvalue(JsExpression expr) {
        return new LvalueContext().traverse(expr);
    }

    @Override
    protected <T extends JsVisitable> void doAcceptWithInsertRemove(List<T> collection) {
        new ListContext<T>().traverse(collection);
    }

    private class NodeContext<T extends JsVisitable>
    implements JsContext {
        private T node;
        private boolean replaced;

        private NodeContext() {
        }

        @Override
        public boolean canInsert() {
            return false;
        }

        @Override
        public boolean canRemove() {
            return false;
        }

        @Override
        public void insertAfter(JsVisitable node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertBefore(JsVisitable node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLvalue() {
            return false;
        }

        @Override
        public void removeMe() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceMe(JsVisitable node) {
            if (this.replaced) {
                throw new RuntimeException("Node was already replaced");
            }
            JsModVisitor.checkReplacement(this.node, node);
            this.node = (JsVisitable)Hack.cast(node);
            this.replaced = true;
            JsModVisitor.this.didChange = true;
        }

        protected T traverse(T node) {
            this.node = node;
            this.replaced = false;
            JsModVisitor.this.doTraverse((JsVisitable)node, this);
            return this.node;
        }
    }

    private class LvalueContext
    extends NodeContext<JsExpression> {
        private LvalueContext() {
        }

        @Override
        public boolean isLvalue() {
            return true;
        }
    }

    private class ListContext<T extends JsVisitable>
    implements JsContext {
        private List<T> collection;
        private int index;
        private boolean removed;
        private boolean replaced;

        private ListContext() {
        }

        @Override
        public boolean canInsert() {
            return true;
        }

        @Override
        public boolean canRemove() {
            return true;
        }

        @Override
        public void insertAfter(JsVisitable node) {
            this.checkRemoved();
            this.collection.add(this.index + 1, Hack.cast(node));
            JsModVisitor.this.didChange = true;
        }

        @Override
        public void insertBefore(JsVisitable node) {
            this.checkRemoved();
            this.collection.add(this.index++, Hack.cast(node));
            JsModVisitor.this.didChange = true;
        }

        @Override
        public boolean isLvalue() {
            return false;
        }

        @Override
        public void removeMe() {
            this.checkState();
            this.collection.remove(this.index--);
            this.removed = true;
            JsModVisitor.this.didChange = true;
        }

        @Override
        public void replaceMe(JsVisitable node) {
            this.checkState();
            JsModVisitor.checkReplacement((JsVisitable)this.collection.get(this.index), node);
            this.collection.set(this.index, Hack.cast(node));
            this.replaced = true;
            JsModVisitor.this.didChange = true;
        }

        protected void traverse(List<T> collection) {
            this.collection = collection;
            this.index = 0;
            while (this.index < collection.size()) {
                this.replaced = false;
                this.removed = false;
                JsModVisitor.this.doTraverse((JsVisitable)collection.get(this.index), this);
                ++this.index;
            }
        }

        private void checkRemoved() {
            if (this.removed) {
                throw new RuntimeException("Node was already removed");
            }
        }

        private void checkState() {
            this.checkRemoved();
            if (this.replaced) {
                throw new RuntimeException("Node was already replaced");
            }
        }
    }
}

