/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast;

import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.NodeKind;

public final class JsArrayAccess
extends JsExpression {
    private JsExpression arrayExpr;
    private JsExpression indexExpr;

    public JsArrayAccess() {
    }

    public JsArrayAccess(JsExpression arrayExpr, JsExpression indexExpr) {
        this.arrayExpr = arrayExpr;
        this.indexExpr = indexExpr;
    }

    public JsExpression getArrayExpr() {
        return this.arrayExpr;
    }

    public JsExpression getIndexExpr() {
        return this.indexExpr;
    }

    @Override
    public boolean hasSideEffects() {
        return this.arrayExpr.hasSideEffects() || this.indexExpr.hasSideEffects();
    }

    @Override
    public boolean isDefinitelyNotNull() {
        return false;
    }

    @Override
    public boolean isDefinitelyNull() {
        return false;
    }

    public void setArrayExpr(JsExpression arrayExpr) {
        this.arrayExpr = arrayExpr;
    }

    public void setIndexExpr(JsExpression indexExpr) {
        this.indexExpr = indexExpr;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.arrayExpr = v.accept(this.arrayExpr);
            this.indexExpr = v.accept(this.indexExpr);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ARRAY_ACCESS;
    }
}

