/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.common.io.CharStreams;
import org.jetbrains.jet.internal.com.google.common.io.Closeables;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibrarySource;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.analysis.DependencyComputer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.analysis.JavascriptElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.analysis.TopLevelElementIndexer;
import org.jetbrains.jet.internal.org.mozilla.javascript.EvaluatorException;
import org.jetbrains.jet.internal.org.mozilla.javascript.Parser;
import org.jetbrains.jet.internal.org.mozilla.javascript.ast.AstNode;
import org.jetbrains.jet.internal.org.mozilla.javascript.ast.AstRoot;
import org.jetbrains.jet.internal.org.mozilla.javascript.ast.NodeVisitor;

public class TreeShaker {
    private static Set<AstNode> computeNodesToEmit(AstRoot root) {
        ArrayList<AstNode> globals = new ArrayList<AstNode>();
        HashMap<String, List<JavascriptElement>> namesToElements = new HashMap<String, List<JavascriptElement>>();
        TopLevelElementIndexer declVisitor = new TopLevelElementIndexer(namesToElements, globals);
        root.visit(declVisitor);
        ArrayList<AstNode> worklist = new ArrayList<AstNode>();
        for (AstNode global : globals) {
            worklist.add(global);
        }
        worklist.addAll(declVisitor.getEntryPoints());
        DependencyComputer dependencyComputer = new DependencyComputer(namesToElements);
        LinkedHashSet<AstNode> nodesProcessed = new LinkedHashSet<AstNode>();
        while (!worklist.isEmpty()) {
            AstNode node = (AstNode)worklist.remove(worklist.size() - 1);
            if (!nodesProcessed.add(node)) continue;
            List<JavascriptElement> dependencies = dependencyComputer.computeDependencies(node);
            for (JavascriptElement dependency : dependencies) {
                if (dependency.isNative() || nodesProcessed.contains(dependency.getNode())) continue;
                worklist.add(dependency.getNode());
            }
        }
        return nodesProcessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long reduce(LibrarySource app, DartCompilerContext context, String completeArtifactName, Writer outputFile) throws IOException {
        Reader inputFile = context.getArtifactReader(app, "", completeArtifactName);
        AstRoot root = null;
        boolean failed = true;
        try {
            Parser parser = new Parser();
            root = parser.parse(inputFile, "", 1);
            failed = false;
        }
        catch (EvaluatorException e) {
            Closeables.close(inputFile, failed);
            inputFile = context.getArtifactReader(app, "", completeArtifactName);
            long l = CharStreams.copy(inputFile, (Appendable)outputFile);
            return l;
        }
        finally {
            Closeables.close(inputFile, failed);
        }
        Set<AstNode> nodesProcessed = TreeShaker.computeNodesToEmit(root);
        failed = true;
        inputFile = context.getArtifactReader(app, "", completeArtifactName);
        OutputFileWriter outputFileWriter = new OutputFileWriter(nodesProcessed, outputFile, inputFile);
        try {
            root.visit(outputFileWriter);
            failed = false;
            long l = outputFileWriter.getOutputSize();
            return l;
        }
        catch (VisitorIOException e) {
            throw e.getCause();
        }
        finally {
            Closeables.close(inputFile, failed);
        }
    }

    private static final class OutputFileWriter
    implements NodeVisitor {
        private final Set<AstNode> nodesToEmit;
        private final Writer outputFile;
        private final Reader inputFile;
        private long lastReadPosition = 0L;
        private long outputSize = 0L;

        private OutputFileWriter(Set<AstNode> nodesToEmit, Writer outputFile, Reader inputFile) {
            this.nodesToEmit = nodesToEmit;
            this.outputFile = outputFile;
            this.inputFile = inputFile;
        }

        @Override
        public boolean visit(AstNode node) {
            if (node.getAstRoot() == node) {
                return true;
            }
            try {
                if (this.nodesToEmit.contains(node)) {
                    int nodePosition = node.getAbsolutePosition();
                    this.inputFile.skip((long)nodePosition - this.lastReadPosition);
                    char[] buffer = new char[node.getLength()];
                    int charsRead = this.inputFile.read(buffer);
                    assert (charsRead == buffer.length);
                    this.outputFile.write(buffer);
                    this.outputFile.write("\n");
                    this.outputSize += (long)(charsRead + 1);
                    this.lastReadPosition = nodePosition + node.getLength();
                }
            }
            catch (IOException e) {
                throw new VisitorIOException(e);
            }
            return false;
        }

        public long getOutputSize() {
            return this.outputSize;
        }
    }

    private static class VisitorIOException
    extends RuntimeException {
        public VisitorIOException(IOException e) {
            super(e);
        }

        @Override
        public IOException getCause() {
            return (IOException)super.getCause();
        }
    }
}

