/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.analysis.JavascriptElement;
import org.jetbrains.jet.internal.org.mozilla.javascript.ast.AstNode;
import org.jetbrains.jet.internal.org.mozilla.javascript.ast.FunctionNode;
import org.jetbrains.jet.internal.org.mozilla.javascript.ast.Name;
import org.jetbrains.jet.internal.org.mozilla.javascript.ast.NewExpression;
import org.jetbrains.jet.internal.org.mozilla.javascript.ast.NodeVisitor;
import org.jetbrains.jet.internal.org.mozilla.javascript.ast.PropertyGet;
import org.jetbrains.jet.internal.org.mozilla.javascript.ast.Scope;
import org.jetbrains.jet.internal.org.mozilla.javascript.ast.Symbol;

class DependencyComputer {
    private final List<JavascriptElement> dependencies = new ArrayList<JavascriptElement>();
    private final Map<String, List<JavascriptElement>> namesToElements;
    private final Set<String> virtualNames = new HashSet<String>();

    public DependencyComputer(Map<String, List<JavascriptElement>> namesToElements) {
        this.namesToElements = namesToElements;
    }

    public List<JavascriptElement> computeDependencies(AstNode node) {
        this.dependencies.clear();
        node.visit(new DependencyComputingVisitor());
        return this.dependencies;
    }

    class DependencyComputingVisitor
    implements NodeVisitor {
        DependencyComputingVisitor() {
        }

        private void addDependency(String identifier, boolean isVirtual) {
            List members = (List)DependencyComputer.this.namesToElements.get(identifier);
            if (members != null) {
                for (JavascriptElement member : members) {
                    if (isVirtual && member.isVirtual()) {
                        JavascriptElement enclosingElement = member.getEnclosingElement();
                        if (enclosingElement == null || !enclosingElement.isInstantiated()) continue;
                        DependencyComputer.this.dependencies.add(member);
                        continue;
                    }
                    if (!member.isVirtual() && member.getEnclosingElement() != null) {
                        DependencyComputer.this.dependencies.add(member.getEnclosingElement());
                    }
                    DependencyComputer.this.dependencies.add(member);
                }
            }
        }

        private void addInstantiation(String identifier) {
            List instantiatedClasses = (List)DependencyComputer.this.namesToElements.get(identifier);
            if (instantiatedClasses != null) {
                Iterator i$ = instantiatedClasses.iterator();
                while (i$.hasNext()) {
                    JavascriptElement instantiatedClass;
                    instantiatedClass.setInstantiated(true);
                    for (instantiatedClass = (JavascriptElement)i$.next(); instantiatedClass != null; instantiatedClass = instantiatedClass.getInheritsElement()) {
                        JavascriptElement inheritsInvocation = instantiatedClass.getInheritsInvocation();
                        if (inheritsInvocation != null) {
                            DependencyComputer.this.dependencies.add(inheritsInvocation);
                        }
                        for (JavascriptElement member : instantiatedClass.getMembers()) {
                            if (!DependencyComputer.this.virtualNames.contains(member.getName())) continue;
                            DependencyComputer.this.dependencies.add(member);
                        }
                    }
                }
            }
        }

        private void addStaticDependency(String identifier) {
            this.addDependency(identifier, false);
        }

        private void addVirtualDependency(String identifier) {
            DependencyComputer.this.virtualNames.add(identifier);
            this.addDependency(identifier, true);
        }

        Symbol findSymbol(Scope scope, String name) {
            if (scope == null) {
                return null;
            }
            Symbol symbol = scope.getSymbol(name);
            if (symbol == null) {
                Scope parentScope = scope.getParentScope();
                if (parentScope == null && scope != scope.getAstRoot()) {
                    return this.findSymbol(scope.getAstRoot(), name);
                }
                return this.findSymbol(parentScope, name);
            }
            return symbol;
        }

        boolean isLocalVariableOrParameter(Name name) {
            Scope definingScope = name.getDefiningScope();
            Scope enclosingScope = name.getEnclosingScope();
            if (definingScope != null) {
                Symbol symbol = definingScope.getSymbol(name.getIdentifier());
                if (definingScope.getType() == 109 && (symbol != null && symbol.getDeclType() == 122 || symbol.getDeclType() == 87)) {
                    if (name.getParent().getType() == 33) {
                        PropertyGet propertyGet = (PropertyGet)name.getParent();
                        return propertyGet.getRight() != name;
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean isNativeOrTopLevelFunction(Scope enclosingScope, String name) {
            List list = (List)DependencyComputer.this.namesToElements.get(name);
            if (list == null || list.isEmpty()) {
                return false;
            }
            Symbol symbol = this.findSymbol(enclosingScope, name);
            if (symbol != null && (symbol.getDeclType() == 109 || symbol.getDeclType() == 122)) {
                return true;
            }
            JavascriptElement javascriptElement = (JavascriptElement)list.get(0);
            return javascriptElement.isNative();
        }

        String maybeGetStaticName(PropertyGet propertyGet) {
            PropertyGet leftPropGet;
            String handleSpecialCase;
            AstNode right = propertyGet.getRight();
            int rightType = right.getType();
            if (rightType != 39) {
                return null;
            }
            AstNode left = propertyGet.getLeft();
            int leftType = left.getType();
            if (leftType == 39) {
                String qualifier = ((Name)left).getIdentifier();
                if (this.isNativeOrTopLevelFunction(left.getEnclosingScope(), qualifier)) {
                    String targetName = ((Name)right).getIdentifier();
                    String qualifiedName = qualifier + "." + targetName;
                    if ("prototype".equals(targetName)) {
                        return qualifiedName;
                    }
                    if (DependencyComputer.this.namesToElements.containsKey(qualifiedName)) {
                        return qualifiedName;
                    }
                }
            } else if (leftType == 33 && (handleSpecialCase = this.maybeGetStaticName(leftPropGet = (PropertyGet)left)) != null && handleSpecialCase.endsWith("prototype")) {
                handleSpecialCase = handleSpecialCase + "." + ((Name)right).getIdentifier();
                if (DependencyComputer.this.namesToElements.containsKey(handleSpecialCase)) {
                    return handleSpecialCase;
                }
            }
            return null;
        }

        @Override
        public boolean visit(AstNode node) {
            switch (node.getType()) {
                case 33: {
                    PropertyGet propertyGet = (PropertyGet)node;
                    String staticName = this.maybeGetStaticName(propertyGet);
                    if (staticName == null) break;
                    this.addStaticDependency(staticName);
                    return false;
                }
                case 109: {
                    FunctionNode functionNode = (FunctionNode)node;
                    functionNode.getBody().visit(this);
                    return false;
                }
                case 39: {
                    Name name = (Name)node;
                    if (this.isLocalVariableOrParameter(name)) break;
                    String identifier = name.getIdentifier();
                    this.addVirtualDependency(identifier);
                    break;
                }
                case 30: {
                    NewExpression newExpression = (NewExpression)node;
                    Name target = (Name)newExpression.getTarget();
                    if (target == null) break;
                    this.addInstantiation(target.getIdentifier());
                    break;
                }
            }
            return true;
        }
    }
}

