/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartCatchBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClassMember;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartField;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartForInStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartForStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionObjectInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartThisExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVariable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.NormalizedVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;

class ScopeRootInfo {
    private final DartClassMember<?> classMember;
    private final Map<Symbol, DartScope.DartSymbolInfo> symbols = Maps.newHashMap();
    private final Map<DartFunction, ClosureInfo> closures;
    private final Map<DartNode, DartScope> scopes;
    private int closureIds = 0;

    static ScopeRootInfo makeScopeInfo(DartMethodDefinition x, boolean respectInlinableModifier) {
        return ScopeRootInfo.makeScopeInfoImpl(x, respectInlinableModifier);
    }

    static ScopeRootInfo makeScopeInfo(DartField x, boolean respectInlinableModifier) {
        return ScopeRootInfo.makeScopeInfoImpl(x, respectInlinableModifier);
    }

    private static ScopeRootInfo makeScopeInfoImpl(DartClassMember<?> x, boolean respectInlinableModifier) {
        MethodScopeMapBuilder scopeBuilder = new MethodScopeMapBuilder();
        scopeBuilder.accept(x);
        ClosureRefenceMapBuilder closureBuilder = new ClosureRefenceMapBuilder(scopeBuilder.scopes, respectInlinableModifier);
        closureBuilder.accept(x);
        return new ScopeRootInfo(x, scopeBuilder.scopes, closureBuilder.closures);
    }

    ScopeRootInfo(DartClassMember<?> x, Map<DartNode, DartScope> scopes, Map<DartFunction, ClosureInfo> closures) {
        this.classMember = x;
        this.closures = closures;
        this.scopes = scopes;
        for (DartScope scope : scopes.values()) {
            this.symbols.putAll(scope.getSymbols());
        }
    }

    Element getContainingElement() {
        return this.classMember.getSymbol();
    }

    DartClassMember<?> getContainingClassMember() {
        return this.classMember;
    }

    DartScope.DartSymbolInfo getSymbolInfo(Symbol targetSymbol) {
        return this.symbols.get(targetSymbol);
    }

    public ClosureInfo getClosureInfo(DartFunction x) {
        return this.closures.get(x);
    }

    public DartScope getScope(DartNode x) {
        return this.scopes.get(x);
    }

    public String getNextClosureName() {
        return "c" + this.closureIds++;
    }

    private static class MethodScopeMapBuilder
    extends DartScopesVisitor {
        private Map<DartNode, DartScope> scopes = Maps.newLinkedHashMap();
        private Deque<DartScope> scopeStack = Lists.newLinkedList();

        private MethodScopeMapBuilder() {
        }

        @Override
        boolean enterScope(DartNode x, DartContext ctx) {
            this.scopeStack.push(new DartScope(this.scopeStack.peek()));
            this.scopes.put(x, this.scopeStack.peek());
            return true;
        }

        @Override
        void exitScope(DartNode x, DartContext ctx) {
            this.scopeStack.pop();
        }

        @Override
        public void endVisit(DartParameter x, DartContext ctx) {
            DartScope currentScope = this.scopeStack.peek();
            currentScope.declare(x.getSymbol());
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(DartVariable x, DartContext ctx) {
            DartScope currentScope = this.scopeStack.peek();
            currentScope.declare(x.getSymbol());
            super.endVisit(x, ctx);
        }

        @Override
        public boolean visit(DartFunctionExpression x, DartContext ctx) {
            DartScope currentScope = this.scopeStack.peek();
            boolean visit = super.visit(x, ctx);
            if (!x.isStatement()) {
                currentScope = this.scopeStack.peek();
            }
            currentScope.declare(x.getSymbol());
            return visit;
        }
    }

    private static class ClosureRefenceMapBuilder
    extends DartScopesVisitor {
        private final Map<DartNode, DartScope> scopes;
        private Deque<DartScope> scopeStack = Lists.newLinkedList();
        private final Map<DartFunction, ClosureInfo> closures = Maps.newHashMap();
        private Deque<DartFunction> closureStack = Lists.newLinkedList();
        private final boolean respectInlinableModifier;

        ClosureRefenceMapBuilder(Map<DartNode, DartScope> scopes, boolean respectInlinableModifier) {
            this.scopes = scopes;
            this.respectInlinableModifier = respectInlinableModifier;
        }

        @Override
        boolean enterScope(DartNode x, DartContext ctx) {
            this.scopeStack.push(this.scopes.get(x));
            return true;
        }

        @Override
        void exitScope(DartNode x, DartContext ctx) {
            this.scopeStack.pop();
        }

        @Override
        public boolean visit(DartFunctionObjectInvocation x, DartContext ctx) {
            DartExpression target = x.getTarget();
            if (target instanceof DartFunctionExpression) {
                DartFunctionExpression functionExpression = (DartFunctionExpression)target;
                if (this.respectInlinableModifier && functionExpression.getSymbol().getModifiers().isInlinable()) {
                    this.acceptList(x.getArgs());
                    return this.traverseFunction(functionExpression.getFunction(), ctx);
                }
            }
            return super.visit(x, ctx);
        }

        private boolean traverseFunction(DartFunction function, DartContext ctx) {
            for (DartParameter parameter : function.getParams()) {
                this.doTraverse(parameter, ctx);
            }
            if (function.getBody() != null) {
                this.doTraverse(function.getBody(), ctx);
            }
            return false;
        }

        @Override
        public boolean visit(DartFunction x, DartContext ctx) {
            this.closures.put(x, new ClosureInfo());
            this.closureStack.push(x);
            return super.visit(x, ctx);
        }

        @Override
        public void endVisit(DartFunction x, DartContext ctx) {
            this.closureStack.pop();
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(DartIdentifier x, DartContext ctx) {
            this.processSymbol(x.getTargetSymbol());
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(DartThisExpression x, DartContext ctx) {
            for (DartFunction closure : this.closureStack) {
                ClosureInfo info = this.closures.get(closure);
                info.referencesThis = true;
            }
        }

        private void processSymbol(Symbol targetSymbol) {
            if (targetSymbol != null) {
                DartScope currentScope;
                DartScope symbolScope;
                DartClassMember member;
                DartNode node = targetSymbol.getNode();
                if (node instanceof DartClassMember && !(member = (DartClassMember)node).getModifiers().isStatic()) {
                    for (DartFunction closure : this.closureStack) {
                        ClosureInfo info = this.closures.get(closure);
                        info.referencesThis = true;
                    }
                }
                if (this.closureStack.size() > 0 && (symbolScope = (currentScope = this.scopeStack.peek()).findSymbolScope(targetSymbol)) != null) {
                    boolean referencedFromClosure = false;
                    for (DartFunction closure : this.closureStack) {
                        DartScope closureScope = this.scopes.get(closure);
                        if (symbolScope.getDepth() >= closureScope.getDepth()) continue;
                        ClosureInfo info = this.closures.get(closure);
                        info.referencedScopes.add(symbolScope);
                        referencedFromClosure = true;
                    }
                    if (referencedFromClosure) {
                        symbolScope.getSymbolInfo(targetSymbol).setReferencedFromClosure(true);
                    }
                }
            }
        }
    }

    private static abstract class DartScopesVisitor
    extends NormalizedVisitor {
        private List<DartInitializer> pendingConstructorInitList = null;

        private DartScopesVisitor() {
        }

        @Override
        public boolean visit(DartUnit x, DartContext ctx) {
            return this.enterScope(x, ctx);
        }

        @Override
        public boolean visit(DartClass x, DartContext ctx) {
            return this.enterScope(x, ctx);
        }

        @Override
        public boolean visit(DartMethodDefinition x, DartContext ctx) {
            this.pendingConstructorInitList = x.getInitializers();
            this.accept(x.getFunction());
            return false;
        }

        @Override
        public void endVisit(DartMethodDefinition x, DartContext ctx) {
            assert (this.pendingConstructorInitList == null);
        }

        @Override
        public boolean visit(DartFunctionExpression x, DartContext ctx) {
            if (!x.isStatement()) {
                return this.enterScope(x, ctx);
            }
            return true;
        }

        @Override
        public boolean visit(DartFunction x, DartContext ctx) {
            boolean enter = this.enterScope(x, ctx);
            if (enter) {
                List<DartInitializer> inits = this.pendingConstructorInitList;
                this.pendingConstructorInitList = null;
                this.acceptList(x.getParams());
                if (inits != null) {
                    this.acceptList(inits);
                }
                if (x.getBody() != null) {
                    this.accept(x.getBody());
                }
            }
            return false;
        }

        @Override
        public boolean visit(DartBlock x, DartContext ctx) {
            return this.enterScope(x, ctx);
        }

        @Override
        public boolean visit(DartCatchBlock x, DartContext ctx) {
            return this.enterScope(x, ctx);
        }

        @Override
        public boolean visit(DartForInStatement x, DartContext ctx) {
            return this.enterScope(x, ctx);
        }

        @Override
        public boolean visit(DartForStatement x, DartContext ctx) {
            return this.enterScope(x, ctx);
        }

        @Override
        public void endVisit(DartUnit x, DartContext ctx) {
            this.exitScope(x, ctx);
        }

        @Override
        public void endVisit(DartClass x, DartContext ctx) {
            this.exitScope(x, ctx);
        }

        @Override
        public void endVisit(DartFunctionExpression x, DartContext ctx) {
            if (!x.isStatement()) {
                this.exitScope(x, ctx);
            }
        }

        @Override
        public void endVisit(DartFunction x, DartContext ctx) {
            this.exitScope(x, ctx);
        }

        @Override
        public void endVisit(DartBlock x, DartContext ctx) {
            this.exitScope(x, ctx);
        }

        @Override
        public void endVisit(DartCatchBlock x, DartContext ctx) {
            this.exitScope(x, ctx);
        }

        @Override
        public void endVisit(DartForStatement x, DartContext ctx) {
            this.exitScope(x, ctx);
        }

        abstract boolean enterScope(DartNode var1, DartContext var2);

        abstract void exitScope(DartNode var1, DartContext var2);
    }

    public static class ClosureInfo {
        final Set<DartScope> referencedScopes = Sets.newHashSet();
        boolean referencesThis = false;

        public List<DartScope> getSortedReferencedScopeList() {
            ArrayList<DartScope> sortedScopes = Lists.newArrayList(this.referencedScopes);
            Collections.sort(sortedScopes, new Comparator<DartScope>(){

                @Override
                public int compare(DartScope s1, DartScope s2) {
                    return s1.getDepth() - s2.getDepth();
                }
            });
            return sortedScopes;
        }
    }

    static class DartScope {
        private final DartScope parent;
        private Map<Symbol, DartSymbolInfo> symbols = Maps.newLinkedHashMap();
        private Map<JsScope, JsName> jsAliasNames = Maps.newHashMap();
        private final int depth;

        public DartScope(DartScope parent) {
            this.parent = parent;
            this.depth = parent != null ? parent.getDepth() + 1 : 0;
        }

        public void declare(Symbol symbol) {
            this.symbols.put(symbol, new DartSymbolInfo(this));
        }

        public int getDepth() {
            return this.depth;
        }

        public DartScope getParent() {
            return this.parent;
        }

        public DartScope findSymbolScope(Symbol symbol) {
            for (DartScope current = this; current != null; current = current.getParent()) {
                DartSymbolInfo info = current.getSymbolInfo(symbol);
                if (info == null) continue;
                return current;
            }
            return null;
        }

        public DartSymbolInfo getSymbolInfo(Symbol symbol) {
            return this.symbols.get(symbol);
        }

        public Map<Symbol, DartSymbolInfo> getSymbols() {
            return this.symbols;
        }

        public boolean definesClosureReferencedSymbols() {
            for (DartSymbolInfo symbol : this.symbols.values()) {
                if (!symbol.isReferencedFromClosure()) continue;
                return true;
            }
            return false;
        }

        private String getScopeAliasName() {
            return "dartc_scp$" + this.depth;
        }

        public JsName getAliasForJsScope(JsScope jsScope) {
            JsName result = this.findAliasForJsScope(jsScope);
            if (result == null) {
                result = jsScope.declareFreshName(this.getScopeAliasName());
                this.jsAliasNames.put(jsScope, result);
            }
            return result;
        }

        public JsName findAliasForJsScope(JsScope jsScope) {
            return this.jsAliasNames.get(jsScope);
        }

        static class DartSymbolInfo {
            private final DartScope owningScope;
            private boolean referencedFromClosure = false;

            public DartSymbolInfo(DartScope owningScope) {
                this.owningScope = owningScope;
            }

            public DartScope getOwningScope() {
                return this.owningScope;
            }

            public boolean isReferencedFromClosure() {
                return this.referencedFromClosure;
            }

            public void setReferencedFromClosure(boolean referencedFromClosure) {
                this.referencedFromClosure = referencedFromClosure;
            }
        }
    }
}

