/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.InternalCompilerException;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartArrayAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartBinaryExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartCase;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClassMember;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDefault;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDoWhileStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExprStmt;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartForInStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartForStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionObjectInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIfStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIntegerLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartLabel;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartModVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNewExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNodeTraverser;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParenthesizedExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPropertyAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartRedirectConstructorInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartReturnStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSuperConstructorInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSwitchMember;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSwitchStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartThrowStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnaryExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVariable;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVariableStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartWhileStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.OptimizationStrategy;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.Token;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ConstructorElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CoreTypeProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Elements;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.EnclosingElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FieldElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LabelElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.SyntheticDefaultConstructorElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.VariableElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Types;

public class Normalizer {
    public DartUnit exec(DartUnit unit, CoreTypeProvider typeProvider, OptimizationStrategy optimizationStrategy) {
        new ParenNormalizer().accept(unit);
        new BlockNormalizer(typeProvider).accept(unit);
        new ForLoopInitNormalizer().accept(unit);
        new VarNormalizer().accept(unit);
        unit.accept(new NormalizerVisitor(optimizationStrategy));
        return unit;
    }

    private static class NormalizerVisitor
    extends DartNodeTraverser<DartNode> {
        private final Set<String> usedNames = new HashSet<String>();
        private final OptimizationStrategy optimizationStrategy;

        NormalizerVisitor(OptimizationStrategy optimizationStrategy) {
            this.optimizationStrategy = optimizationStrategy;
        }

        @Override
        public DartNode visitClassMember(DartClassMember<?> node) {
            this.usedNames.clear();
            return (DartNode)super.visitClassMember(node);
        }

        @Override
        public DartNode visitForInStatement(DartForInStatement node) {
            node.visitChildren(this);
            ArrayList<DartStatement> topLevelStatements = new ArrayList<DartStatement>();
            DartMethodInvocation iteratorCall = this.call(node.getIterable(), "iterator");
            DartVariableStatement iteratorVariable = this.makeTempVariable(0, iteratorCall);
            topLevelStatements.add(iteratorVariable);
            DartIdentifier iterator = this.ref(iteratorVariable);
            DartMethodInvocation hasNext = this.call(iterator, "hasNext");
            iterator = this.ref(iteratorVariable);
            DartMethodInvocation next = this.call(iterator, "next");
            DartStatement setup = this.normalizeForInSetup(node, next);
            DartWhileStatement whileStatement = this.whileStmt(hasNext, setup, node.getBody());
            topLevelStatements.add(whileStatement);
            DartBlock newBlock = new DartBlock(topLevelStatements);
            node.setNormalizedNode(newBlock);
            return node;
        }

        private DartStatement normalizeForInSetup(DartForInStatement node, DartExpression next) {
            if (node.introducesVariable()) {
                DartVariableStatement variableStatement = node.getVariableStatement();
                DartVariable oldVariable = variableStatement.getVariables().get(0);
                DartVariable newVariable = new DartVariable((DartIdentifier)oldVariable.getName(), next);
                newVariable.setSymbol(oldVariable.getSymbol());
                return new DartVariableStatement(Lists.newArrayList(newVariable), variableStatement.getTypeNode(), variableStatement.getModifiers());
            }
            return this.exprStmt(this.assign(node.getIdentifier(), next));
        }

        @Override
        public DartNode visitClass(DartClass node) {
            ClassElement classElement = node.getSymbol();
            if (Elements.needsImplicitDefaultConstructor(classElement)) {
                DartMethodDefinition method = this.createImplicitDefaultConstructor(classElement);
                node.getMembers().add(method);
            }
            return (DartNode)super.visitClass(node);
        }

        private DartMethodDefinition createImplicitDefaultConstructor(ClassElement classElement) {
            assert (Elements.needsImplicitDefaultConstructor(classElement));
            DartFunction function = new DartFunction(Collections.<DartParameter>emptyList(), new DartBlock(Collections.<DartStatement>emptyList()), null);
            DartMethodDefinition method = DartMethodDefinition.create(new DartIdentifier(""), function, Modifiers.NONE, null);
            method.setSymbol(new SyntheticDefaultConstructorElement(method, classElement, null));
            return method;
        }

        @Override
        public DartExpression visitBinaryExpression(DartBinaryExpression node) {
            node.visitChildren(this);
            Token operator = node.getOperator();
            if (operator.isAssignmentOperator() && operator != Token.ASSIGN && this.shouldNormalizeOperator(node)) {
                node.setNormalizedNode(this.normalizeCompoundAssignment(this.mapAssignableOp(operator), false, node.getArg1().getNormalizedNode(), node.getArg2().getNormalizedNode()));
            }
            return node;
        }

        @Override
        public DartExpression visitUnaryExpression(DartUnaryExpression node) {
            node.visitChildren(this);
            Token operator = node.getOperator();
            if (operator.isCountOperator() && this.shouldNormalizeOperator(node)) {
                DartExpression lhs = node.getArg().getNormalizedNode();
                DartIntegerLiteral rhs = DartIntegerLiteral.one();
                node.setNormalizedNode(this.normalizeCompoundAssignment(this.mapAssignableOp(operator), !node.isPrefix(), lhs, rhs));
            }
            return node;
        }

        @Override
        public DartMethodDefinition visitMethodDefinition(DartMethodDefinition node) {
            super.visitMethodDefinition(node);
            if (Elements.isNonFactoryConstructor(node.getSymbol())) {
                this.normalizeParameterInitializer(node);
            }
            return node;
        }

        @Override
        public DartNode visitNewExpression(DartNewExpression node) {
            InterfaceType constructorType;
            ConstructorElement symbol = node.getSymbol();
            if (symbol == null && !(constructorType = Types.constructorType(node)).getElement().isDynamic() && node.getArgs().isEmpty()) {
                ClassElement classToInstantiate = constructorType.getElement();
                if (classToInstantiate.getDefaultClass() != null) {
                    classToInstantiate = classToInstantiate.getDefaultClass().getElement();
                }
                if (classToInstantiate != null && Elements.needsImplicitDefaultConstructor(classToInstantiate)) {
                    DartMethodDefinition implicitDefaultConstructor = this.createImplicitDefaultConstructor(classToInstantiate);
                    node.setSymbol(implicitDefaultConstructor.getSymbol());
                }
            }
            return (DartNode)super.visitNewExpression(node);
        }

        @Override
        public DartNode visitSwitchStatement(DartSwitchStatement node) {
            node.getExpression().accept(this);
            for (DartSwitchMember member : node.getMembers()) {
                member.accept(this);
            }
            return node;
        }

        private void normalizeParameterInitializer(DartMethodDefinition node) {
            ClassElement classElement;
            ArrayList<DartInitializer> nInit = new ArrayList<DartInitializer>();
            for (DartParameter param : node.getFunction().getParams()) {
                FieldElement fieldElement = param.getSymbol().getParameterInitializerElement();
                if (fieldElement == null) continue;
                DartIdentifier left = new DartIdentifier(param.getParameterName());
                left.setSymbol(fieldElement);
                left.setSourceInfo(param);
                VariableElement ve = Elements.makeVariable(param.getParameterName());
                DartParameter nParam = new DartParameter((DartExpression)param.getName(), param.getTypeNode(), param.getFunctionParameters(), param.getDefaultExpr(), param.getModifiers());
                nParam.setSymbol(ve);
                param.setNormalizedNode(nParam);
                DartIdentifier right = new DartIdentifier(param.getParameterName());
                right.setSymbol(ve);
                right.setSourceInfo(param);
                DartInitializer di = new DartInitializer(left, right);
                di.setSourceInfo(param);
                nInit.add(di);
            }
            EnclosingElement enclosingElement = node.getSymbol().getEnclosingElement();
            if (ElementKind.of(enclosingElement) == ElementKind.CLASS && !(classElement = (ClassElement)enclosingElement).isObject()) {
                NeedsImplicitSuperInvocationDeterminant superLocator = new NeedsImplicitSuperInvocationDeterminant();
                node.accept(superLocator);
                if (superLocator.needsSuperInvocation) {
                    DartSuperConstructorInvocation superInvocation = new DartSuperConstructorInvocation(new DartIdentifier(""), Collections.<DartExpression>emptyList());
                    superInvocation.setSymbol(new SyntheticDefaultConstructorElement(null, classElement.getSupertype().getElement(), null));
                    nInit.add(new DartInitializer(null, superInvocation));
                }
            }
            if (!nInit.isEmpty()) {
                if (!node.getInitializers().isEmpty()) {
                    nInit.addAll(0, node.getInitializers());
                }
                DartMethodDefinition nConstructor = DartMethodDefinition.create(node.getName(), node.getFunction(), node.getModifiers(), nInit);
                nConstructor.setSymbol(node.getSymbol());
                nConstructor.setSourceInfo(node.getSourceInfo());
                node.setNormalizedNode(nConstructor);
            }
        }

        private DartExpression normalizeCompoundAssignment(Token operator, boolean isPostfix, DartExpression operand1, DartExpression operand2) {
            return operand1.accept(new CompoundAssignmentNormalizer(operator, isPostfix, operand2));
        }

        private String makeTempName(int i) {
            String name;
            do {
                name = "$" + i;
                ++i;
            } while (this.usedNames.contains(name));
            this.usedNames.add(name);
            return name;
        }

        private DartVariableStatement makeTempVariable(int i, DartExpression init) {
            String variableName = this.makeTempName(i);
            DartIdentifier variableIdentifier = new DartIdentifier(variableName);
            DartVariable variable = new DartVariable(variableIdentifier, init);
            VariableElement element = Elements.variableElement(variable, variableName, Modifiers.NONE);
            variable.setSymbol(element);
            return new DartVariableStatement(Lists.newArrayList(variable), null);
        }

        private DartStatement[] statements(DartStatement ... statements) {
            return statements;
        }

        private DartWhileStatement whileStmt(DartExpression condition, DartStatement ... statements) {
            return new DartWhileStatement(condition, new DartBlock(Arrays.asList(statements)));
        }

        private DartExpression call(DartFunctionExpression function, List<DartExpression> args) {
            return new DartFunctionObjectInvocation(function, args);
        }

        private DartMethodInvocation call(DartExpression receiver, String name) {
            return new DartMethodInvocation(receiver, new DartIdentifier(name), Collections.<DartExpression>emptyList());
        }

        private boolean shouldNormalizeOperator(DartBinaryExpression node) {
            return !this.optimizationStrategy.canSkipNormalization(node);
        }

        private boolean shouldNormalizeOperator(DartUnaryExpression node) {
            return !this.optimizationStrategy.canSkipNormalization(node);
        }

        private DartArrayAccess arrayAccess(DartExpression target, DartExpression key) {
            return new DartArrayAccess(target, key);
        }

        private DartReturnStatement retrn(DartExpression value) {
            return new DartReturnStatement(value);
        }

        private DartBinaryExpression bin(Token operator, DartExpression lhs, DartExpression rhs) {
            return new DartBinaryExpression(operator, lhs, rhs);
        }

        private DartBinaryExpression assign(DartExpression lhs, DartExpression rhs) {
            return this.bin(Token.ASSIGN, lhs, rhs);
        }

        private DartExprStmt exprStmt(DartExpression expression) {
            return new DartExprStmt(expression);
        }

        private DartPropertyAccess access(DartExpression qualifier, DartIdentifier name) {
            return new DartPropertyAccess(qualifier, name);
        }

        private DartExpression ref(DartParameter parameter) {
            DartIdentifier identifier = new DartIdentifier(parameter.getParameterName());
            identifier.setSymbol(parameter.getSymbol());
            return identifier;
        }

        private DartIdentifier ref(DartVariableStatement variableStatement) {
            DartVariable variable = variableStatement.getVariables().get(0);
            DartIdentifier identifier = new DartIdentifier(variable.getVariableName());
            identifier.setSymbol(variable.getSymbol());
            return identifier;
        }

        private Token mapAssignableOp(Token operator) {
            switch (operator) {
                case ASSIGN_BIT_OR: {
                    return Token.BIT_OR;
                }
                case ASSIGN_BIT_XOR: {
                    return Token.BIT_XOR;
                }
                case ASSIGN_BIT_AND: {
                    return Token.BIT_AND;
                }
                case ASSIGN_SHL: {
                    return Token.SHL;
                }
                case ASSIGN_SAR: {
                    return Token.SAR;
                }
                case ASSIGN_SHR: {
                    return Token.SHR;
                }
                case ASSIGN_ADD: {
                    return Token.ADD;
                }
                case ASSIGN_SUB: {
                    return Token.SUB;
                }
                case ASSIGN_MUL: {
                    return Token.MUL;
                }
                case ASSIGN_DIV: {
                    return Token.DIV;
                }
                case ASSIGN_MOD: {
                    return Token.MOD;
                }
                case ASSIGN_TRUNC: {
                    return Token.TRUNC;
                }
                case INC: {
                    return Token.ADD;
                }
                case DEC: {
                    return Token.SUB;
                }
            }
            throw new InternalCompilerException("Invalid assignment operator");
        }

        private class CompoundAssignmentNormalizer
        extends DartNodeTraverser<DartExpression> {
            final Token operator;
            final boolean isPostfix;
            final DartExpression rhs;

            CompoundAssignmentNormalizer(Token operator, boolean isPostfix, DartExpression rhs) {
                this.operator = operator;
                this.isPostfix = isPostfix;
                this.rhs = rhs;
            }

            @Override
            public DartExpression visitNode(DartNode lhs) {
                throw new AssertionError(lhs);
            }

            @Override
            public DartExpression visitIdentifier(DartIdentifier id) {
                return this.rewriteExpression(id);
            }

            private DartExpression rewriteExpression(final DartExpression lhs) {
                if (!this.isPostfix) {
                    return NormalizerVisitor.this.assign(lhs, NormalizerVisitor.this.bin(this.operator, lhs, this.rhs));
                }
                return new Let(new DartExpression[]{lhs}){

                    @Override
                    DartStatement[] body() {
                        return NormalizerVisitor.this.statements(new DartStatement[]{NormalizerVisitor.this.exprStmt(NormalizerVisitor.this.assign(lhs, NormalizerVisitor.this.bin(CompoundAssignmentNormalizer.this.operator, this.p(0), CompoundAssignmentNormalizer.this.rhs))), NormalizerVisitor.this.retrn(this.p(0))});
                    }
                }.expression();
            }

            @Override
            public DartExpression visitPropertyAccess(DartPropertyAccess access) {
                Element element = access.getTargetSymbol();
                if (element != null && element.getModifiers().isStatic()) {
                    return this.rewriteExpression(access);
                }
                final DartIdentifier name = access.getName();
                return new RewriteAccess(new DartExpression[]{(DartExpression)access.getQualifier()}){

                    @Override
                    DartExpression operand1() {
                        return NormalizerVisitor.this.access(this.p(0), name);
                    }
                }.expression();
            }

            @Override
            public DartExpression visitArrayAccess(DartArrayAccess access) {
                DartExpression target = access.getTarget();
                DartExpression key = access.getKey();
                return new RewriteAccess(new DartExpression[]{target, key}){

                    @Override
                    DartExpression operand1() {
                        return NormalizerVisitor.this.arrayAccess(this.p(0), this.p(1));
                    }
                }.expression();
            }

            private abstract class RewriteAccess
            extends Let {
                public RewriteAccess(DartExpression ... arguments) {
                    super(arguments);
                }

                abstract DartExpression operand1();

                @Override
                DartStatement[] body() {
                    final DartExpression operand1 = this.operand1();
                    if (CompoundAssignmentNormalizer.this.isPostfix) {
                        Let let = new Let(new DartExpression[]{operand1}){

                            @Override
                            DartStatement[] body() {
                                return NormalizerVisitor.this.statements(new DartStatement[]{NormalizerVisitor.this.exprStmt(NormalizerVisitor.this.assign(operand1, NormalizerVisitor.this.bin(CompoundAssignmentNormalizer.this.operator, this.p(0), CompoundAssignmentNormalizer.this.rhs))), NormalizerVisitor.this.retrn(this.p(0))});
                            }
                        };
                        return NormalizerVisitor.this.statements(new DartStatement[]{NormalizerVisitor.this.retrn(let.expression())});
                    }
                    return NormalizerVisitor.this.statements(new DartStatement[]{NormalizerVisitor.this.retrn(NormalizerVisitor.this.assign(operand1, NormalizerVisitor.this.bin(CompoundAssignmentNormalizer.this.operator, operand1, CompoundAssignmentNormalizer.this.rhs)))});
                }
            }
        }

        private class Let {
            private final List<DartExpression> arguments;
            final DartParameter[] parameters;

            Let(DartExpression ... arguments) {
                this.arguments = Arrays.asList(arguments);
                this.parameters = new DartParameter[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    this.parameters[i] = this.makeTempParameter(i);
                }
            }

            DartExpression expression() {
                DartBlock body = new DartBlock(Arrays.asList(this.body()));
                return NormalizerVisitor.this.call(this.makeFunctionExpression(body), this.arguments);
            }

            private DartFunctionExpression makeFunctionExpression(DartBlock body) {
                DartFunction function = new DartFunction(Arrays.asList(this.parameters), body, null);
                DartFunctionExpression expression = new DartFunctionExpression(null, function, false);
                MethodElement element = Elements.methodFromFunctionExpression(expression, Modifiers.NONE.makeInlinable());
                expression.setSymbol(element);
                for (DartParameter parameter : this.parameters) {
                    Elements.addParameter(element, parameter.getSymbol());
                }
                return expression;
            }

            DartExpression p(int i) {
                return NormalizerVisitor.this.ref(this.parameters[i]);
            }

            DartStatement[] body() {
                return new DartStatement[0];
            }

            private DartParameter makeTempParameter(int i) {
                String name = NormalizerVisitor.this.makeTempName(i);
                DartIdentifier identifier = new DartIdentifier(name);
                DartParameter parameter = new DartParameter(identifier, null, null, null, Modifiers.NONE);
                VariableElement element = Elements.parameterElement(parameter, name, Modifiers.NONE);
                parameter.setSymbol(element);
                return parameter;
            }
        }

        static class NeedsImplicitSuperInvocationDeterminant
        extends DartNodeTraverser<Void> {
            private boolean needsSuperInvocation = true;

            NeedsImplicitSuperInvocationDeterminant() {
            }

            @Override
            public Void visitSuperConstructorInvocation(DartSuperConstructorInvocation node) {
                this.needsSuperInvocation = false;
                return (Void)super.visitSuperConstructorInvocation(node);
            }

            @Override
            public Void visitRedirectConstructorInvocation(DartRedirectConstructorInvocation node) {
                this.needsSuperInvocation = false;
                return (Void)super.visitRedirectConstructorInvocation(node);
            }

            @Override
            public Void visitMethodDefinition(DartMethodDefinition node) {
                for (DartInitializer initializer : node.getInitializers()) {
                    initializer.accept(this);
                }
                return null;
            }
        }
    }

    private static class VarNormalizer
    extends DartModVisitor {
        private VarNormalizer() {
        }

        @Override
        public void endVisit(DartVariableStatement x, DartContext ctx) {
            List<DartVariable> vars = x.getVariables();
            if (vars.size() > 1) {
                for (DartVariable v : vars) {
                    DartVariableStatement stmt = new DartVariableStatement(Lists.newArrayList(v), x.getTypeNode());
                    stmt.setSourceInfo(v);
                    ctx.insertBefore(stmt);
                }
                ctx.removeMe();
            }
        }
    }

    private static class ParenNormalizer
    extends DartModVisitor {
        private ParenNormalizer() {
        }

        @Override
        public void endVisit(DartParenthesizedExpression x, DartContext ctx) {
            ctx.replaceMe(x.getExpression());
        }
    }

    private static class ForLoopInitNormalizer
    extends DartModVisitor {
        private ForLoopInitNormalizer() {
        }

        @Override
        public boolean visit(DartLabel x, DartContext ctx) {
            LabeledForVisitor labelVisitor = new LabeledForVisitor();
            labelVisitor.accept(x);
            if (labelVisitor.forInit != null) {
                ArrayList<DartStatement> stmts = Lists.newArrayList(labelVisitor.forInit, x);
                DartBlock replacement = new DartBlock(stmts);
                ctx.replaceMe(replacement);
                this.accept(replacement);
            }
            return true;
        }

        @Override
        public void endVisit(DartForStatement x, DartContext ctx) {
            DartStatement init = x.getInit();
            if (init != null) {
                DartStatement body = x.getBody();
                DartExpression condition = x.getCondition();
                DartExpression increment = x.getIncrement();
                DartForStatement newFor = new DartForStatement(null, condition, increment, body);
                newFor.setSourceInfo(x);
                DartBlock replacementBlock = new DartBlock(Lists.newArrayList(init, newFor));
                ctx.replaceMe(replacementBlock);
            }
        }

        private static class LabeledForVisitor
        extends DartModVisitor {
            DartStatement forInit = null;

            private LabeledForVisitor() {
            }

            @Override
            public boolean visit(DartForStatement x, DartContext ctx) {
                if (x.getInit() != null) {
                    DartStatement init = x.getInit();
                    if (init != null) {
                        DartStatement body = x.getBody();
                        DartExpression condition = x.getCondition();
                        DartExpression increment = x.getIncrement();
                        DartForStatement newFor = new DartForStatement(null, condition, increment, body);
                        newFor.setSourceInfo(x);
                        ctx.replaceMe(newFor);
                    }
                    this.forInit = init;
                }
                return false;
            }

            @Override
            public boolean visit(DartLabel x, DartContext ctx) {
                DartStatement stmt = x.getStatement();
                return stmt instanceof DartLabel || stmt instanceof DartForStatement;
            }
        }
    }

    private static class BlockNormalizer
    extends DartModVisitor {
        private final ConstructorElement fallThroughError;

        private static ConstructorElement getFallThroughError(CoreTypeProvider typeProvider) {
            ClassElement element = typeProvider.getFallThroughError().getElement();
            ConstructorElement constructor = element.lookupConstructor("");
            if (constructor == null) {
                throw new InternalCompilerException("FallThroughError does not have unnamed constructor.");
            }
            return constructor;
        }

        public BlockNormalizer(CoreTypeProvider typeProvider) {
            this.fallThroughError = BlockNormalizer.getFallThroughError(typeProvider);
        }

        @Override
        public void endVisit(DartLabel x, DartContext ctx) {
            DartStatement body = x.getStatement();
            if (body instanceof DartVariableStatement) {
                ctx.replaceMe(body);
            } else if (!(body instanceof DartBlock) && !this.canContinueControlStructure(body)) {
                DartIdentifier label = x.getLabel();
                DartLabel replacement = new DartLabel(label, this.maybeAddBlock(body));
                LabelElement element = (LabelElement)x.getSymbol();
                element.setNode(replacement);
                replacement.setSymbol(element);
                replacement.setSourceInfo(x);
                ctx.replaceMe(replacement);
            }
        }

        private boolean canContinueControlStructure(DartStatement stmt) {
            return stmt instanceof DartForStatement || stmt instanceof DartWhileStatement || stmt instanceof DartDoWhileStatement;
        }

        @Override
        public void endVisit(DartForStatement x, DartContext ctx) {
            DartStatement body = x.getBody();
            if (!(body instanceof DartBlock)) {
                DartStatement init = x.getInit();
                DartExpression condition = x.getCondition();
                DartExpression increment = x.getIncrement();
                DartForStatement replacement = new DartForStatement(init, condition, increment, this.maybeAddBlock(body));
                replacement.setSourceInfo(x);
                ctx.replaceMe(replacement);
            }
        }

        @Override
        public void endVisit(DartIfStatement x, DartContext ctx) {
            DartStatement thenStmt = x.getThenStatement();
            DartStatement elseStmt = x.getElseStatement();
            if (!(thenStmt instanceof DartBlock) || !(elseStmt instanceof DartBlock)) {
                DartExpression condition = x.getCondition();
                DartIfStatement replacement = new DartIfStatement(condition, this.maybeAddBlock(thenStmt), elseStmt != null ? this.maybeAddBlock(elseStmt) : null);
                replacement.setSourceInfo(x);
                ctx.replaceMe(replacement);
            }
        }

        @Override
        public void endVisit(DartWhileStatement x, DartContext ctx) {
            DartStatement body = x.getBody();
            if (!(body instanceof DartBlock)) {
                DartExpression condition = x.getCondition();
                DartWhileStatement replacement = new DartWhileStatement(condition, this.maybeAddBlock(body));
                replacement.setSourceInfo(x);
                ctx.replaceMe(replacement);
            }
        }

        @Override
        public void endVisit(DartDoWhileStatement x, DartContext ctx) {
            DartStatement body = x.getBody();
            if (!(body instanceof DartBlock)) {
                DartExpression condition = x.getCondition();
                DartDoWhileStatement replacement = new DartDoWhileStatement(condition, this.maybeAddBlock(body));
                replacement.setSourceInfo(x);
                ctx.replaceMe(replacement);
            }
        }

        @Override
        public void endVisit(DartCase caseStmt, DartContext ctx) {
            boolean needsThrow;
            List<DartStatement> stmts = caseStmt.getStatements();
            if (stmts.size() == 0) {
                this.replaceWithBlock(stmts, Lists.newArrayList(stmts));
                return;
            }
            List<DartStatement> innerStatements = stmts;
            if (stmts.get(0) instanceof DartBlock) {
                innerStatements = ((DartBlock)stmts.get(0)).getStatements();
            }
            boolean bl = needsThrow = !this.isLastSwitchMember(caseStmt);
            if (needsThrow) {
                for (DartStatement stmt : innerStatements) {
                    if (!stmt.isAbruptCompletingStatement()) continue;
                    needsThrow = false;
                    break;
                }
            }
            if (!needsThrow && stmts.get(0) instanceof DartBlock) {
                return;
            }
            ArrayList<DartStatement> newStmts = Lists.newArrayList(innerStatements);
            if (needsThrow) {
                newStmts.add(BlockNormalizer.buildThrow(this.fallThroughError, new DartExpression[0]));
            }
            caseStmt.setNormalizedNode(new DartCase(caseStmt.getExpr(), caseStmt.getLabel(), newStmts));
            this.replaceWithBlock(stmts, newStmts);
        }

        private boolean isLastSwitchMember(DartSwitchMember member) {
            int i;
            DartSwitchStatement switchStmt = (DartSwitchStatement)member.getParent();
            List<DartSwitchMember> members = switchStmt.getMembers();
            if (members.get(i = members.size() - 1) == member) {
                return true;
            }
            while (i >= 0) {
                DartSwitchMember curMember = members.get(i);
                if (curMember.getStatements().size() > 0) {
                    return false;
                }
                if (curMember == member) {
                    return true;
                }
                --i;
            }
            return false;
        }

        private static DartStatement buildThrow(ConstructorElement exceptionCtor, DartExpression ... args) {
            DartNewExpression newExpr = new DartNewExpression(new DartTypeNode(new DartIdentifier(exceptionCtor.getName())), Arrays.asList(args), false);
            newExpr.setSymbol(exceptionCtor);
            return new DartThrowStatement(newExpr);
        }

        private void replaceWithBlock(List<DartStatement> stmts, List<DartStatement> newStmts) {
            DartBlock block = new DartBlock(newStmts);
            stmts.clear();
            stmts.add(block);
        }

        @Override
        public void endVisit(DartDefault member, DartContext ctx) {
            List<DartStatement> stmts = member.getStatements();
            if (stmts.size() == 0 || !(stmts.get(0) instanceof DartBlock)) {
                this.replaceWithBlock(stmts, Lists.newArrayList(stmts));
            }
        }

        private DartBlock maybeAddBlock(DartStatement statement) {
            if (statement instanceof DartBlock) {
                return (DartBlock)statement;
            }
            return new DartBlock(Lists.newArrayList(statement));
        }
    }
}

