/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsConstructExpressionVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsFirstExpressionVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsPrecedenceVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsRequiresSemiVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsReservedIdentifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.HasName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBooleanLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBreak;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsCase;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsCatch;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsConditional;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsContinue;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsDebugger;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsDefault;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsDoWhile;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsEmpty;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExprStmt;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsForIn;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsLabel;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsProgramFragment;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsRegExp;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsSwitch;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsThisRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsThrow;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsTry;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVisitable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsWhile;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.GenerateSourceMap;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.HasSourceInfo;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.SourceMapping;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.TextOutput;
import org.jetbrains.jet.internal.com.google.debugging.sourcemap.FilePosition;

public class JsToStringGenerationVisitor
extends JsVisitor {
    private static final char[] CHARS_BREAK = "break".toCharArray();
    private static final char[] CHARS_CASE = "case".toCharArray();
    private static final char[] CHARS_CATCH = "catch".toCharArray();
    private static final char[] CHARS_CONTINUE = "continue".toCharArray();
    private static final char[] CHARS_DEBUGGER = "debugger".toCharArray();
    private static final char[] CHARS_DEFAULT = "default".toCharArray();
    private static final char[] CHARS_DO = "do".toCharArray();
    private static final char[] CHARS_ELSE = "else".toCharArray();
    private static final char[] CHARS_FALSE = "false".toCharArray();
    private static final char[] CHARS_FINALLY = "finally".toCharArray();
    private static final char[] CHARS_FOR = "for".toCharArray();
    private static final char[] CHARS_FUNCTION = "function".toCharArray();
    private static final char[] CHARS_IF = "if".toCharArray();
    private static final char[] CHARS_IN = "in".toCharArray();
    private static final char[] CHARS_NEW = "new".toCharArray();
    private static final char[] CHARS_NULL = "null".toCharArray();
    private static final char[] CHARS_RETURN = "return".toCharArray();
    private static final char[] CHARS_SWITCH = "switch".toCharArray();
    private static final char[] CHARS_THIS = "this".toCharArray();
    private static final char[] CHARS_THROW = "throw".toCharArray();
    private static final char[] CHARS_TRUE = "true".toCharArray();
    private static final char[] CHARS_TRY = "try".toCharArray();
    private static final char[] CHARS_VAR = "var".toCharArray();
    private static final char[] CHARS_WHILE = "while".toCharArray();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("[a-zA-Z_$][\\w$]*");
    protected boolean needSemi = true;
    private Set<JsBlock> globalBlocks = new HashSet<JsBlock>();
    private final TextOutput p;
    private ArrayList<Integer> statementEnds = new ArrayList();
    private ArrayList<Integer> statementStarts = new ArrayList();
    private boolean buildMappings;
    private List<SourceMapping> mappings = Lists.newArrayList();

    public static String javaScriptString(String value) {
        return JsToStringGenerationVisitor.javaScriptString(value, false);
    }

    public static String javaScriptString(String value, boolean forceDoubleQuote) {
        char[] chars = value.toCharArray();
        int n = chars.length;
        int quoteCount = 0;
        int aposCount = 0;
        block14: for (int i = 0; i < n; ++i) {
            switch (chars[i]) {
                case '\"': {
                    ++quoteCount;
                    continue block14;
                }
                case '\'': {
                    ++aposCount;
                }
            }
        }
        StringBuffer result = new StringBuffer(value.length() + 16);
        char quoteChar = quoteCount < aposCount || forceDoubleQuote ? (char)'\"' : '\'';
        result.append(quoteChar);
        for (int i = 0; i < n; ++i) {
            int hexSize;
            char c = chars[i];
            if (' ' <= c && c <= '~' && c != quoteChar && c != '\\') {
                result.append(c);
                continue;
            }
            int escape = -1;
            switch (c) {
                case '\b': {
                    escape = 98;
                    break;
                }
                case '\f': {
                    escape = 102;
                    break;
                }
                case '\n': {
                    escape = 110;
                    break;
                }
                case '\r': {
                    escape = 114;
                    break;
                }
                case '\t': {
                    escape = 116;
                    break;
                }
                case '\"': {
                    escape = 34;
                    break;
                }
                case '\'': {
                    escape = 39;
                    break;
                }
                case '\\': {
                    escape = 92;
                }
            }
            if (escape >= 0) {
                result.append('\\');
                result.append((char)escape);
                continue;
            }
            if (c < ' ' && (i == n - 1 || chars[i + 1] < '0' || chars[i + 1] > '9')) {
                result.append('\\');
                if (c > '\u0007') {
                    result.append((char)(48 + (7 & c >> 3)));
                }
                result.append((char)(48 + (7 & c)));
                continue;
            }
            if (c < '\u0100') {
                result.append("\\x");
                hexSize = 2;
            } else {
                result.append("\\u");
                hexSize = 4;
            }
            for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                int digit = 0xF & c >> shift;
                result.append(HEX_DIGITS[digit]);
            }
        }
        result.append(quoteChar);
        JsToStringGenerationVisitor.escapeClosingTags(result);
        String resultString = result.toString();
        return resultString;
    }

    private static void escapeClosingTags(StringBuffer str) {
        if (str == null) {
            return;
        }
        int index = 0;
        while ((index = str.indexOf("</", index)) != -1) {
            str.insert(index + 1, '\\');
        }
    }

    public JsToStringGenerationVisitor(TextOutput out) {
        this.p = out;
    }

    public void generateSourceMap(boolean generate) {
        this.buildMappings = generate;
    }

    public void writeSourceMap(Appendable out, String name) throws IOException {
        GenerateSourceMap generator = new GenerateSourceMap();
        for (SourceMapping m : this.mappings) {
            generator.addMapping(m.getNode(), m.getStart(), m.getEnd());
        }
        generator.appendTo(out, name);
    }

    @Override
    public void doTraverse(JsVisitable x, JsContext ctx) {
        SourceMapping m = null;
        if (this.buildMappings) {
            m = new SourceMapping((HasSourceInfo)((Object)x), new FilePosition(this.p.getLine(), this.p.getColumn()));
            this.mappings.add(m);
        }
        super.doTraverse(x, ctx);
        if (this.buildMappings) {
            m.setEnd(new FilePosition(this.p.getLine(), this.p.getColumn()));
        }
    }

    @Override
    public boolean visit(JsArrayAccess x, JsContext ctx) {
        JsExpression arrayExpr = x.getArrayExpr();
        this._parenPush(x, arrayExpr, false);
        this.accept(arrayExpr);
        this._parenPop(x, arrayExpr, false);
        this._lsquare();
        this.accept(x.getIndexExpr());
        this._rsquare();
        return false;
    }

    @Override
    public boolean visit(JsArrayLiteral x, JsContext ctx) {
        this._lsquare();
        boolean sep = false;
        Iterator<JsExpression> i$ = x.getExpressions().iterator();
        while (i$.hasNext()) {
            JsExpression element;
            JsExpression arg = element = i$.next();
            sep = this._sepCommaOptSpace(sep);
            this._parenPushIfCommaExpr(arg);
            this.accept(arg);
            this._parenPopIfCommaExpr(arg);
        }
        this._rsquare();
        return false;
    }

    @Override
    public boolean visit(JsBinaryOperation x, JsContext ctx) {
        JsBinaryOperator op = x.getOperator();
        JsExpression arg1 = x.getArg1();
        this._parenPush(x, arg1, !op.isLeftAssociative());
        this.accept(arg1);
        if (op.isKeyword()) {
            this._parenPopOrSpace(x, arg1, !op.isLeftAssociative());
        } else {
            this._parenPop(x, arg1, !op.isLeftAssociative());
            this._spaceOpt();
        }
        this.p.print(op.getSymbol());
        JsExpression arg2 = x.getArg2();
        if (this._spaceCalc(op, arg2)) {
            this._parenPushOrSpace(x, arg2, op.isLeftAssociative());
        } else {
            this._spaceOpt();
            this._parenPush(x, arg2, op.isLeftAssociative());
        }
        this.accept(arg2);
        this._parenPop(x, arg2, op.isLeftAssociative());
        return false;
    }

    @Override
    public boolean visit(JsBlock x, JsContext ctx) {
        this.printJsBlock(x, true, true);
        return false;
    }

    @Override
    public boolean visit(JsBooleanLiteral x, JsContext ctx) {
        if (x.getValue()) {
            this._true();
        } else {
            this._false();
        }
        return false;
    }

    @Override
    public boolean visit(JsBreak x, JsContext ctx) {
        this._break();
        JsNameRef label = x.getLabel();
        if (label != null) {
            this._space();
            this._nameRef(label);
        }
        return false;
    }

    @Override
    public boolean visit(JsCase x, JsContext ctx) {
        this._case();
        this._space();
        this.accept(x.getCaseExpr());
        this._colon();
        this._newlineOpt();
        this.indent();
        Iterator<JsStatement> i$ = x.getStmts().iterator();
        while (i$.hasNext()) {
            JsStatement element;
            JsStatement stmt = element = i$.next();
            this.needSemi = true;
            this.accept(stmt);
            if (this.needSemi) {
                this._semi();
            }
            this._newlineOpt();
        }
        this.outdent();
        this.needSemi = false;
        return false;
    }

    @Override
    public boolean visit(JsCatch x, JsContext ctx) {
        this._spaceOpt();
        this._catch();
        this._spaceOpt();
        this._lparen();
        this._nameDef(x.getParameter().getName());
        JsExpression catchCond = x.getCondition();
        if (catchCond != null) {
            this._space();
            this._if();
            this._space();
            this.accept(catchCond);
        }
        this._rparen();
        this._spaceOpt();
        this.accept(x.getBody());
        return false;
    }

    @Override
    public boolean visit(JsConditional x, JsContext ctx) {
        JsExpression testExpression = x.getTestExpression();
        this._parenPush(x, testExpression, true);
        this.accept(testExpression);
        this._parenPop(x, testExpression, true);
        this._questionMark();
        JsExpression thenExpression = x.getThenExpression();
        this._parenPush(x, thenExpression, false);
        this.accept(thenExpression);
        this._parenPop(x, thenExpression, false);
        this._colon();
        JsExpression elseExpression = x.getElseExpression();
        this._parenPush(x, elseExpression, false);
        this.accept(elseExpression);
        this._parenPop(x, elseExpression, false);
        return false;
    }

    @Override
    public boolean visit(JsContinue x, JsContext ctx) {
        this._continue();
        JsNameRef label = x.getLabel();
        if (label != null) {
            this._space();
            this._nameRef(label);
        }
        return false;
    }

    @Override
    public boolean visit(JsDebugger x, JsContext ctx) {
        this._debugger();
        return false;
    }

    @Override
    public boolean visit(JsDefault x, JsContext ctx) {
        this._default();
        this._colon();
        this.indent();
        Iterator<JsStatement> i$ = x.getStmts().iterator();
        while (i$.hasNext()) {
            JsStatement element;
            JsStatement stmt = element = i$.next();
            this.needSemi = true;
            this.accept(stmt);
            if (this.needSemi) {
                this._semi();
            }
            this._newlineOpt();
        }
        this.outdent();
        this.needSemi = false;
        return false;
    }

    @Override
    public boolean visit(JsDoWhile x, JsContext ctx) {
        this._do();
        this._nestedPush(x.getBody(), true);
        this.accept(x.getBody());
        this._nestedPop(x.getBody());
        if (this.needSemi) {
            this._semi();
            this._newlineOpt();
        } else {
            this._spaceOpt();
            this.needSemi = true;
        }
        this._while();
        this._spaceOpt();
        this._lparen();
        this.accept(x.getCondition());
        this._rparen();
        return false;
    }

    @Override
    public boolean visit(JsEmpty x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsExprStmt x, JsContext ctx) {
        boolean surroundWithParentheses = JsFirstExpressionVisitor.exec(x);
        if (surroundWithParentheses) {
            this._lparen();
        }
        JsExpression expr = x.getExpression();
        this.accept(expr);
        if (surroundWithParentheses) {
            this._rparen();
        }
        return false;
    }

    @Override
    public boolean visit(JsFor x, JsContext ctx) {
        this._for();
        this._spaceOpt();
        this._lparen();
        if (x.getInitExpr() != null) {
            this.accept(x.getInitExpr());
        } else if (x.getInitVars() != null) {
            this.accept(x.getInitVars());
        }
        this._semi();
        if (x.getCondition() != null) {
            this._spaceOpt();
            this.accept(x.getCondition());
        }
        this._semi();
        if (x.getIncrExpr() != null) {
            this._spaceOpt();
            this.accept(x.getIncrExpr());
        }
        this._rparen();
        this._nestedPush(x.getBody(), false);
        this.accept(x.getBody());
        this._nestedPop(x.getBody());
        return false;
    }

    @Override
    public boolean visit(JsForIn x, JsContext ctx) {
        this._for();
        this._spaceOpt();
        this._lparen();
        if (x.getIterVarName() != null) {
            this._var();
            this._space();
            this._nameDef(x.getIterVarName());
            if (x.getIterExpr() != null) {
                this._spaceOpt();
                this._assignment();
                this._spaceOpt();
                this.accept(x.getIterExpr());
            }
        } else {
            this.accept(x.getIterExpr());
        }
        this._space();
        this._in();
        this._space();
        this.accept(x.getObjExpr());
        this._rparen();
        this._nestedPush(x.getBody(), false);
        this.accept(x.getBody());
        this._nestedPop(x.getBody());
        return false;
    }

    @Override
    public boolean visit(JsFunction x, JsContext ctx) {
        this._function();
        if (x.getName() != null) {
            this._space();
            this._nameOf(x);
        }
        this._lparen();
        boolean sep = false;
        Iterator<JsParameter> i$ = x.getParameters().iterator();
        while (i$.hasNext()) {
            JsParameter element;
            JsParameter param = element = i$.next();
            sep = this._sepCommaOptSpace(sep);
            this.accept(param);
        }
        this._rparen();
        this.accept(x.getBody());
        this.needSemi = true;
        return false;
    }

    @Override
    public boolean visit(JsIf x, JsContext ctx) {
        this._if();
        this._spaceOpt();
        this._lparen();
        this.accept(x.getIfExpr());
        this._rparen();
        JsStatement thenStmt = x.getThenStmt();
        this._nestedPush(thenStmt, false);
        this.accept(thenStmt);
        this._nestedPop(thenStmt);
        JsStatement elseStmt = x.getElseStmt();
        if (elseStmt != null) {
            if (this.needSemi) {
                this._semi();
                this._newlineOpt();
            } else {
                this._spaceOpt();
                this.needSemi = true;
            }
            this._else();
            boolean elseIf = elseStmt instanceof JsIf;
            if (!elseIf) {
                this._nestedPush(elseStmt, true);
            } else {
                this._space();
            }
            this.accept(elseStmt);
            if (!elseIf) {
                this._nestedPop(elseStmt);
            }
        }
        return false;
    }

    @Override
    public boolean visit(JsInvocation x, JsContext ctx) {
        JsExpression qualifier = x.getQualifier();
        this._parenPush(x, qualifier, false);
        this.accept(qualifier);
        this._parenPop(x, qualifier, false);
        this._lparen();
        boolean sep = false;
        Iterator<JsExpression> i$ = x.getArguments().iterator();
        while (i$.hasNext()) {
            JsExpression element;
            JsExpression arg = element = i$.next();
            sep = this._sepCommaOptSpace(sep);
            this._parenPushIfCommaExpr(arg);
            this.accept(arg);
            this._parenPopIfCommaExpr(arg);
        }
        this._rparen();
        return false;
    }

    @Override
    public boolean visit(JsLabel x, JsContext ctx) {
        this._nameOf(x);
        this._colon();
        this._spaceOpt();
        this.accept(x.getStmt());
        return false;
    }

    @Override
    public boolean visit(JsNameRef x, JsContext ctx) {
        JsExpression q = x.getQualifier();
        if (q != null) {
            this._parenPush(x, q, false);
            if (q instanceof JsNumberLiteral) {
                this._lparen();
            }
            this.accept(q);
            if (q instanceof JsNumberLiteral) {
                this._rparen();
            }
            this._parenPop(x, q, false);
            this._dot();
        }
        this._nameRef(x);
        return false;
    }

    @Override
    public boolean visit(JsNew x, JsContext ctx) {
        List<JsExpression> args;
        this._new();
        this._space();
        JsExpression ctorExpr = x.getConstructorExpression();
        boolean needsParens = JsConstructExpressionVisitor.exec(ctorExpr);
        if (needsParens) {
            this._lparen();
        }
        this.accept(ctorExpr);
        if (needsParens) {
            this._rparen();
        }
        if ((args = x.getArguments()).size() > 0) {
            this._lparen();
            boolean sep = false;
            for (JsExpression arg : args) {
                sep = this._sepCommaOptSpace(sep);
                this._parenPushIfCommaExpr(arg);
                this.accept(arg);
                this._parenPopIfCommaExpr(arg);
            }
            this._rparen();
        }
        return false;
    }

    @Override
    public boolean visit(JsNullLiteral x, JsContext ctx) {
        this._null();
        return false;
    }

    @Override
    public boolean visit(JsNumberLiteral x, JsContext ctx) {
        double dvalue = x.getValue();
        long lvalue = (long)dvalue;
        if ((double)lvalue == dvalue) {
            this.p.print(Long.toString(lvalue));
        } else {
            this.p.print(Double.toString(dvalue));
        }
        return false;
    }

    @Override
    public boolean visit(JsObjectLiteral x, JsContext ctx) {
        this._lbrace();
        boolean sep = false;
        for (JsPropertyInitializer element : x.getPropertyInitializers()) {
            String propName;
            sep = this._sepCommaOptSpace(sep);
            JsPropertyInitializer propInit = element;
            JsExpression labelExpr = propInit.getLabelExpr();
            if (labelExpr instanceof JsStringLiteral && VALID_NAME_PATTERN.matcher(propName = ((JsStringLiteral)labelExpr).getValue()).matches() && !JsReservedIdentifiers.isKeyword(propName)) {
                this.p.print(propName);
            } else {
                this.accept(labelExpr);
            }
            this._colon();
            JsExpression valueExpr = propInit.getValueExpr();
            this._parenPushIfCommaExpr(valueExpr);
            this.accept(valueExpr);
            this._parenPopIfCommaExpr(valueExpr);
        }
        this._rbrace();
        return false;
    }

    @Override
    public boolean visit(JsParameter x, JsContext ctx) {
        this._nameOf(x);
        return false;
    }

    @Override
    public boolean visit(JsPostfixOperation x, JsContext ctx) {
        JsUnaryOperator op = x.getOperator();
        JsExpression arg = x.getArg();
        this._parenPush(x, arg, false);
        this.accept(arg);
        this._parenPop(x, arg, false);
        this.p.print(op.getSymbol());
        return false;
    }

    @Override
    public boolean visit(JsPrefixOperation x, JsContext ctx) {
        JsUnaryOperator op = x.getOperator();
        this.p.print(op.getSymbol());
        JsExpression arg = x.getArg();
        if (this._spaceCalc(op, arg)) {
            this._space();
        }
        this._parenPush(x, arg, false);
        this.accept(arg);
        this._parenPop(x, arg, false);
        return false;
    }

    @Override
    public boolean visit(JsProgram x, JsContext ctx) {
        this.p.print("<JsProgram>");
        return false;
    }

    @Override
    public boolean visit(JsProgramFragment x, JsContext ctx) {
        this.p.print("<JsProgramFragment>");
        return false;
    }

    @Override
    public boolean visit(JsPropertyInitializer x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsRegExp x, JsContext ctx) {
        this._slash();
        this.p.print(x.getPattern());
        this._slash();
        String flags = x.getFlags();
        if (flags != null) {
            this.p.print(flags);
        }
        return false;
    }

    @Override
    public boolean visit(JsReturn x, JsContext ctx) {
        this._return();
        JsExpression expr = x.getExpr();
        if (expr != null) {
            this._space();
            this.accept(expr);
        }
        return false;
    }

    @Override
    public boolean visit(JsStringLiteral x, JsContext ctx) {
        this.printStringLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(JsSwitch x, JsContext ctx) {
        this._switch();
        this._spaceOpt();
        this._lparen();
        this.accept(x.getExpr());
        this._rparen();
        this._spaceOpt();
        this._blockOpen();
        this.acceptList(x.getCases());
        this._blockClose();
        return false;
    }

    @Override
    public boolean visit(JsThisRef x, JsContext ctx) {
        this._this();
        return false;
    }

    @Override
    public boolean visit(JsThrow x, JsContext ctx) {
        this._throw();
        this._space();
        this.accept(x.getExpr());
        return false;
    }

    @Override
    public boolean visit(JsTry x, JsContext ctx) {
        this._try();
        this._spaceOpt();
        this.accept(x.getTryBlock());
        this.acceptList(x.getCatches());
        JsBlock finallyBlock = x.getFinallyBlock();
        if (finallyBlock != null) {
            this._spaceOpt();
            this._finally();
            this._spaceOpt();
            this.accept(finallyBlock);
        }
        return false;
    }

    @Override
    public boolean visit(JsVars.JsVar x, JsContext ctx) {
        this._nameOf(x);
        JsExpression initExpr = x.getInitExpr();
        if (initExpr != null) {
            this._spaceOpt();
            this._assignment();
            this._spaceOpt();
            this._parenPushIfCommaExpr(initExpr);
            this.accept(initExpr);
            this._parenPopIfCommaExpr(initExpr);
        }
        return false;
    }

    @Override
    public boolean visit(JsVars x, JsContext ctx) {
        this._var();
        this._space();
        boolean sep = false;
        for (JsVars.JsVar var : x) {
            sep = this._sepCommaOptSpace(sep);
            this.accept(var);
        }
        return false;
    }

    @Override
    public boolean visit(JsWhile x, JsContext ctx) {
        this._while();
        this._spaceOpt();
        this._lparen();
        this.accept(x.getCondition());
        this._rparen();
        this._nestedPush(x.getBody(), false);
        this.accept(x.getBody());
        this._nestedPop(x.getBody());
        return false;
    }

    protected void _newline() {
        this.p.newline();
    }

    protected void _newlineOpt() {
        this.p.newlineOpt();
    }

    protected void printJsBlock(JsBlock x, boolean truncate, boolean finalNewline) {
        boolean needBraces;
        boolean bl = needBraces = !x.isGlobalBlock();
        if (needBraces) {
            this._blockOpen();
        }
        int count = 0;
        Iterator<JsStatement> iter = x.getStatements().iterator();
        while (iter.hasNext()) {
            boolean isGlobal;
            boolean bl2 = isGlobal = x.isGlobalBlock() || this.globalBlocks.contains(x);
            if (truncate && count > 3) {
                this.p.print("[...]");
                this._newlineOpt();
                break;
            }
            JsStatement stmt = iter.next();
            this.needSemi = true;
            boolean shouldRecordPositions = isGlobal && !(stmt instanceof JsBlock);
            boolean stmtIsGlobalBlock = false;
            if (isGlobal && stmt instanceof JsBlock) {
                stmtIsGlobalBlock = true;
                this.globalBlocks.add((JsBlock)stmt);
            }
            if (shouldRecordPositions) {
                this.statementStarts.add(this.p.getPosition());
            }
            this.accept(stmt);
            if (stmtIsGlobalBlock) {
                this.globalBlocks.remove(stmt);
            }
            if (this.needSemi) {
                boolean lastStatement;
                boolean functionStmt = stmt instanceof JsExprStmt && ((JsExprStmt)stmt).getExpression() instanceof JsFunction;
                boolean bl3 = lastStatement = !iter.hasNext() && needBraces && !JsRequiresSemiVisitor.exec(stmt);
                if (functionStmt) {
                    if (lastStatement) {
                        this._newlineOpt();
                    } else {
                        this._newline();
                    }
                } else {
                    if (lastStatement) {
                        this._semiOpt();
                    } else {
                        this._semi();
                    }
                    this._newlineOpt();
                }
            }
            if (shouldRecordPositions) {
                assert (this.statementStarts.size() == this.statementEnds.size() + 1);
                this.statementEnds.add(this.p.getPosition());
            }
            ++count;
        }
        if (needBraces) {
            this.p.indentOut();
            this.p.print('}');
            if (finalNewline) {
                this._newlineOpt();
            }
        }
        this.needSemi = false;
    }

    private void _assignment() {
        this.p.print('=');
    }

    private void _blockClose() {
        this.p.indentOut();
        this.p.print('}');
        this._newlineOpt();
    }

    private void _blockOpen() {
        this.p.print('{');
        this.p.indentIn();
        this._newlineOpt();
    }

    private void _break() {
        this.p.print(CHARS_BREAK);
    }

    private void _case() {
        this.p.print(CHARS_CASE);
    }

    private void _catch() {
        this.p.print(CHARS_CATCH);
    }

    private void _colon() {
        this.p.print(':');
    }

    private void _continue() {
        this.p.print(CHARS_CONTINUE);
    }

    private void _debugger() {
        this.p.print(CHARS_DEBUGGER);
    }

    private void _default() {
        this.p.print(CHARS_DEFAULT);
    }

    private void _do() {
        this.p.print(CHARS_DO);
    }

    private void _dot() {
        this.p.print('.');
    }

    private void _else() {
        this.p.print(CHARS_ELSE);
    }

    private void _false() {
        this.p.print(CHARS_FALSE);
    }

    private void _finally() {
        this.p.print(CHARS_FINALLY);
    }

    private void _for() {
        this.p.print(CHARS_FOR);
    }

    private void _function() {
        this.p.print(CHARS_FUNCTION);
    }

    private void _if() {
        this.p.print(CHARS_IF);
    }

    private void _in() {
        this.p.print(CHARS_IN);
    }

    private void _lbrace() {
        this.p.print('{');
    }

    private void _lparen() {
        this.p.print('(');
    }

    private void _lsquare() {
        this.p.print('[');
    }

    private void _nameDef(JsName name) {
        this.p.print(name.getShortIdent());
    }

    private void _nameOf(HasName hasName) {
        this._nameDef(hasName.getName());
    }

    private void _nameRef(JsNameRef nameRef) {
        this.p.print(nameRef.getShortIdent());
    }

    private boolean _nestedPop(JsStatement statement) {
        boolean pop;
        boolean bl = pop = !(statement instanceof JsBlock);
        if (pop) {
            this.p.indentOut();
        }
        return pop;
    }

    private boolean _nestedPush(JsStatement statement, boolean needSpace) {
        boolean push;
        boolean bl = push = !(statement instanceof JsBlock);
        if (push) {
            if (needSpace) {
                this._space();
            }
            this.p.indentIn();
            this._newlineOpt();
        } else {
            this._spaceOpt();
        }
        return push;
    }

    private void _new() {
        this.p.print(CHARS_NEW);
    }

    private void _null() {
        this.p.print(CHARS_NULL);
    }

    private boolean _parenCalc(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        int childPrec;
        int parentPrec = JsPrecedenceVisitor.exec(parent);
        return parentPrec > (childPrec = JsPrecedenceVisitor.exec(child)) || parentPrec == childPrec && wrongAssoc;
    }

    private boolean _parenPop(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPop = this._parenCalc(parent, child, wrongAssoc);
        if (doPop) {
            this._rparen();
        }
        return doPop;
    }

    private boolean _parenPopIfCommaExpr(JsExpression x) {
        boolean doPop;
        boolean bl = doPop = x instanceof JsBinaryOperation && ((JsBinaryOperation)x).getOperator() == JsBinaryOperator.COMMA;
        if (doPop) {
            this._rparen();
        }
        return doPop;
    }

    private boolean _parenPopOrSpace(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPop = this._parenCalc(parent, child, wrongAssoc);
        if (doPop) {
            this._rparen();
        } else {
            this._space();
        }
        return doPop;
    }

    private boolean _parenPush(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPush = this._parenCalc(parent, child, wrongAssoc);
        if (doPush) {
            this._lparen();
        }
        return doPush;
    }

    private boolean _parenPushIfCommaExpr(JsExpression x) {
        boolean doPush;
        boolean bl = doPush = x instanceof JsBinaryOperation && ((JsBinaryOperation)x).getOperator() == JsBinaryOperator.COMMA;
        if (doPush) {
            this._lparen();
        }
        return doPush;
    }

    private boolean _parenPushOrSpace(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPush = this._parenCalc(parent, child, wrongAssoc);
        if (doPush) {
            this._lparen();
        } else {
            this._space();
        }
        return doPush;
    }

    private void _questionMark() {
        this.p.print('?');
    }

    private void _rbrace() {
        this.p.print('}');
    }

    private void _return() {
        this.p.print(CHARS_RETURN);
    }

    private void _rparen() {
        this.p.print(')');
    }

    private void _rsquare() {
        this.p.print(']');
    }

    private void _semi() {
        this.p.print(';');
    }

    private void _semiOpt() {
        this.p.printOpt(';');
    }

    private boolean _sepCommaOptSpace(boolean sep) {
        if (sep) {
            this.p.print(',');
            this._spaceOpt();
        }
        return true;
    }

    private void _slash() {
        this.p.print('/');
    }

    private void _space() {
        this.p.print(' ');
    }

    private boolean _spaceCalc(JsOperator op, JsExpression arg) {
        if (op.isKeyword()) {
            return true;
        }
        if (arg instanceof JsBinaryOperation) {
            JsBinaryOperation binary = (JsBinaryOperation)arg;
            if (binary.getOperator().getPrecedence() > op.getPrecedence()) {
                return this._spaceCalc(op, binary.getArg1());
            }
            return false;
        }
        if (arg instanceof JsPrefixOperation) {
            JsUnaryOperator op2 = ((JsPrefixOperation)arg).getOperator();
            return (op == JsBinaryOperator.SUB || op == JsUnaryOperator.NEG) && (op2 == JsUnaryOperator.DEC || op2 == JsUnaryOperator.NEG) || op == JsBinaryOperator.ADD && op2 == JsUnaryOperator.INC;
        }
        if (arg instanceof JsNumberLiteral) {
            JsNumberLiteral literal = (JsNumberLiteral)arg;
            return (op == JsBinaryOperator.SUB || op == JsUnaryOperator.NEG) && literal.getValue() < 0.0;
        }
        return false;
    }

    private void _spaceOpt() {
        this.p.printOpt(' ');
    }

    private void _switch() {
        this.p.print(CHARS_SWITCH);
    }

    private void _this() {
        this.p.print(CHARS_THIS);
    }

    private void _throw() {
        this.p.print(CHARS_THROW);
    }

    private void _true() {
        this.p.print(CHARS_TRUE);
    }

    private void _try() {
        this.p.print(CHARS_TRY);
    }

    private void _var() {
        this.p.print(CHARS_VAR);
    }

    private void _while() {
        this.p.print(CHARS_WHILE);
    }

    private void indent() {
        this.p.indentIn();
    }

    private void outdent() {
        this.p.indentOut();
    }

    private void printStringLiteral(String value) {
        String resultString = JsToStringGenerationVisitor.javaScriptString(value);
        this.p.print(resultString);
    }
}

