/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js;

import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsNamer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsReservedIdentifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsRootScope;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsScope;

public class JsPrettyNamer
implements JsNamer {
    private Set<String> childIdents = null;
    private final JsProgram program;
    private IdentityHashMap<JsScope, HashMap<String, Integer>> startIdentForScope = new IdentityHashMap();

    public JsPrettyNamer() {
        this.program = null;
    }

    @Override
    public void exec(JsProgram program) {
        new JsPrettyNamer(program).execImpl();
    }

    protected JsPrettyNamer(JsProgram program) {
        this.program = program;
    }

    private void execImpl() {
        this.visit(this.program.getRootScope());
    }

    private boolean isLegal(JsScope scope, Set<String> childIdents, String newIdent) {
        if (JsReservedIdentifiers.isKeyword(newIdent)) {
            return false;
        }
        if (childIdents.contains(newIdent)) {
            return false;
        }
        return scope.findExistingUnobfuscatableName(newIdent) == null;
    }

    private void visit(JsScope scope) {
        HashMap<String, Integer> startIdent = this.startIdentForScope.get(scope);
        if (startIdent == null) {
            startIdent = new HashMap();
            this.startIdentForScope.put(scope, startIdent);
        }
        Set<String> myChildIdents = this.childIdents;
        this.childIdents = new HashSet<String>();
        List<JsScope> children = scope.getChildren();
        Iterator<JsScope> it = children.iterator();
        while (it.hasNext()) {
            this.visit(it.next());
        }
        JsRootScope rootScope = this.program.getRootScope();
        if (scope == rootScope) {
            return;
        }
        Iterator<JsName> it2 = scope.getAllNames();
        while (it2.hasNext()) {
            JsName name = it2.next();
            if (!name.isObfuscatable()) {
                name.setShortIdent(name.getIdent());
                continue;
            }
            String newIdent = name.getShortIdent();
            if (!this.isLegal(scope, this.childIdents, newIdent)) {
                String checkIdent;
                int suffix;
                Integer s = startIdent.get(newIdent);
                int n = suffix = s == null ? 0 : s;
                while (!this.isLegal(scope, this.childIdents, checkIdent = newIdent + "_" + suffix++)) {
                }
                startIdent.put(newIdent, suffix);
                name.setShortIdent(checkIdent);
            }
            this.childIdents.add(name.getShortIdent());
        }
        myChildIdents.addAll(this.childIdents);
        this.childIdents = myChildIdents;
    }
}

