/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.DartMangler;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;

class JsNameProvider {
    private final DartMangler mangler;
    private Map<Symbol, JsName> names = new HashMap<Symbol, JsName>();
    private JsScope globalScope;

    JsNameProvider(JsProgram program, DartMangler mangler) {
        this.globalScope = program.getScope();
        this.mangler = mangler;
    }

    JsName getName(Symbol symbol) {
        JsName jsName = this.names.get(symbol);
        if (jsName != null) {
            assert (!jsName.getShortIdent().equals("Object$Dart"));
            return jsName;
        }
        assert (ElementKind.of(symbol).equals((Object)ElementKind.CLASS) || ElementKind.of(symbol).equals((Object)ElementKind.FUNCTION_TYPE_ALIAS)) : "Only classes or typedefs can be lazily declared. Undeclared: " + symbol.getOriginalSymbolName();
        ClassElement classElement = (ClassElement)symbol;
        String name = classElement.getName();
        String nativeName = classElement.getNativeName();
        if (nativeName == null) {
            String mangledClassName = this.mangler.mangleClassName(classElement);
            jsName = this.globalScope.declareName(mangledClassName, mangledClassName, name);
        } else {
            jsName = this.globalScope.declareName(nativeName);
        }
        jsName.setObfuscatable(false);
        this.names.put(symbol, jsName);
        assert (!jsName.getShortIdent().equals("Object$Dart")) : "unexpected " + ((ClassElement)symbol).getNode().getSource().getName();
        return jsName;
    }

    void setName(Symbol symbol, JsName name) {
        this.names.put(symbol, name);
    }
}

