/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js;

import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsConditional;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExprStmt;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsRegExp;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVisitor;

public class JsFirstExpressionVisitor
extends JsVisitor {
    private boolean needsParentheses = false;

    public static boolean exec(JsExprStmt statement) {
        JsFirstExpressionVisitor visitor = new JsFirstExpressionVisitor();
        JsExpression expression = statement.getExpression();
        if (expression instanceof JsFunction) {
            return false;
        }
        visitor.accept(statement.getExpression());
        return visitor.needsParentheses;
    }

    private JsFirstExpressionVisitor() {
    }

    @Override
    public boolean visit(JsArrayAccess x, JsContext ctx) {
        this.accept(x.getArrayExpr());
        return false;
    }

    @Override
    public boolean visit(JsArrayLiteral x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsBinaryOperation x, JsContext ctx) {
        this.accept(x.getArg1());
        return false;
    }

    @Override
    public boolean visit(JsConditional x, JsContext ctx) {
        this.accept(x.getTestExpression());
        return false;
    }

    @Override
    public boolean visit(JsFunction x, JsContext ctx) {
        this.needsParentheses = true;
        return false;
    }

    @Override
    public boolean visit(JsInvocation x, JsContext ctx) {
        this.accept(x.getQualifier());
        return false;
    }

    @Override
    public boolean visit(JsNameRef x, JsContext ctx) {
        if (!x.isLeaf()) {
            this.accept(x.getQualifier());
        }
        return false;
    }

    @Override
    public boolean visit(JsNew x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsObjectLiteral x, JsContext ctx) {
        this.needsParentheses = true;
        return false;
    }

    @Override
    public boolean visit(JsPostfixOperation x, JsContext ctx) {
        this.accept(x.getArg());
        return false;
    }

    @Override
    public boolean visit(JsPrefixOperation x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsRegExp x, JsContext ctx) {
        return false;
    }
}

