/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js;

import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsPrecedenceVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVisitable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVisitor;

public class JsConstructExpressionVisitor
extends JsVisitor {
    private boolean containsInvocation = false;

    public static boolean exec(JsExpression expression) {
        if (JsPrecedenceVisitor.exec(expression) < 15) {
            return true;
        }
        JsConstructExpressionVisitor visitor = new JsConstructExpressionVisitor();
        visitor.accept(expression);
        return visitor.containsInvocation;
    }

    private JsConstructExpressionVisitor() {
    }

    @Override
    public boolean visit(JsArrayAccess x, JsContext ctx) {
        this.accept(x.getArrayExpr());
        return false;
    }

    @Override
    public boolean visit(JsArrayLiteral x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsFunction x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsInvocation x, JsContext ctx) {
        this.containsInvocation = true;
        return false;
    }

    @Override
    public boolean visit(JsNameRef x, JsContext ctx) {
        if (!x.isLeaf()) {
            this.accept(x.getQualifier());
        }
        return false;
    }

    @Override
    public boolean visit(JsNew x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsObjectLiteral x, JsContext ctx) {
        return false;
    }

    @Override
    protected <T extends JsVisitable> T doAccept(T node) {
        JsExpression expression;
        int precedence;
        T o = node;
        if (o instanceof JsExpression && (precedence = JsPrecedenceVisitor.exec(expression = (JsExpression)o)) < 15) {
            return node;
        }
        return super.doAccept(node);
    }
}

