/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js;

import java.util.Deque;
import java.util.LinkedList;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartField;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartLabel;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVariable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.NormalizedVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.TranslationContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ConstructorElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Elements;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FieldElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;

class GenerateNamesAndScopes
extends NormalizedVisitor {
    private final Deque<JsScope> scopes = new LinkedList<JsScope>();
    private DartClass currentClass = null;
    private int labelUniqifier = 0;
    private int varUniqifier = 0;
    private final TranslationContext translationContext;
    private final LibraryElement unitLibrary;

    private JsScope getGlobalScope() {
        return this.translationContext.getProgram().getScope();
    }

    public GenerateNamesAndScopes(TranslationContext data, LibraryElement unitLibrary) {
        this.translationContext = data;
        this.unitLibrary = unitLibrary;
        this.scopes.push(this.getGlobalScope());
    }

    @Override
    public boolean visit(DartClass x, DartContext ctx) {
        assert (this.currentClass == null);
        this.currentClass = x;
        this.scopes.push(new MemberJsScope(this.scopes.peek(), x.getClassName()));
        return true;
    }

    @Override
    public boolean visit(DartField x, DartContext ctx) {
        FieldElement element = x.getSymbol();
        String mangledFieldName = this.translationContext.getMangler().mangleField(element, this.unitLibrary);
        JsName fieldName = this.declare(x.getSymbol(), mangledFieldName, element.getName());
        fieldName.setObfuscatable(false);
        return true;
    }

    public boolean generateConstructorName(DartMethodDefinition x) {
        ConstructorElement element = (ConstructorElement)x.getSymbol();
        String name = this.translationContext.getMangler().mangleConstructor(element.getName(), this.unitLibrary);
        JsName jsName = this.function(x.getSymbol(), name, element.getName(), x.getFunction());
        jsName.setObfuscatable(false);
        return true;
    }

    @Override
    public boolean visit(DartMethodDefinition x, DartContext ctx) {
        MethodElement element = x.getSymbol();
        if (Elements.isNonFactoryConstructor(element)) {
            return this.generateConstructorName(x);
        }
        if (x.getModifiers().isFactory()) {
            String className = ((ConstructorElement)element).getConstructorType().getName();
            String name = this.translationContext.getMangler().createFactorySyntax(className, element.getName(), this.unitLibrary);
            JsName jsName = this.function(x.getSymbol(), name, element.getName(), x.getFunction());
            jsName.setObfuscatable(false);
            return true;
        }
        String mangledName = this.translationContext.getMangler().mangleMethod(element, this.unitLibrary);
        JsName methodName = this.function(x.getSymbol(), mangledName, element.getName(), x.getFunction());
        methodName.setObfuscatable(false);
        return true;
    }

    @Override
    public boolean visit(DartFunctionExpression x, DartContext ctx) {
        this.function(x.getSymbol(), x.getFunctionName(), x.getFunctionName(), x.getFunction());
        return true;
    }

    @Override
    public boolean visit(DartParameter x, DartContext ctx) {
        if (x.getSymbol() != null) {
            this.declareExclusively(x.getSymbol(), x.getParameterName());
        }
        return true;
    }

    @Override
    public boolean visit(DartVariable x, DartContext ctx) {
        this.declareExclusively(x.getSymbol(), x.getVariableName());
        return true;
    }

    @Override
    public boolean visit(DartLabel x, DartContext ctx) {
        this.declareExclusively(x.getSymbol(), String.format("L%X", this.labelUniqifier++));
        return true;
    }

    @Override
    public void endVisit(DartMethodDefinition x, DartContext ctx) {
        this.scopes.pop();
    }

    @Override
    public void endVisit(DartFunctionExpression x, DartContext ctx) {
        this.scopes.pop();
    }

    @Override
    public void endVisit(DartClass x, DartContext ctx) {
        this.currentClass = null;
        MemberJsScope memberScope = (MemberJsScope)this.scopes.pop();
        memberScope.rebaseChildScopes(memberScope.getParent());
        memberScope.detachFromParent();
        this.translationContext.getMemberScopes().put(x.getSymbol(), memberScope);
    }

    private JsName function(Symbol symbol, String name, String originalName, DartFunction func) {
        JsName jsName = name != null ? this.declareExclusively(symbol, name, originalName) : null;
        JsFunction jsFunc = new JsFunction(this.scopes.peek(), jsName);
        jsFunc.setFromDart(true);
        this.scopes.push(jsFunc.getScope());
        this.translationContext.getMethods().put(func, jsFunc);
        return jsName;
    }

    private JsName declare(Symbol x, String name, String originalName) {
        return this.declareInScope(this.scopes.peek(), x, name, originalName);
    }

    private JsName declareExclusively(Symbol x, String name, String originalName) {
        return this.declareExclusivelyInScope(this.scopes.peek(), x, name, originalName);
    }

    private JsName declareExclusively(Symbol x, String name) {
        return this.declareExclusivelyInScope(this.scopes.peek(), x, name, name);
    }

    private JsName declareExclusivelyInScope(JsScope scope, Symbol x, String name, String originalName) {
        String mappedName = name;
        int offset = 0;
        while (scope.findExistingName(mappedName) != null) {
            mappedName = String.format("%s_%X", mappedName, this.varUniqifier);
            this.varUniqifier = (this.varUniqifier + offset++) % 985531;
        }
        return this.declareInScope(scope, x, mappedName, originalName);
    }

    private JsName declareInScope(JsScope scope, Symbol x, String name, String originalName) {
        JsName jsName = scope.declareName(name, name, originalName);
        jsName.getClass();
        x.getClass();
        this.translationContext.getNames().setName(x, jsName);
        return jsName;
    }

    private static class MemberJsScope
    extends JsScope {
        private MemberJsScope(JsScope parent, String description) {
            super(parent, description);
        }

        @Override
        protected void detachFromParent() {
            super.detachFromParent();
        }
    }
}

