/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilationError;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.InternalCompilerException;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartArrayAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartArrayLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartAssertion;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartBinaryExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartBooleanLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartBreakStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartCase;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartCatchBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClassMember;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartConditional;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContinueStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDefault;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDoWhileStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDoubleLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartEmptyStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExprStmt;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartField;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFieldDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartForInStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartForStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionObjectInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunctionTypeAlias;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIfStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartImportDirective;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIntegerLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartLabel;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartLibraryDirective;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMapLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMapLiteralEntry;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNamedExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNativeBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNativeDirective;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNewExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNodeTraverser;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNullLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParameterizedTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParenthesizedExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPropertyAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartRedirectConstructorInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartResourceDirective;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartReturnStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSourceDirective;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartStringInterpolation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartStringLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSuperConstructorInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSuperExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSwitchStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSyntheticErrorExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSyntheticErrorStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartThisExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartThrowStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTryStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnaryExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnqualifiedInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVariable;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVariableStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartWhileStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.common.TypeHeuristic;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.DartMangler;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.OptimizationStrategy;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.RuntimeTypeInjector;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ScopeRootInfo;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.TranslationContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.TraversalContextProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBreak;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsCase;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsCatch;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsConditional;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsContinue;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsDefault;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsDoWhile;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsEmpty;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExprStmt;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsLabel;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsSwitch;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsSwitchMember;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsThisRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsThrow;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsTry;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsUnaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsValueLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsWhile;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.SourceInfo;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.Token;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ConstructorElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CoreTypeProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Elements;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.EnclosingElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FieldElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FunctionAliasElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.SuperElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.VariableElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Types;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;

public class GenerateJavascriptAST {
    private final DartCompilerContext context;
    private final OptimizationStrategy optStrategy;
    private final DartUnit unit;
    private final CoreTypeProvider typeProvider;
    private final boolean generateClosureCompatibleCode;

    GenerateJavascriptAST(DartUnit unit, CoreTypeProvider typeProvider, DartCompilerContext context, OptimizationStrategy optimizationStrategy, boolean generateClosureCompatibleCode) {
        this.unit = unit;
        this.context = context;
        this.optStrategy = optimizationStrategy;
        this.typeProvider = typeProvider;
        this.generateClosureCompatibleCode = generateClosureCompatibleCode;
    }

    public void translateNode(TranslationContext translationContext, DartNode node, JsBlock blockStatics) {
        GenerateJavascriptVisitor generator = new GenerateJavascriptVisitor(this.unit, this.context, translationContext, this.optStrategy, this.typeProvider, this.generateClosureCompatibleCode);
        node.accept(generator);
        generator.addStaticInitsToBlock(blockStatics);
    }

    static class GenerateJavascriptVisitor
    implements DartPlainVisitor<JsNode>,
    TraversalContextProvider {
        private final boolean generateClosureCompatibleCode;
        private final JsScope globalScope;
        private final JsBlock globalBlock;
        private final List<JsStatement> staticInit = Lists.newArrayList();
        private final Deque<DartFunction> functionStack = new LinkedList<DartFunction>();
        private final Deque<Set<JsName>> jsNewDeclarationsStack = new LinkedList<Set<JsName>>();
        private Element currentHolder;
        private boolean inFactory = false;
        private boolean inFactoryOrStaticContext = false;
        private ScopeRootInfo currentScopeInfo;
        private JsName traceCounter;
        private final RuntimeTypeInjector rtt;
        private final TranslationContext translationContext;
        private final OptimizationStrategy optStrategy;
        private final DartCompilerContext context;
        private final LibraryElement unitLibrary;
        private final DartMangler mangler;
        private final CoreTypeProvider typeProvider;
        private final Types typeUtils;
        private final Deque<JsName> catchVarStack = new ArrayDeque<JsName>();

        private static boolean isSuperCall(Symbol symbol) {
            return ElementKind.of(symbol).equals((Object)ElementKind.SUPER);
        }

        private static boolean isDeclaredAsStaticOrImplicitlyStatic(Element element) {
            Modifiers modifiers = element.getModifiers();
            if (modifiers.isStatic()) {
                return true;
            }
            if (Elements.isTopLevel(element)) {
                ElementKind elementKind = ElementKind.of(element);
                return elementKind == ElementKind.FIELD || elementKind == ElementKind.METHOD;
            }
            return false;
        }

        public GenerateJavascriptVisitor(DartUnit unit, DartCompilerContext context, TranslationContext translationContext, OptimizationStrategy optStrategy, CoreTypeProvider typeProvider, boolean generateClosureCompatibleCode) {
            this.context = context;
            this.translationContext = translationContext;
            this.optStrategy = optStrategy;
            this.typeProvider = typeProvider;
            this.typeUtils = Types.getInstance(typeProvider);
            this.unitLibrary = unit.getLibrary().getElement();
            this.generateClosureCompatibleCode = generateClosureCompatibleCode;
            this.mangler = translationContext.getMangler();
            JsProgram program = translationContext.getProgram();
            this.globalScope = program.getScope();
            this.globalBlock = program.getGlobalBlock();
            this.jsNewDeclarationsStack.push(new HashSet());
            this.currentHolder = unit.getLibrary().getElement();
            this.rtt = new RuntimeTypeInjector(this, typeProvider, translationContext, context.getCompilerConfiguration().developerModeChecks(), this.mangler, this.unitLibrary);
        }

        public void addStaticInitsToBlock(JsBlock block) {
            if (this.staticInit.isEmpty()) {
                return;
            }
            JsFunction init = new JsFunction(this.globalScope);
            JsBlock body = new JsBlock();
            body.getStatements().addAll(this.staticInit);
            init.setBody(body);
            this.staticInit.clear();
            JsNameRef pushRef = AstUtil.newNameRef((JsExpression)new JsNameRef("isolate$inits"), "push");
            JsInvocation invokePush = AstUtil.newInvocation(pushRef, new JsExpression[0]);
            invokePush.getArguments().add(init);
            block.getStatements().add(new JsExprStmt(invokePush));
        }

        private JsScope getCurrentFunctionScope() {
            return this.translationContext.getMethods().get(this.functionStack.peek()).getScope();
        }

        private void registerForDeclaration(JsName name) {
            this.jsNewDeclarationsStack.peek().add(name);
        }

        private JsName createNonVarTempory() {
            JsScope scope = !this.functionStack.isEmpty() ? this.getCurrentFunctionScope() : this.globalScope;
            return scope.declareTemporary();
        }

        @Override
        public JsName createTemporary() {
            JsName temp = this.createNonVarTempory();
            this.registerForDeclaration(temp);
            return temp;
        }

        private JsName getJsName(Symbol symbol) {
            return this.translationContext.getNames().getName(symbol);
        }

        private void generateJsExportedFunction(MethodElement element, JsName name) {
            JsFunction fn = new JsFunction(this.globalScope);
            JsNameRef dartTarget = this.makeMethodJsReference(element, name);
            JsInvocation callIntoDart = AstUtil.newInvocation(dartTarget, new JsExpression[0]);
            List<JsParameter> parameters = fn.getParameters();
            List<JsExpression> arguments = callIntoDart.getArguments();
            for (VariableElement p : element.getParameters()) {
                JsName parameter = fn.getScope().declareFreshName(p.getName());
                parameters.add(new JsParameter(parameter));
                arguments.add(parameter.makeRef());
            }
            JsBlock jsBlock = new JsBlock();
            jsBlock.getStatements().add(new JsReturn(callIntoDart));
            jsBlock.setSourceRef(element.getNode());
            fn.setBody(jsBlock);
            String exportedFunctionName = this.mangler.mangleNativeMethod(element);
            JsName exportedFunctionJsName = this.globalScope.declareName(exportedFunctionName, exportedFunctionName, exportedFunctionName);
            fn.setName(exportedFunctionJsName);
            fn.setSourceRef(element.getNode());
            this.globalBlock.getStatements().add(fn.makeStmt());
        }

        private void generateIsolateDefaultFactoryMember(MethodElement element, JsName funcName) {
            JsName className = this.getJsName(element.getEnclosingElement());
            JsNameRef unmangledName = AstUtil.newNameRef((JsExpression)className.makeRef(), "default$factory");
            JsNameRef factoryName = AstUtil.newNameRef((JsExpression)className.makeRef(), funcName);
            JsBinaryOperation defaultAsg = AstUtil.newAssignment(unmangledName, (JsExpression)factoryName);
            defaultAsg.setSourceRef(element.getNode());
            this.globalBlock.getStatements().add(defaultAsg.makeStmt());
        }

        @Override
        public JsNode visitClass(DartClass x) {
            assert (ElementKind.of(this.currentHolder).equals((Object)ElementKind.LIBRARY)) : "Nested classes should be impossible";
            Element previousHolder = this.currentHolder;
            this.currentHolder = x.getSymbol();
            ClassElement classElement = x.getSymbol();
            JsName classJsName = this.getJsName(classElement);
            if (classElement.getNativeName() == null) {
                if (this.optStrategy.canEmitOptimizedClassConstructor(classElement)) {
                    this.createInlinedClassConstructor(x);
                } else {
                    JsFunction jsClass = new JsFunction(this.globalScope, classJsName).setSourceRef(x);
                    jsClass.setIsConstructor(true);
                    jsClass.setBody(new JsBlock());
                    this.globalBlock.getStatements().add(jsClass.makeStmt());
                }
            }
            if (classElement.isInterface()) {
                this.rtt.generateRuntimeTypeInfo(x);
                for (Element member : classElement.getMembers()) {
                    Modifiers modifiers;
                    if (!ElementKind.of(member).equals((Object)ElementKind.FIELD) || !(modifiers = member.getModifiers()).isStatic() || modifiers.isAbstractField()) continue;
                    assert (modifiers.isFinal());
                    this.generateField((FieldElement)member);
                }
            } else {
                if (x.getSuperSymbol() != null) {
                    JsNameRef superRef = this.getJsName(x.getSuperSymbol()).makeRef();
                    JsInvocation inherits = AstUtil.newInvocation(new JsNameRef("$inherits"), classJsName.makeRef(), superRef);
                    inherits.setSourceRef(x);
                    this.globalBlock.getStatements().add(inherits.makeStmt());
                }
                this.maybeInjectIsolateMethods(classElement);
                this.rtt.generateRuntimeTypeInfo(x);
                ArrayList<Element> classMembers = new ArrayList<Element>();
                classMembers.addAll(classElement.getConstructors());
                for (Element element : classElement.getMembers()) {
                    classMembers.add(element);
                }
                if (Elements.needsImplicitDefaultConstructor(classElement)) {
                    this.addImplicitDefaultConstructor(x, classElement, classMembers);
                }
                block7: for (Element member : classMembers) {
                    switch (ElementKind.of(member)) {
                        case METHOD: {
                            MethodElement methodElement = (MethodElement)member;
                            this.generateMethodDefinition(methodElement);
                            if (methodElement.getModifiers().isOperator()) continue block7;
                            this.generateMethodGetter(methodElement);
                            continue block7;
                        }
                        case CONSTRUCTOR: {
                            this.generateMethodDefinition((MethodElement)member);
                            continue block7;
                        }
                        case FIELD: {
                            this.generateField((FieldElement)member);
                            continue block7;
                        }
                    }
                    throw new AssertionError((Object)("Invalid member " + member));
                }
                if (this.hasConstConstructor(classElement)) {
                    this.makeConstIdMethod(classElement);
                }
                Set<JsName> temps = this.jsNewDeclarationsStack.peek();
                this.declareTempsInBlock(this.globalBlock, temps);
                temps.clear();
            }
            assert (this.currentHolder == x.getSymbol()) : "Unbalanced class visitation";
            this.currentHolder = previousHolder;
            return null;
        }

        private void addImplicitDefaultConstructor(DartClass x, ClassElement classElement, List<Element> classElementMembers) {
            for (DartNode member : x.getMembers()) {
                DartMethodDefinition method;
                MethodElement symbol;
                if (!(member instanceof DartMethodDefinition) || !(symbol = (method = (DartMethodDefinition)member).getSymbol()).isConstructor() || !"".equals(symbol.getName())) continue;
                classElementMembers.add(symbol);
            }
        }

        private void maybeInjectIsolateMethods(ClassElement classElement) {
            if (this.isIsolateClass(classElement)) {
                this.generateIsolateFactory(classElement);
                this.generateIsolateFactoryGetter(classElement);
            }
        }

        private JsName getIsolateFactoryFunctionName(ClassElement classElement) {
            String fnNameStr = this.getJsName(classElement).getShortIdent() + "$" + "isolateFactory";
            return this.globalScope.declareName(fnNameStr);
        }

        private JsNameRef getIsolateFactoryGetterName(ClassElement classElement) {
            return AstUtil.newNameRef((JsExpression)AstUtil.newPrototypeNameRef(this.getJsName(classElement).makeRef()), "getIsolateFactory");
        }

        private void generateIsolateFactory(ClassElement classElement) {
            JsName fnName = this.getIsolateFactoryFunctionName(classElement);
            JsNameRef defaultFactory = AstUtil.newNameRef((JsExpression)this.getJsName(classElement).makeRef(), "default$factory");
            JsInvocation invokeFactory = AstUtil.newInvocation(defaultFactory, new JsExpression[0]);
            JsFunction factoryFn = AstUtil.newFunction(this.globalScope, fnName, null, new JsReturn(invokeFactory));
            this.globalBlock.getStatements().add(factoryFn.makeStmt());
        }

        private void generateIsolateFactoryGetter(ClassElement classElement) {
            JsName fnName = this.getIsolateFactoryFunctionName(classElement);
            JsFunction getterFn = AstUtil.newFunction(this.globalScope, null, null, new JsReturn(fnName.makeRef()));
            JsBinaryOperation declStmt = AstUtil.newAssignment(this.getIsolateFactoryGetterName(classElement), (JsExpression)getterFn);
            this.globalBlock.getStatements().add(declStmt.makeStmt());
        }

        private boolean isIsolateClass(ClassElement classElement) {
            InterfaceType classType = classElement.getType();
            return TypeKind.of(classType) == TypeKind.INTERFACE && this.typeUtils.isSubtype(classType, this.typeProvider.getIsolateType());
        }

        private void generateMethodGetter(MethodElement methodElement) {
            JsExpression asg;
            JsNameRef getterJsNameRef;
            boolean isTopLevel = Elements.isTopLevel(methodElement);
            if (methodElement.getModifiers().isGetter() || methodElement.getModifiers().isSetter()) {
                return;
            }
            JsNameRef classJsNameRef = isTopLevel ? null : this.getJsName(methodElement.getEnclosingElement()).makeRef();
            String getterName = this.mangler.createGetterSyntax(methodElement, this.unitLibrary);
            String methodName = methodElement.getName();
            JsName getterJsName = this.globalScope.declareName(getterName, getterName, methodName);
            getterJsName.setObfuscatable(false);
            String mangledMethodName = this.mangler.mangleNamedMethod(methodElement, this.unitLibrary);
            JsNameRef mangledRttMethod = this.rtt.getRTTLookupMethodNameRef(methodElement);
            JsFunction func = new JsFunction(this.globalScope);
            if (isTopLevel || methodElement.getModifiers().isStatic()) {
                func.setBody(new JsBlock());
                List<JsStatement> stmts = func.getBody().getStatements();
                JsName returnVar = func.getScope().declareFreshName("ret");
                getterJsNameRef = AstUtil.newNameRef((JsExpression)classJsNameRef, getterJsName);
                stmts.add(AstUtil.newVar(null, returnVar, AstUtil.newNameRef((JsExpression)classJsNameRef, mangledMethodName)));
                JsBinaryOperation varLookup = AstUtil.newAssignment(AstUtil.newNameRef((JsExpression)returnVar.makeRef(), "$lookupRTT"), (JsExpression)mangledRttMethod);
                stmts.add(varLookup.makeStmt());
                stmts.add(new JsReturn(returnVar.makeRef()));
            } else {
                JsNameRef prototypeRef = AstUtil.newPrototypeNameRef(classJsNameRef);
                getterJsNameRef = AstUtil.newNameRef((JsExpression)prototypeRef, getterJsName);
                JsInvocation bindMethodCall = AstUtil.newInvocation(new JsNameRef("$bind"), AstUtil.newNameRef((JsExpression)prototypeRef, mangledMethodName), mangledRttMethod, new JsThisRef());
                func.setBody(AstUtil.newBlock(new JsReturn(bindMethodCall)));
            }
            if (isTopLevel) {
                func.setName(getterJsNameRef.getName());
                asg = func;
            } else {
                func.setSourceRef(methodElement.getNode());
                asg = AstUtil.newAssignment(getterJsNameRef, (JsExpression)func);
            }
            asg.setSourceRef(methodElement.getNode());
            this.globalBlock.getStatements().add(asg.makeStmt());
        }

        private boolean hasConstConstructor(ClassElement element) {
            for (ConstructorElement ctr : element.getConstructors()) {
                if (!ctr.getModifiers().isConstant()) continue;
                return true;
            }
            return false;
        }

        private void makeConstIdMethod(ClassElement classElement) {
            JsNameRef methodRef = this.makeConstIdMethodRef(classElement);
            JsExprStmt decl = AstUtil.newAssignment(methodRef, (JsExpression)this.makeConstIdMethodFunction(classElement)).makeStmt();
            this.globalBlock.getStatements().add(decl);
        }

        private JsNameRef makeConstIdMethodRef(ClassElement classElement) {
            JsNameRef qualifier = AstUtil.newPrototypeNameRef(this.getJsName(classElement).makeRef());
            JsNameRef methodRef = AstUtil.newNameRef((JsExpression)qualifier, "$const_id");
            return methodRef;
        }

        private JsFunction makeConstIdMethodFunction(ClassElement classElement) {
            JsFunction func = new JsFunction(this.globalScope);
            JsExpression idExpr = this.rtt.getRTTClassId(classElement);
            for (Element member : classElement.getMembers()) {
                if (member.getKind() != ElementKind.FIELD || member.getModifiers().isStatic()) continue;
                idExpr = this.addConstIdFieldExpr((FieldElement)member, idExpr);
            }
            idExpr = this.addConstIdSuperExpr(classElement, idExpr);
            func.setBody(AstUtil.newBlock(new JsReturn(idExpr)));
            return func;
        }

        private JsExpression addConstIdFieldExpr(FieldElement element, JsExpression prevPart) {
            JsExpression qualifier = this.getGetterSetterQualifier(element);
            JsName fieldJsName = this.getJsName(element);
            JsNameRef ref = AstUtil.newNameRef(qualifier, fieldJsName);
            return this.add(prevPart, this.add(this.string(":"), AstUtil.newInvocation(new JsNameRef("$dart_const_id"), ref)));
        }

        private JsExpression addConstIdSuperExpr(ClassElement element, JsExpression prevPart) {
            InterfaceType superType = element.getSupertype();
            if (superType == null || superType.getElement().isObject()) {
                return prevPart;
            }
            JsNameRef superConstIdRef = this.makeConstIdMethodRef(superType.getElement());
            JsNameRef callRef = AstUtil.newNameRef((JsExpression)superConstIdRef, "call");
            JsInvocation superCall = AstUtil.newInvocation(callRef, new JsThisRef());
            return this.add(prevPart, this.add(this.string("-"), superCall));
        }

        private JsExpression add(JsExpression first, JsExpression second) {
            return new JsBinaryOperation(JsBinaryOperator.ADD, first, second);
        }

        private void generateField(FieldElement element) {
            this.generate(element.getNode());
        }

        private void generateMethodDefinition(MethodElement element) {
            JsFunction func = (JsFunction)this.generate(element.getNode());
            JsName funcName = func.getName();
            this.makeMethod(element, func);
            if (Elements.isNonFactoryConstructor(element) && "".equals(element.getName()) && func.getParameters().size() == 0 && this.isIsolateClass((ClassElement)element.getEnclosingElement())) {
                this.generateIsolateDefaultFactoryMember(element, funcName);
            }
            DartMethodDefinition method = (DartMethodDefinition)element.getNode();
            DartBlock body = method.getFunction().getBody();
            if (element.getModifiers().isNative() && !(body instanceof DartNativeBlock)) {
                this.generateJsExportedFunction(element, funcName);
            }
        }

        private void createInlinedClassConstructor(DartClass x) {
            ClassElement classElement = x.getSymbol();
            assert (classElement.getNativeName() == null);
            JsName classJsName = this.getJsName(classElement);
            JsFunction jsClass = new JsFunction(this.globalScope, classJsName).setSourceRef(x);
            jsClass.setIsConstructor(true);
            JsBlock block = new JsBlock();
            JsScope scope = new JsScope(this.globalScope, "temp");
            for (FieldElement fieldElement : this.getFieldsInClassHierarchy(classElement)) {
                String fieldName = this.translationContext.getMangler().mangleField(fieldElement, this.unitLibrary);
                JsNameRef fieldRef = AstUtil.newNameRef((JsExpression)new JsThisRef(), fieldName);
                JsName paramName = scope.declareName("p$" + fieldName);
                jsClass.getParameters().add(new JsParameter(paramName));
                JsBinaryOperation asg = AstUtil.newAssignment(fieldRef, (JsExpression)new JsNameRef(paramName));
                block.getStatements().add(asg.makeStmt());
            }
            jsClass.setBody(block);
            this.globalBlock.getStatements().add(jsClass.makeStmt());
        }

        private List<FieldElement> getFieldsInClassHierarchy(ClassElement classElement) {
            InterfaceType current = classElement.getType();
            Stack<ClassElement> classes = new Stack<ClassElement>();
            while (current != null && !current.getElement().isObject()) {
                classElement = current.getElement();
                classes.push(classElement);
                current = classElement.getSupertype();
            }
            ArrayList<FieldElement> fields = Lists.newArrayList();
            while (!classes.isEmpty()) {
                classElement = (ClassElement)classes.pop();
                for (Element elem : classElement.getMembers()) {
                    Modifiers modifiers = elem.getModifiers();
                    if (!ElementKind.of(elem).equals((Object)ElementKind.FIELD) || modifiers.isStatic() || modifiers.isAbstractField()) continue;
                    fields.add((FieldElement)elem);
                }
            }
            return fields;
        }

        private void generateAbstractField(FieldElement fieldElement) {
            if (fieldElement.getGetter() != null) {
                this.generateMethodDefinition(fieldElement.getGetter());
            }
            if (fieldElement.getSetter() != null) {
                this.generateMethodDefinition(fieldElement.getSetter());
            }
        }

        private void declareTempsInBlock(JsBlock block, Collection<JsName> tempCollection) {
            Iterator<JsName> temps = tempCollection.iterator();
            if (temps.hasNext()) {
                JsVars jsVars = new JsVars();
                while (temps.hasNext()) {
                    JsName name = temps.next();
                    JsVars.JsVar jsVar = new JsVars.JsVar(name);
                    jsVars.insert(jsVar);
                }
                block.getStatements().add(0, jsVars);
            }
        }

        private List<DartField> getInlineFieldInitializers(ConstructorElement element) {
            ArrayList<DartField> fieldInitializers = new ArrayList<DartField>();
            Iterable<Element> classMembers = element.getEnclosingElement().getMembers();
            for (Element member : classMembers) {
                DartField field;
                Modifiers modifiers = member.getModifiers();
                if (modifiers.isStatic() || modifiers.isAbstractField() || !ElementKind.of(member).equals((Object)ElementKind.FIELD) || (field = (DartField)member.getNode()).getValue() == null) continue;
                fieldInitializers.add(field);
            }
            return fieldInitializers;
        }

        private JsExpression generateInlineFieldInitializer(DartField field) {
            JsNameRef fieldName = AstUtil.newNameRef((JsExpression)new JsThisRef(), this.getJsName(field.getSymbol()));
            JsExpression initExpr = (JsExpression)this.generate(field.getValue());
            return AstUtil.newAssignment(fieldName, initExpr);
        }

        private void addInitializers(DartMethodDefinition constructor, JsFunction factory, JsName tempVar) {
            ConstructorElement element = (ConstructorElement)constructor.getSymbol();
            JsScope classMemberScope = this.translationContext.getMemberScopes().get(element.getEnclosingElement());
            JsName curClassJsName = this.getJsName(element.getEnclosingElement());
            String constructorName = element.getName();
            String initName = this.mangler.createInitializerSyntax(constructorName, this.unitLibrary);
            JsName initJsName = classMemberScope.declareName(initName, initName, constructorName);
            initJsName.setObfuscatable(false);
            JsFunction initFunction = new JsFunction(this.globalScope, initJsName).setSourceRef(constructor);
            initFunction.setBody(new JsBlock());
            this.makeMethod(element, initFunction);
            List<DartParameter> params = constructor.getFunction().getParams();
            for (DartParameter p : params) {
                initFunction.getParameters().add(new JsParameter(this.getJsName(p.getNormalizedNode().getSymbol())));
            }
            List<DartInitializer> initializers = constructor.getInitializers();
            List<DartField> fieldInitializers = this.getInlineFieldInitializers(element);
            if (!initializers.isEmpty() || !fieldInitializers.isEmpty()) {
                this.functionStack.push(constructor.getFunction());
                this.jsNewDeclarationsStack.push(new HashSet());
                List<JsStatement> jsInitializers = initFunction.getBody().getStatements();
                Iterator<DartField> fieldIterator = fieldInitializers.iterator();
                while (fieldIterator.hasNext()) {
                    jsInitializers.add(this.generateInlineFieldInitializer(fieldIterator.next()).makeStmt());
                }
                DartNode initInvocation = null;
                for (DartInitializer initializer : initializers) {
                    if (!initializer.isInvocation()) {
                        jsInitializers.add((JsStatement)this.generate(initializer));
                        continue;
                    }
                    initInvocation = (DartInvocation)initializer.getValue();
                }
                JsInvocation constructorInvocation = this.maybeGenerateSuperOrRedirectCall(constructor);
                if (constructorInvocation != null) {
                    ConstructorElement superElement = (ConstructorElement)initInvocation.getSymbol();
                    String mangledSuperConstructorName = this.mangler.createInitializerSyntax(superElement.getName(), this.unitLibrary);
                    EnclosingElement superClassElement = superElement.getEnclosingElement();
                    JsNameRef superInitRef = AstUtil.newNameRef((JsExpression)this.getJsName(superClassElement).makeRef(), mangledSuperConstructorName);
                    JsNameRef callRef = AstUtil.newNameRef((JsExpression)superInitRef, "call");
                    JsInvocation superInitCall = AstUtil.newInvocation(callRef, new JsExpression[0]);
                    initFunction.getBody().getStatements().add(0, superInitCall.makeStmt());
                    superInitCall.getArguments().addAll(constructorInvocation.getArguments());
                }
                JsNameRef initRef = AstUtil.newNameRef((JsExpression)curClassJsName.makeRef(), initJsName);
                JsNameRef initCallRef = AstUtil.newNameRef((JsExpression)initRef, "call");
                JsInvocation initCall = AstUtil.newInvocation(initCallRef, tempVar.makeRef());
                for (DartParameter p : params) {
                    initCall.getArguments().add(this.getJsName(p.getNormalizedNode().getSymbol()).makeRef());
                }
                factory.getBody().getStatements().add(0, initCall.makeStmt());
                this.declareTempsInBlock(initFunction.getBody(), (Collection<JsName>)this.jsNewDeclarationsStack.pop());
                this.maybeAddFunctionScopeAlias(this.currentScopeInfo.getScope(constructor.getFunction()), initFunction);
                this.functionStack.pop();
            }
        }

        private void addSuperOrRedirectConstructorCall(DartMethodDefinition constructor) {
            JsInvocation superCall = this.maybeGenerateSuperOrRedirectCall(constructor);
            if (superCall != null) {
                JsFunction constructorFunction = this.translationContext.getMethods().get(constructor.getFunction());
                constructorFunction.getBody().getStatements().add(0, superCall.makeStmt());
            }
        }

        private JsInvocation maybeGenerateSuperOrRedirectCall(DartMethodDefinition constructor) {
            List<DartInitializer> initializers = constructor.getInitializers();
            if (!initializers.isEmpty()) {
                for (DartInitializer init : initializers) {
                    JsExprStmt statement;
                    if (!init.isInvocation() || (statement = (JsExprStmt)this.generate(init)) == null) continue;
                    return (JsInvocation)statement.getExpression();
                }
            }
            return null;
        }

        private JsNode generateConstructorDefinition(DartMethodDefinition x) {
            assert (this.currentScopeInfo == null) : "Nesting a constructor in a method should be impossible";
            this.currentScopeInfo = ScopeRootInfo.makeScopeInfo(x, !this.shouldGenerateDeveloperModeChecks());
            ConstructorElement element = (ConstructorElement)x.getSymbol();
            ClassElement classElement = (ClassElement)element.getEnclosingElement();
            JsScope classMemberScope = this.translationContext.getMemberScopes().get(classElement);
            String constructorName = element.getName();
            JsName curClassJsName = this.getJsName(classElement);
            JsFunction dartCtor = (JsFunction)this.generate(x.getFunction());
            this.makeMethod(element, dartCtor);
            String className = element.getConstructorType().getName();
            String factoryName = this.mangler.createFactorySyntax(className, constructorName, this.unitLibrary);
            JsName factoryJsName = classMemberScope.declareName(factoryName, factoryName, constructorName);
            factoryJsName.setObfuscatable(false);
            JsFunction factoryFunction = new JsFunction(this.globalScope, factoryJsName).setSourceRef(x);
            JsScope factoryScope = factoryFunction.getScope();
            JsInvocation constructorInvocation = new JsInvocation();
            JsName constructorJsName = this.getJsName(element);
            JsNameRef constructorRef = AstUtil.newNameRef((JsExpression)curClassJsName.makeRef(), constructorJsName);
            constructorInvocation.setQualifier(AstUtil.newNameRef((JsExpression)constructorRef, "call"));
            List<DartParameter> params = x.getFunction().getParams();
            for (DartParameter p : params) {
                JsName argName = this.getJsName(p.getNormalizedNode().getSymbol());
                constructorInvocation.getArguments().add(argName.makeRef());
            }
            JsName tempVar = factoryScope.declareTemporary();
            constructorInvocation.getArguments().add(0, tempVar.makeRef());
            factoryFunction.setBody(AstUtil.newBlock(constructorInvocation.makeStmt(), new JsReturn(tempVar.makeRef())));
            if (this.optStrategy.canInlineInitializers(element)) {
                this.rtt.maybeAddClassRuntimeTypeToConstructor(classElement, factoryFunction, tempVar.makeRef());
                this.generateInitializersInlined(x, factoryFunction, factoryScope, tempVar);
            } else {
                this.addInitializers(x, factoryFunction, tempVar);
                this.rtt.maybeAddClassRuntimeTypeToConstructor(classElement, factoryFunction, tempVar.makeRef());
                JsNew jsNew = new JsNew(curClassJsName.makeRef());
                factoryFunction.getBody().getStatements().add(0, AstUtil.newVar(x, tempVar, jsNew));
            }
            this.generateAll(x.getFunction().getParams(), factoryFunction.getParameters(), JsParameter.class);
            assert (this.currentScopeInfo != null);
            this.inFactory = false;
            this.inFactoryOrStaticContext = false;
            this.currentScopeInfo = null;
            return factoryFunction;
        }

        private void generateInitializersInlined(DartMethodDefinition x, JsFunction factoryFunction, JsScope factoryScope, JsName tempVar) {
            ConstructorElement element = (ConstructorElement)x.getSymbol();
            JsName curClassJsName = this.getJsName(element.getEnclosingElement());
            HashMap<FieldElement, JsExpression> initMap = new HashMap<FieldElement, JsExpression>();
            JsExpression superInvocation = null;
            for (DartInitializer init : x.getInitializers()) {
                JsExpression initValue = (JsExpression)this.generate(init.getValue());
                if (init.isInvocation()) {
                    superInvocation = initValue;
                    continue;
                }
                assert (ElementKind.of(init.getName().getTargetSymbol()).equals((Object)ElementKind.FIELD));
                FieldElement fieldElement = (FieldElement)init.getName().getTargetSymbol();
                initMap.put(fieldElement, initValue);
            }
            ArrayList<JsVars> stmts = Lists.newArrayList();
            JsNew jsNew = new JsNew(curClassJsName.makeRef());
            ClassElement classElement = (ClassElement)element.getEnclosingElement();
            for (FieldElement fieldElement : this.getFieldsInClassHierarchy(classElement)) {
                String fieldName = this.translationContext.getMangler().mangleField(fieldElement, this.unitLibrary);
                JsName tmp = factoryScope.declareName("init$" + fieldName);
                JsExpression initValue = (JsExpression)initMap.get(fieldElement);
                if (initValue == null) {
                    DartField fieldNode = (DartField)fieldElement.getNode();
                    initValue = fieldNode.getValue() != null ? (JsExpression)this.generate(fieldNode.getValue()) : this.undefined();
                }
                stmts.add(AstUtil.newVar(x, tmp, initValue));
                jsNew.getArguments().add(new JsNameRef(tmp));
            }
            if (superInvocation != null) {
                factoryFunction.getBody().getStatements().add(0, new JsExprStmt(superInvocation));
            }
            stmts.add(AstUtil.newVar(x, tempVar, jsNew));
            factoryFunction.getBody().getStatements().addAll(0, stmts);
        }

        @Override
        public JsNode visitMethodDefinition(DartMethodDefinition x) {
            assert (x == x.getNormalizedNode());
            if (Elements.isNonFactoryConstructor(x.getSymbol())) {
                return this.generateConstructorDefinition(x);
            }
            assert (this.currentScopeInfo == null) : "Nested methods should be impossible";
            this.inFactory = x.getModifiers().isFactory();
            this.inFactoryOrStaticContext = this.isFactoryOrStaticContext(x.getModifiers());
            this.currentScopeInfo = ScopeRootInfo.makeScopeInfo(x, !this.shouldGenerateDeveloperModeChecks());
            JsFunction func = (JsFunction)this.generate(x.getFunction());
            assert (this.currentScopeInfo != null);
            this.inFactory = false;
            this.inFactoryOrStaticContext = false;
            this.currentScopeInfo = null;
            if (Elements.isTopLevel(x.getSymbol())) {
                JsFunction tramp = this.generateNamedParameterMethodTrampoline(x, func.getName().makeRef());
                String mangled = this.mangler.mangleNamedMethod(x.getSymbol(), this.unitLibrary);
                JsName trampName = this.globalScope.declareName(mangled);
                tramp.setName(trampName);
                this.globalBlock.getStatements().add(func.makeStmt());
                this.globalBlock.getStatements().add(tramp.makeStmt());
                this.rtt.generateRuntimeTypeInfo(x);
                this.generateMethodGetter(x.getSymbol());
            }
            return func;
        }

        private JsFunction generateNamedParameterMethodTrampoline(DartMethodDefinition method, JsNameRef origJsName) {
            boolean preserveThis = !method.getModifiers().isStatic() && !method.getModifiers().isFactory() && !Elements.isTopLevel(method.getSymbol());
            return this.generateNamedParameterTrampoline(method.getFunction(), origJsName, 0, preserveThis);
        }

        private JsFunction generateNamedParameterTrampoline(DartFunction func, JsNameRef origJsName, int numClosureScopes, boolean preserveThis) {
            int i;
            JsFunction tramp = new JsFunction(this.globalScope);
            JsScope scope = tramp.getScope();
            boolean hasNamedParams = false;
            ArrayList<JsParameter> explicitJsParams = new ArrayList<JsParameter>();
            for (DartParameter dartParam : func.getParams()) {
                String paramName = ((DartIdentifier)dartParam.getName()).getTargetName();
                JsParameter param = new JsParameter(scope.declareName(paramName));
                explicitJsParams.add(param);
                if (!dartParam.getModifiers().isNamed()) continue;
                hasNamedParams = true;
            }
            ArrayList<JsParameter> closureScopeParams = new ArrayList<JsParameter>();
            for (int i2 = 0; i2 < numClosureScopes; ++i2) {
                JsParameter param = new JsParameter(scope.declareFreshName("$s" + i2));
                closureScopeParams.add(param);
            }
            JsParameter countParam = new JsParameter(scope.declareFreshName("$n"));
            JsParameter namedParam = new JsParameter(scope.declareFreshName("$o"));
            for (i = 0; i < numClosureScopes; ++i) {
                tramp.getParameters().add((JsParameter)closureScopeParams.get(i));
            }
            tramp.getParameters().add(countParam);
            tramp.getParameters().add(namedParam);
            for (i = 0; i < explicitJsParams.size(); ++i) {
                tramp.getParameters().add((JsParameter)explicitJsParams.get(i));
            }
            JsBlock body = new JsBlock();
            tramp.setBody(body);
            List<JsStatement> stmts = body.getStatements();
            if (hasNamedParams) {
                JsName seen = scope.declareFreshName("seen");
                JsName def = scope.declareFreshName("def");
                stmts.add(AstUtil.newVar(null, seen, this.number(0.0)));
                stmts.add(AstUtil.newVar(null, def, this.number(0.0)));
                JsSwitch jsSwitch = new JsSwitch();
                jsSwitch.setExpr(countParam.getName().makeRef());
                for (int i3 = 0; i3 < func.getParams().size(); ++i3) {
                    DartParameter param = func.getParams().get(i3);
                    JsParameter jsParam = tramp.getParameters().get(i3 + 2 + numClosureScopes);
                    if (!param.getModifiers().isNamed()) continue;
                    String paramNameStr = this.getPropNameForNamedParameter(jsParam);
                    JsExpression paramName = this.string(this.getPropNameForNamedParameter(jsParam));
                    if (this.generateClosureCompatibleCode) {
                        paramName = AstUtil.call(null, AstUtil.nameref(null, "JSCompiler_renameProperty"), paramName);
                    }
                    JsExpression ifExpr = AstUtil.in(null, paramName, namedParam.getName().makeRef());
                    JsExpression ppSeen = AstUtil.preinc(null, seen.makeRef());
                    JsBinaryOperation thenExpr = AstUtil.comma(null, ppSeen, AstUtil.newNameRef((JsExpression)namedParam.getName().makeRef(), paramNameStr));
                    DartExpression defaultValue = param.getDefaultExpr();
                    JsExpression elseExpr = defaultValue != null ? this.generateDefaultValue(defaultValue) : this.undefined();
                    JsExpression ppDef = AstUtil.preinc(null, def.makeRef());
                    elseExpr = AstUtil.comma(null, ppDef, elseExpr);
                    JsBinaryOperation asg = this.assign(jsParam.getName().makeRef(), new JsConditional(ifExpr, thenExpr, elseExpr));
                    jsSwitch.getCases().add(AstUtil.newCase(this.number(i3), asg.makeStmt()));
                }
                if (jsSwitch.getCases().size() > 0) {
                    stmts.add(jsSwitch);
                }
                JsBinaryOperation ifLeft = this.neq(seen.makeRef(), AstUtil.newNameRef((JsExpression)namedParam.getName().makeRef(), "count"));
                JsExpression add1 = this.add(seen.makeRef(), def.makeRef());
                JsExpression add2 = this.add(add1, countParam.getName().makeRef());
                JsBinaryOperation ifRight = this.neq(add2, this.number(func.getParams().size()));
                JsBinaryOperation ifExpr = this.or(ifLeft, ifRight);
                JsExprStmt thenStmt = AstUtil.newInvocation(new JsNameRef("$nsme"), new JsExpression[0]).makeStmt();
                stmts.add(new JsIf(ifExpr, thenStmt, null));
            } else {
                JsBinaryOperation ifExpr = this.or(AstUtil.newNameRef((JsExpression)namedParam.getName().makeRef(), "count"), this.neq(countParam.getName().makeRef(), this.number(func.getParams().size())));
                JsExprStmt thenStmt = AstUtil.newInvocation(new JsNameRef("$nsme"), new JsExpression[0]).makeStmt();
                stmts.add(new JsIf(ifExpr, thenStmt, null));
            }
            JsInvocation jsInvoke = AstUtil.newInvocation(AstUtil.newNameRef(origJsName.getQualifier(), origJsName.getName()), new JsExpression[0]);
            if (preserveThis) {
                JsNameRef call = AstUtil.newNameRef(jsInvoke.getQualifier(), "call");
                jsInvoke = AstUtil.newInvocation(call, new JsThisRef());
            }
            for (int i4 = 0; i4 < numClosureScopes; ++i4) {
                jsInvoke.getArguments().add(((JsParameter)closureScopeParams.get(i4)).getName().makeRef());
            }
            for (JsParameter jsParam : explicitJsParams) {
                jsInvoke.getArguments().add(jsParam.getName().makeRef());
            }
            stmts.add(new JsReturn(jsInvoke));
            return tramp;
        }

        private String mangleNamedParameterName(String name) {
            return "$p_" + name;
        }

        private String getPropNameForNamedParameter(JsParameter jsParam) {
            return this.mangleNamedParameterName(jsParam.getName().getShortIdent());
        }

        private String getPropNameForNamedParameter(DartNamedExpression namedExpr) {
            return this.mangleNamedParameterName(namedExpr.getName().getTargetName());
        }

        private void maybeAddFunctionScopeAlias(ScopeRootInfo.DartScope scope, JsFunction function) {
            if (scope.definesClosureReferencedSymbols()) {
                JsScope jsScope = function.getScope();
                JsBlock body = function.getBody();
                JsObjectLiteral aliasInit = new JsObjectLiteral();
                for (Map.Entry<Symbol, ScopeRootInfo.DartScope.DartSymbolInfo> entry : scope.getSymbols().entrySet()) {
                    if (!entry.getValue().isReferencedFromClosure()) continue;
                    JsName param = this.getJsName(entry.getKey());
                    aliasInit.getPropertyInitializers().add(new JsPropertyInitializer(this.string(param.getIdent()), new JsNameRef(param)));
                }
                JsName aliasName = scope.getAliasForJsScope(jsScope);
                assert (aliasName != null);
                JsVars aliasDecl = AstUtil.newVar(null, aliasName, aliasInit);
                body.getStatements().add(0, aliasDecl);
            }
        }

        private JsName getTraceCounter() {
            if (this.traceCounter == null) {
                this.traceCounter = this.globalScope.declareTemporary();
                JsVars counterDecl = AstUtil.newVar(null, this.traceCounter, this.number(0.0));
                this.globalBlock.getStatements().add(0, counterDecl);
            }
            return this.traceCounter;
        }

        private JsNameRef makeMethodJsReference(Element element, JsName name) {
            boolean isNonFactoryConstructor = Elements.isNonFactoryConstructor(element);
            Modifiers modifiers = element.getModifiers();
            JsNameRef classJsName = this.getJsName(element.getEnclosingElement()).makeRef();
            JsNameRef qualifier = modifiers.isStatic() || modifiers.isFactory() || isNonFactoryConstructor ? classJsName : AstUtil.newPrototypeNameRef(classJsName);
            JsNameRef prop = AstUtil.newNameRef((JsExpression)qualifier, name);
            prop.setSourceRef(element.getNode());
            return prop;
        }

        private boolean isFactoryOrStaticContext(Modifiers modifiers) {
            return modifiers.isFactory() || modifiers.isStatic();
        }

        private void makeMethod(Element element, JsFunction func) {
            if (element.getEnclosingElement().getKind().equals((Object)ElementKind.CLASS)) {
                JsNameRef prop = this.makeMethodJsReference(element, func.getName());
                func.setName(null);
                JsBinaryOperation asg = AstUtil.newAssignment(prop, (JsExpression)func);
                asg.setSourceRef(element.getNode());
                this.globalBlock.getStatements().add(asg.makeStmt());
                if (element.getKind().equals((Object)ElementKind.METHOD) && !element.getModifiers().isOperator() && !element.getModifiers().isGetter() && !element.getModifiers().isSetter()) {
                    String mangled = this.mangler.mangleNamedMethod((MethodElement)element, this.unitLibrary);
                    JsName namedName = prop.getName().getEnclosing().declareName(mangled);
                    JsNameRef namedProp = this.makeMethodJsReference(element, namedName);
                    DartMethodDefinition method = (DartMethodDefinition)element.getNode();
                    JsFunction tramp = this.generateNamedParameterMethodTrampoline(method, prop);
                    asg = this.assign(namedProp, tramp);
                    this.globalBlock.getStatements().add(asg.makeStmt());
                    assert (this.currentScopeInfo == null) : "Nested methods should be impossible";
                    this.inFactory = element.getModifiers().isFactory();
                    this.inFactoryOrStaticContext = this.isFactoryOrStaticContext(element.getModifiers());
                    DartMethodDefinition x = (DartMethodDefinition)element.getNode();
                    this.currentScopeInfo = ScopeRootInfo.makeScopeInfo(x, !this.shouldGenerateDeveloperModeChecks());
                    this.rtt.generateRuntimeTypeInfo(x);
                    assert (this.currentScopeInfo != null);
                    this.inFactory = false;
                    this.inFactoryOrStaticContext = false;
                    this.currentScopeInfo = null;
                }
            } else {
                this.globalBlock.getStatements().add(func.makeStmt());
            }
        }

        private JsExpression getGetterSetterQualifier(Element element) {
            if (GenerateJavascriptVisitor.isDeclaredAsStaticOrImplicitlyStatic(element)) {
                return new JsNameRef("isolate$current");
            }
            if (Elements.isTopLevel(element)) {
                return null;
            }
            return new JsThisRef();
        }

        private void makePropertyGetter(FieldElement element) {
            JsExpression qualifier = this.getGetterSetterQualifier(element);
            JsName fieldJsName = this.getJsName(element);
            JsNameRef ref = AstUtil.newNameRef(qualifier, fieldJsName);
            this.makeGetter(element, ref);
        }

        private void makeConstantValueGetter(FieldElement element, JsExpression value) {
            assert (element.getModifiers().isFinal());
            this.makeGetter(element, value);
        }

        private void makeGetter(FieldElement element, JsExpression expression) {
            String getterName = this.mangler.createGetterSyntax(element, this.unitLibrary);
            String fieldName = element.getName();
            JsName getterJsName = this.globalScope.declareName(getterName, getterName, fieldName);
            getterJsName.setObfuscatable(false);
            JsFunction func = new JsFunction(this.globalScope, getterJsName);
            func.setBody(AstUtil.newBlock(new JsReturn(expression)));
            this.makeMethod(element, func);
        }

        private void makeMethodCallThroughFieldShim(DartField x) {
            JsExpression qualifier;
            FieldElement element = x.getSymbol();
            if (Elements.isTopLevel(element)) {
                return;
            }
            String shimName = this.mangler.mangleNamedMethod(element.getName(), this.unitLibrary);
            String fieldName = element.getName();
            JsName shimJsName = this.globalScope.declareName(shimName, shimName, fieldName);
            shimJsName.setObfuscatable(false);
            JsFunction func = new JsFunction(this.globalScope, shimJsName);
            if (element.getModifiers().isStatic()) {
                EnclosingElement enclosingElement = element.getEnclosingElement();
                switch (enclosingElement.getKind()) {
                    case CLASS: {
                        qualifier = AstUtil.newNameRef(null, this.mangler.mangleClassName((ClassElement)enclosingElement));
                        break;
                    }
                    case LIBRARY: {
                        qualifier = null;
                        break;
                    }
                    default: {
                        throw new InternalCompilerException("Unhandled type of static element making method shim.");
                    }
                }
            } else {
                qualifier = this.getGetterSetterQualifier(element);
            }
            String getterName = this.mangler.createGetterSyntax(element, this.unitLibrary);
            JsExpression expression = AstUtil.newInvocation(AstUtil.newNameRef(qualifier, getterName), new JsExpression[0]);
            expression = AstUtil.newNameRef(expression, "apply");
            expression = AstUtil.newInvocation(expression, new JsThisRef(), AstUtil.newNameRef(null, "arguments"));
            func.setBody(AstUtil.newBlock(new JsReturn(expression)));
            this.makeMethod(element, func);
        }

        private void makeInitializingGetter(FieldElement element, JsExpression initExpression) {
            String getterName = this.mangler.createGetterSyntax(element, this.unitLibrary);
            String fieldName = element.getName();
            JsName getterJsName = this.globalScope.declareName(getterName, getterName, fieldName);
            getterJsName.setObfuscatable(false);
            JsFunction func = new JsFunction(this.globalScope, getterJsName);
            JsScope scope = new JsScope(this.globalScope, "temp");
            JsExpression fieldQualifier = this.getGetterSetterQualifier(element);
            JsName fieldJsName = this.getJsName(element);
            JsName t0 = scope.declareTemporary();
            JsName t1 = scope.declareTemporary();
            JsName t2 = scope.declareTemporary();
            JsVars initializeT0 = AstUtil.newVar(null, t0, AstUtil.newNameRef(fieldQualifier, fieldJsName));
            JsVars initializeT1 = AstUtil.newVar(null, t1, new JsNameRef("static$initializing"));
            JsIf checkIfCircular = new JsIf(new JsBinaryOperation(JsBinaryOperator.REF_EQ, t0.makeRef(), t1.makeRef()), new JsThrow(this.string("circular initialization")), null);
            JsIf checkIfInitialized = new JsIf(new JsBinaryOperation(JsBinaryOperator.REF_NEQ, t0.makeRef(), new JsNameRef("static$uninitialized")), new JsReturn(t0.makeRef()), null);
            JsExprStmt markField = AstUtil.newAssignment(AstUtil.newNameRef(fieldQualifier, fieldJsName), (JsExpression)t1.makeRef()).makeStmt();
            JsVars initializeT2 = AstUtil.newVar(null, t2, initExpression);
            JsExprStmt initializeField = AstUtil.newAssignment(AstUtil.newNameRef(fieldQualifier, fieldJsName), (JsExpression)t2.makeRef()).makeStmt();
            JsReturn returnT2 = new JsReturn(t2.makeRef());
            func.setBody(AstUtil.newBlock(initializeT0, initializeT1, checkIfCircular, checkIfInitialized, markField, initializeT2, initializeField, returnT2));
            this.makeMethod(element, func);
        }

        private void makeSetter(FieldElement element) {
            String fieldName = element.getName();
            String setterName = this.mangler.createSetterSyntax(element, this.unitLibrary);
            JsName setterJsName = this.globalScope.declareName(setterName, setterName, fieldName);
            setterJsName.setObfuscatable(false);
            JsFunction func = new JsFunction(this.globalScope, setterJsName);
            JsScope scope = new JsScope(this.globalScope, "temp");
            JsName parameter = scope.declareTemporary();
            func.getParameters().add(0, new JsParameter(parameter));
            JsExpression qualifier = this.getGetterSetterQualifier(element);
            JsName fieldJsName = this.getJsName(element);
            JsNameRef ref = AstUtil.newNameRef(qualifier, fieldJsName);
            JsBinaryOperation asg = AstUtil.newAssignment(ref, (JsExpression)parameter.makeRef());
            func.setBody(AstUtil.newBlock(new JsExprStmt(asg)));
            this.makeMethod(element, func);
        }

        @Override
        public JsNode visitInitializer(DartInitializer x) {
            JsExpression e = (JsExpression)this.generate(x.getValue());
            if (e != null && !x.isInvocation()) {
                JsName fieldJsName = this.getJsName(x.getName().getTargetSymbol());
                assert (fieldJsName != null) : "Field name must have been resolved.";
                JsNameRef field = AstUtil.newNameRef((JsExpression)new JsThisRef(), fieldJsName);
                e = AstUtil.newAssignment(field, e);
                e.setSourceRef(x);
            }
            return e != null ? new JsExprStmt(e) : null;
        }

        @Override
        public JsNode visitFieldDefinition(DartFieldDefinition node) {
            assert (ElementKind.of(this.currentHolder).equals((Object)ElementKind.LIBRARY));
            for (DartField field : node.getFields()) {
                this.generateTopLevelField(field);
            }
            return null;
        }

        private void generateTopLevelField(DartField field) {
            if (field.getSymbol().getModifiers().isAbstractField()) {
                this.generate(field.getAccessor());
            } else {
                this.generate(field);
            }
        }

        @Override
        public JsNode visitField(DartField x) {
            this.makeMethodCallThroughFieldShim(x);
            FieldElement element = x.getSymbol();
            Modifiers modifiers = element.getModifiers();
            if (modifiers.isAbstractField()) {
                this.generateAbstractField(element);
                return null;
            }
            DartExpression initializer = x.getValue();
            JsExprStmt result = null;
            if (initializer != null || Elements.isTopLevel(element)) {
                JsNameRef fieldName;
                this.currentScopeInfo = ScopeRootInfo.makeScopeInfo(x, !this.shouldGenerateDeveloperModeChecks());
                this.inFactoryOrStaticContext = true;
                if (GenerateJavascriptVisitor.isDeclaredAsStaticOrImplicitlyStatic(element)) {
                    JsExpression qualifier = this.getGetterSetterQualifier(element);
                    fieldName = AstUtil.newNameRef(qualifier, this.translationContext.getNames().getName(element));
                } else {
                    fieldName = AstUtil.newNameRef((JsExpression)new JsThisRef(), this.getJsName(element));
                }
                JsExpression initExpr = initializer == null ? this.undefined() : (JsExpression)this.generate(initializer);
                boolean emitStaticInitialization = true;
                if (x.getModifiers().isFinal() && (initializer == null || initExpr instanceof JsValueLiteral)) {
                    this.makeConstantValueGetter(element, initExpr);
                    emitStaticInitialization = false;
                } else if (initializer == null || initExpr instanceof JsLiteral) {
                    this.makePropertyGetter(element);
                } else {
                    this.makeInitializingGetter(element, initExpr);
                    initExpr = new JsNameRef("static$uninitialized");
                }
                if (emitStaticInitialization) {
                    JsBinaryOperation assignment = AstUtil.newAssignment(fieldName, initExpr);
                    assignment.setSourceRef(x);
                    result = new JsExprStmt(assignment);
                    this.staticInit.add(result);
                }
                assert (this.currentScopeInfo != null);
                this.currentScopeInfo = null;
                this.inFactoryOrStaticContext = false;
            } else {
                this.makePropertyGetter(element);
            }
            if (!element.getModifiers().isFinal()) {
                this.makeSetter(element);
            }
            return result;
        }

        @Override
        public JsNode visitFunction(DartFunction x) {
            Element element;
            if (x.getBody() == null && ElementKind.of(this.currentHolder).equals((Object)ElementKind.CLASS) && ((ClassElement)this.currentHolder).isInterface()) {
                return null;
            }
            this.functionStack.push(x);
            this.jsNewDeclarationsStack.push(new HashSet());
            JsFunction jsFunc = this.translationContext.getMethods().get(x);
            JsBlock body = x.getBody() == null ? new JsBlock() : (JsBlock)this.generate(x.getBody());
            jsFunc.setBody(body);
            List<DartParameter> params = x.getParams();
            List<JsParameter> jsParams = jsFunc.getParameters();
            if (!jsFunc.isHoisted()) {
                this.generateAll(params, jsParams, JsParameter.class);
            }
            ArrayList<JsExprStmt> checks = Lists.newArrayList();
            boolean omitTypeVariableChecks = false;
            if (this.inFactory && !ElementKind.of(element = (Element)x.getParent().getSymbol()).equals((Object)ElementKind.CONSTRUCTOR)) {
                omitTypeVariableChecks = true;
            }
            int numParams = params.size();
            for (int i = 0; i < numParams; ++i) {
                JsExpression expr;
                JsNameRef jsParam = jsParams.get(i).getName().makeRef();
                DartParameter param = params.get(i);
                Type paramType = param.getSymbol().getType();
                if (omitTypeVariableChecks && TypeKind.of(paramType).equals((Object)TypeKind.VARIABLE) || (expr = this.rtt.addTypeCheck(this.getCurrentClass(), jsParam, paramType, null, param)) == jsParam) continue;
                checks.add(new JsExprStmt(expr));
            }
            this.declareTempsInBlock(body, (Collection<JsName>)this.jsNewDeclarationsStack.pop());
            DartNode parent = x.getParent();
            assert (parent != null);
            if (parent instanceof DartMethodDefinition) {
                DartMethodDefinition method = (DartMethodDefinition)parent;
                if (this.isFactory(method)) {
                    this.rtt.maybeAddTypeParameterToFactory(method, jsFunc);
                }
                if (Elements.isNonFactoryConstructor((Element)parent.getSymbol())) {
                    this.addSuperOrRedirectConstructorCall(method);
                }
            }
            this.maybeAddFunctionScopeAlias(this.currentScopeInfo.getScope(x), this.translationContext.getMethods().get(x));
            this.maybeAddFunctionTracing(x);
            body.getStatements().addAll(0, checks);
            this.functionStack.pop();
            return jsFunc.setSourceRef(x);
        }

        private Type typeOf(DartTypeNode typeNode) {
            if (typeNode == null) {
                return null;
            }
            return typeNode.getType();
        }

        private boolean isFactory(DartMethodDefinition method) {
            return method.getModifiers().isFactory();
        }

        private void maybeAddFunctionTracing(DartFunction dartFunction) {
            String tracingCallTarget = System.getProperty("Trace");
            if (tracingCallTarget != null) {
                JsFunction function = this.translationContext.getMethods().get(dartFunction);
                JsPostfixOperation increment = new JsPostfixOperation(JsUnaryOperator.INC, new JsNameRef(this.getTraceCounter()));
                JsPostfixOperation decrement = new JsPostfixOperation(JsUnaryOperator.DEC, new JsNameRef(this.getTraceCounter()));
                JsInvocation tracerCall = new JsInvocation();
                tracerCall.setQualifier(new JsNameRef(tracingCallTarget));
                List<JsExpression> traceArguments = tracerCall.getArguments();
                traceArguments.add(new JsNameRef(this.getTraceCounter()));
                traceArguments.add(null);
                StringBuffer description = new StringBuffer();
                JsName name = function.getName();
                if (name != null) {
                    description.append(function.getName().toString());
                } else {
                    description.append("<anonymous-" + function.hashCode() + ">");
                }
                description.append("(");
                dartFunction.getParams();
                for (DartParameter param : dartFunction.getParams()) {
                    JsName paramName = this.getJsName(param.getSymbol());
                    description.append(paramName.toString());
                    traceArguments.add(new JsNameRef(paramName));
                }
                description.append(")");
                traceArguments.set(1, this.string(description.toString()));
                JsTry countingTry = new JsTry();
                countingTry.setTryBlock(function.getBody());
                countingTry.setFinallyBlock(AstUtil.newBlock(decrement.makeStmt()));
                JsBlock newBody = AstUtil.newBlock(increment.makeStmt(), tracerCall.makeStmt(), countingTry);
                function.setBody(newBody);
            }
        }

        @Override
        public JsNode visitParameter(DartParameter x) {
            if (x.getSymbol() != null) {
                return new JsParameter(this.getJsName(x.getSymbol())).setSourceRef(x);
            }
            return null;
        }

        @Override
        public JsNode visitBlock(DartBlock x) {
            ScopeRootInfo.DartScope scope;
            JsBlock jsBlock = new JsBlock();
            this.generateAll(x.getStatements(), jsBlock.getStatements(), JsStatement.class);
            ScopeRootInfo methodInfo = this.currentScopeInfo;
            if (methodInfo != null && (scope = methodInfo.getScope(x)).definesClosureReferencedSymbols()) {
                JsScope currentFunctionScope = this.getCurrentFunctionScope();
                JsName aliasName = scope.findAliasForJsScope(currentFunctionScope);
                assert (aliasName != null);
                this.registerForDeclaration(aliasName);
                List<JsStatement> list = jsBlock.getStatements();
                JsExprStmt init = AstUtil.newAssignment(new JsNameRef(aliasName), (JsExpression)new JsObjectLiteral()).makeStmt();
                JsExprStmt cleanup = AstUtil.newAssignment(new JsNameRef(aliasName), (JsExpression)this.undefined()).makeStmt();
                list.add(0, init);
                list.add(cleanup);
            }
            return jsBlock.setSourceRef(x);
        }

        @Override
        public JsNode visitIfStatement(DartIfStatement x) {
            JsExpression jsCondition = (JsExpression)this.generate(x.getCondition());
            jsCondition = this.rtt.addTypeCheck(this.getCurrentClass(), jsCondition, this.typeProvider.getBoolType(), x.getCondition().getType(), x);
            JsStatement jsThenStmt = (JsStatement)this.generate(x.getThenStatement());
            JsStatement jsElseStmt = null;
            if (x.getElseStatement() != null) {
                jsElseStmt = (JsStatement)this.generate(x.getElseStatement());
            }
            return new JsIf(jsCondition, jsThenStmt, jsElseStmt).setSourceRef(x);
        }

        @Override
        public JsNode visitSwitchStatement(DartSwitchStatement x) {
            JsSwitch jsSwitch = new JsSwitch();
            jsSwitch.setExpr((JsExpression)this.generate(x.getExpression()));
            this.generateAll(x.getMembers(), jsSwitch.getCases(), JsSwitchMember.class);
            return jsSwitch.setSourceRef(x);
        }

        @Override
        public JsNode visitCase(DartCase x) {
            JsCase jsCase = new JsCase();
            jsCase.setCaseExpr((JsExpression)this.generate(x.getExpr()));
            this.generateAll(x.getStatements(), jsCase.getStmts(), JsStatement.class);
            return jsCase.setSourceRef(x);
        }

        @Override
        public JsNode visitDefault(DartDefault x) {
            JsDefault jsDefault = new JsDefault();
            this.generateAll(x.getStatements(), jsDefault.getStmts(), JsStatement.class);
            return jsDefault.setSourceRef(x);
        }

        @Override
        public JsNode visitWhileStatement(DartWhileStatement x) {
            JsExpression condition = (JsExpression)this.generate(x.getCondition());
            condition = this.rtt.addTypeCheck(this.getCurrentClass(), condition, this.typeProvider.getBoolType(), x.getCondition().getType(), x);
            JsBlock body = (JsBlock)this.generate(x.getBody());
            return new JsWhile(condition, body).setSourceRef(x);
        }

        @Override
        public JsNode visitDoWhileStatement(DartDoWhileStatement x) {
            JsExpression condition = (JsExpression)this.generate(x.getCondition());
            condition = this.rtt.addTypeCheck(this.getCurrentClass(), condition, this.typeProvider.getBoolType(), x.getCondition().getType(), x);
            JsBlock body = (JsBlock)this.generate(x.getBody());
            return new JsDoWhile(condition, body).setSourceRef(x);
        }

        @Override
        public JsNode visitForStatement(DartForStatement x) {
            assert (x.getInit() == null);
            JsFor jsFor = new JsFor().setSourceRef(x);
            if (x.getCondition() != null) {
                JsExpression condExpr = (JsExpression)this.generate(x.getCondition());
                condExpr = this.rtt.addTypeCheck(this.getCurrentClass(), condExpr, this.typeProvider.getBoolType(), x.getCondition().getType(), x);
                jsFor.setCondition(condExpr);
            }
            if (x.getIncrement() != null) {
                jsFor.setIncrExpr((JsExpression)this.generate(x.getIncrement()));
            }
            jsFor.setBody((JsStatement)this.generate(x.getBody()));
            return jsFor.setSourceRef(x);
        }

        @Override
        public JsNode visitForInStatement(DartForInStatement x) {
            DartStatement normalizedNode = x.getNormalizedNode();
            if (normalizedNode == null) {
                throw new InternalCompilerException("For-in statement should have been normalized.");
            }
            return normalizedNode.accept(this);
        }

        @Override
        public JsNode visitContinueStatement(DartContinueStatement x) {
            JsContinue jsContinue = null;
            jsContinue = x.getTargetSymbol() != null ? new JsContinue(this.getJsName(x.getTargetSymbol()).makeRef()) : new JsContinue();
            return jsContinue.setSourceRef(x);
        }

        @Override
        public JsNode visitBreakStatement(DartBreakStatement x) {
            JsBreak jsBreak = null;
            jsBreak = x.getTargetSymbol() != null ? new JsBreak(this.getJsName(x.getTargetSymbol()).makeRef()) : new JsBreak();
            return jsBreak.setSourceRef(x);
        }

        @Override
        public JsNode visitReturnStatement(DartReturnStatement x) {
            JsReturn jsRet = new JsReturn();
            DartExpression returnValue = x.getValue();
            if (returnValue != null) {
                JsExpression expr = (JsExpression)this.generate(returnValue);
                DartFunction function = this.functionStack.peek();
                if (function != null) {
                    DartTypeNode returnTypeNode = function.getReturnTypeNode();
                    Type returnType = null;
                    if (returnTypeNode == null) {
                        returnType = this.getFactoryReturnType(function);
                    }
                    if (returnType == null) {
                        returnType = this.typeOf(returnTypeNode);
                    }
                    expr = this.rtt.addTypeCheck(this.getCurrentClass(), expr, returnType, returnValue.getType(), x);
                }
                jsRet.setExpr(expr);
            }
            return jsRet.setSourceRef(x);
        }

        private Type getFactoryReturnType(DartFunction function) {
            return null;
        }

        @Override
        public JsNode visitTryStatement(DartTryStatement x) {
            JsTry jsTry = new JsTry();
            jsTry.setTryBlock((JsBlock)this.generate(x.getTryBlock()));
            List<DartCatchBlock> catchBlocks = x.getCatchBlocks();
            if (catchBlocks != null && !catchBlocks.isEmpty()) {
                JsCatch jsCatch = new JsCatch(this.getCurrentFunctionScope(), "e");
                JsName exceptionVar = jsCatch.getScope().findExistingName("e");
                jsTry.getCatches().add(jsCatch);
                JsBlock jsCatchBody = new JsBlock();
                JsBinaryOperation filterBuiltin = AstUtil.newAssignment(exceptionVar.makeRef(), (JsExpression)AstUtil.newInvocation(AstUtil.newNameRef(null, "$transformBrowserException"), exceptionVar.makeRef()));
                jsCatchBody.getStatements().add(filterBuiltin.makeStmt());
                jsCatch.setBody(jsCatchBody);
                JsStatement jsElse = new JsThrow(new JsNameRef(exceptionVar));
                this.catchVarStack.push(exceptionVar);
                for (int i = catchBlocks.size() - 1; i >= 0; --i) {
                    DartCatchBlock catchBlock = catchBlocks.get(i);
                    JsBlock jsClauseBody = (JsBlock)this.generate(catchBlock.getBlock());
                    if (catchBlock.getStackTrace() != null) {
                        JsParameter jsStackParam = (JsParameter)this.generate(catchBlock.getStackTrace());
                        this.registerForDeclaration(jsStackParam.getName());
                    }
                    JsParameter jsClauseParam = (JsParameter)this.generate(catchBlock.getException());
                    JsName jsClauseParamName = jsClauseParam.getName();
                    JsBinaryOperation assignment = AstUtil.newAssignment(new JsNameRef(jsClauseParamName), (JsExpression)new JsNameRef(exceptionVar));
                    jsClauseBody.getStatements().add(0, assignment.makeStmt());
                    this.registerForDeclaration(jsClauseParamName);
                    DartParameter exception = catchBlock.getException();
                    DartTypeNode exceptionType = exception.getTypeNode();
                    if (exceptionType == null) {
                        jsElse = jsClauseBody;
                        continue;
                    }
                    JsExpression instanceCheck = this.rtt.generateInstanceOfComparison(this.getCurrentClass(), new JsNameRef(exceptionVar), exceptionType, exceptionType).setSourceRef(exception);
                    jsElse = new JsIf(instanceCheck, jsClauseBody, jsElse);
                }
                jsCatchBody.getStatements().add(jsElse);
                this.catchVarStack.pop();
            }
            if (x.getFinallyBlock() != null) {
                JsBlock jsFinallyBlock = (JsBlock)this.generate(x.getFinallyBlock());
                jsTry.setFinallyBlock(jsFinallyBlock);
            }
            JsNode result = jsTry.setSourceRef(x);
            if (x.getParent() instanceof DartLabel) {
                result = new JsBlock(jsTry).setSourceRef(x);
            }
            return result;
        }

        @Override
        public JsNode visitThrowStatement(DartThrowStatement x) {
            JsExpression exception;
            JsNameRef error = new JsNameRef("$Dart$ThrowException");
            JsInvocation invoc = AstUtil.newInvocation(error, new JsExpression[0]);
            if (x.getException() != null) {
                exception = (JsExpression)this.generate(x.getException());
            } else {
                JsName name = this.catchVarStack.peek();
                if (name != null) {
                    exception = name.makeRef();
                } else {
                    throw new InternalCompilerException("invalid rethrow context");
                }
            }
            invoc.getArguments().add(exception);
            return new JsExprStmt(invoc.setSourceRef(x));
        }

        @Override
        public JsNode visitVariableStatement(DartVariableStatement x) {
            assert (x.getVariables().size() == 1);
            JsNode node = this.generate(x.getVariables().get(0));
            if (node instanceof JsVars.JsVar) {
                JsVars jsVars = new JsVars();
                jsVars.insert((JsVars.JsVar)node);
                return jsVars.setSourceRef(x);
            }
            assert (node instanceof JsStatement);
            return node;
        }

        @Override
        public JsNode visitVariable(DartVariable x) {
            Element targetSymbol = x.getSymbol();
            JsNameRef scopeAliasRef = this.maybeMakeScopeAliasReference(targetSymbol);
            JsNode result = null;
            DartExpression value = x.getValue();
            if (scopeAliasRef != null) {
                if (value != null) {
                    JsExpression initExpr = (JsExpression)this.generate(value);
                    Type type = this.getTypeOfIdentifier((DartIdentifier)x.getName());
                    initExpr = this.rtt.addTypeCheck(this.getCurrentClass(), initExpr, type, value.getType(), x);
                    result = AstUtil.newAssignment(scopeAliasRef, initExpr).setSourceRef(x).makeStmt();
                } else {
                    result = this.translationContext.getProgram().getEmptyStmt();
                }
            } else {
                JsVars.JsVar jsVar = new JsVars.JsVar(this.getJsName(targetSymbol));
                if (value != null) {
                    JsExpression initExpr = (JsExpression)this.generate(value);
                    Type type = this.getTypeOfIdentifier((DartIdentifier)x.getName());
                    initExpr = this.rtt.addTypeCheck(this.getCurrentClass(), initExpr, type, value.getType(), x);
                    jsVar.setInitExpr(initExpr);
                } else {
                    jsVar.setInitExpr(this.undefined());
                }
                result = jsVar.setSourceRef(x);
            }
            return result;
        }

        @Override
        public JsNode visitEmptyStatement(DartEmptyStatement x) {
            x.visitChildren(this);
            return this.translationContext.getProgram().getEmptyStmt();
        }

        @Override
        public JsNode visitSyntheticErrorExpression(DartSyntheticErrorExpression node) {
            String name = node.getSource().getName();
            int line = node.getSourceLine();
            int col = node.getSourceColumn();
            throw new AssertionError((Object)("Generating JS with parse error at " + name + ":" + line + ":" + col));
        }

        @Override
        public JsNode visitSyntheticErrorStatement(DartSyntheticErrorStatement node) {
            String name = node.getSource().getName();
            int line = node.getSourceLine();
            int col = node.getSourceColumn();
            throw new AssertionError((Object)("Generating JS with parse error at " + name + ":" + line + ":" + col));
        }

        @Override
        public JsNode visitLabel(DartLabel x) {
            JsStatement jsStmt = (JsStatement)this.generate(x.getStatement());
            JsLabel jsLabel = new JsLabel(this.getJsName(x.getSymbol()));
            jsLabel.setStmt(jsStmt);
            return jsLabel.setSourceRef(x);
        }

        @Override
        public JsNode visitExprStmt(DartExprStmt x) {
            JsNode node = this.generate(x.getExpression());
            if (node instanceof JsVars) {
                return node;
            }
            JsExpression expr = (JsExpression)node;
            return new JsExprStmt(expr).setSourceRef(x);
        }

        @Override
        public JsNode visitConditional(DartConditional x) {
            JsExpression testExpr = (JsExpression)this.generate(x.getCondition());
            testExpr = this.rtt.addTypeCheck(this.getCurrentClass(), testExpr, this.typeProvider.getBoolType(), x.getCondition().getType(), x);
            JsExpression thenExpr = (JsExpression)this.generate(x.getThenExpression());
            JsExpression elseExpr = (JsExpression)this.generate(x.getElseExpression());
            return new JsConditional(testExpr, thenExpr, elseExpr).setSourceRef(x);
        }

        @Override
        public JsNode visitBinaryExpression(DartBinaryExpression x) {
            boolean skipShim;
            assert (x == x.getNormalizedNode());
            Token operator = x.getOperator();
            if (operator == Token.IS) {
                return this.generateInstanceOfComparison(x);
            }
            DartExpression arg1 = x.getArg1();
            DartExpression arg2 = x.getArg2();
            JsExpression rhs = (JsExpression)this.generate(arg2);
            if (operator == Token.ASSIGN) {
                return arg1.accept(new Assignment(x, rhs, arg2.getType()));
            }
            assert (!operator.isUserDefinableOperator() || !operator.isAssignmentOperator()) : x;
            boolean bl = skipShim = !operator.isUserDefinableOperator() && operator != Token.NE;
            if (!skipShim) {
                skipShim = this.optStrategy.canSkipOperatorShim(x);
            }
            JsExpression lhs = (JsExpression)this.generate(arg1);
            Token op = x.getOperator();
            lhs = this.rtt.addTypeCheck(this.getCurrentClass(), lhs, this.getRequiredType(op), arg1.getType(), arg1);
            rhs = this.rtt.addTypeCheck(this.getCurrentClass(), rhs, this.getRequiredType(op), arg2.getType(), arg2);
            if (skipShim) {
                if (op.isEqualityOperator()) {
                    op = this.mapToStrictEquals(op);
                    if (arg2 instanceof DartNullLiteral) {
                        op = this.mapToNonStrictEquals(op);
                        rhs = this.nulle();
                    }
                    if (arg1 instanceof DartNullLiteral) {
                        JsExpression tmp = lhs;
                        lhs = rhs;
                        rhs = tmp;
                        op = this.mapToNonStrictEquals(op);
                        rhs = this.nulle();
                    }
                }
                JsBinaryOperation binOp = new JsBinaryOperation(this.mapBinaryOp(op), lhs, rhs);
                binOp.setSourceRef(x);
                return binOp;
            }
            JsNameRef ref = new JsNameRef(this.mangler.createOperatorSyntax(operator));
            return AstUtil.newInvocation(ref, lhs, rhs).setSourceRef(x);
        }

        private Type getRequiredType(Token op) {
            switch (op) {
                case OR: 
                case AND: {
                    return this.typeProvider.getBoolType();
                }
            }
            return null;
        }

        private Type getTypeOfIdentifier(DartIdentifier ident) {
            Element element = ident.getReferencedElement();
            DartTypeNode typeNode = null;
            if (element == null) {
                DartNode parent = ident.getParent();
                if (parent instanceof DartVariable) {
                    DartVariableStatement varStmt = (DartVariableStatement)parent.getParent();
                    typeNode = varStmt.getTypeNode();
                }
            } else {
                switch (element.getKind()) {
                    case VARIABLE: {
                        DartVariableStatement varStmt = (DartVariableStatement)element.getNode().getParent();
                        typeNode = varStmt.getTypeNode();
                        break;
                    }
                    case PARAMETER: {
                        DartParameter param = (DartParameter)element.getNode();
                        typeNode = param.getTypeNode();
                        break;
                    }
                    case FIELD: {
                        DartFieldDefinition fieldDef = (DartFieldDefinition)element.getNode().getParent();
                        typeNode = fieldDef.getTypeNode();
                        break;
                    }
                }
            }
            if (typeNode != null) {
                return typeNode.getType();
            }
            return null;
        }

        private JsExpression generateInstanceOfComparison(DartBinaryExpression x) {
            JsExpression lhs = (JsExpression)this.generate(x.getArg1());
            DartExpression rhs = x.getArg2();
            boolean isNot = false;
            if (rhs instanceof DartUnaryExpression) {
                isNot = true;
                rhs = ((DartUnaryExpression)rhs).getArg();
            }
            JsExpression expr = this.rtt.generateInstanceOfComparison(this.getCurrentClass(), lhs, ((DartTypeExpression)rhs).getTypeNode(), rhs).setSourceRef(x);
            if (isNot) {
                expr = new JsPrefixOperation(JsUnaryOperator.NOT, expr);
            }
            return expr;
        }

        private JsBinaryOperation assign(JsNameRef op1, JsExpression op2) {
            return AstUtil.newAssignment(op1, op2);
        }

        private JsBinaryOperation neq(JsExpression op1, JsExpression op2) {
            return new JsBinaryOperation(JsBinaryOperator.NEQ, op1, op2);
        }

        private JsBinaryOperation or(JsExpression op1, JsExpression op2) {
            return new JsBinaryOperation(JsBinaryOperator.OR, op1, op2);
        }

        private JsNumberLiteral number(double num) {
            return this.translationContext.getProgram().getNumberLiteral(num);
        }

        private JsStringLiteral string(String str) {
            return this.translationContext.getProgram().getStringLiteral(str);
        }

        private JsNullLiteral nulle() {
            return this.translationContext.getProgram().getNullLiteral();
        }

        private JsNameRef undefined() {
            return this.translationContext.getProgram().getUndefinedLiteral();
        }

        private JsEmpty empty() {
            return this.translationContext.getProgram().getEmptyStmt();
        }

        @Override
        public JsNode visitTypeNode(DartTypeNode x) {
            return null;
        }

        @Override
        public JsNode visitTypeParameter(DartTypeParameter x) {
            return null;
        }

        @Override
        public JsNode visitTypeExpression(DartTypeExpression x) {
            throw new AssertionError((Object)"Unreachable");
        }

        @Override
        public JsNode visitUnaryExpression(DartUnaryExpression x) {
            JsUnaryOperator jsUnaryOperator;
            assert (x == x.getNormalizedNode());
            Token operator = x.getOperator();
            JsExpression arg = (JsExpression)this.generate(x.getArg());
            boolean canSkipUnaryOpShim = this.optStrategy.canSkipOperatorShim(x);
            if (operator == Token.SUB) {
                if (canSkipUnaryOpShim) {
                    JsPrefixOperation unaryMinus = new JsPrefixOperation(JsUnaryOperator.NEG, arg);
                    unaryMinus.setSourceRef(x);
                    return unaryMinus;
                }
                JsNameRef ref = new JsNameRef(this.mangler.createOperatorSyntax("negate"));
                JsInvocation result = AstUtil.newInvocation(ref, arg);
                return ((JsNode)result).setSourceRef(x);
            }
            if (operator.isUserDefinableOperator()) {
                if (canSkipUnaryOpShim) {
                    JsPrefixOperation expr = new JsPrefixOperation(this.mapUnaryOp(operator), arg);
                    expr.setSourceRef(x);
                    return expr;
                }
                JsNameRef ref = new JsNameRef(this.mangler.createOperatorSyntax(operator));
                JsInvocation result = AstUtil.newInvocation(ref, arg);
                return ((JsNode)result).setSourceRef(x);
            }
            switch (operator) {
                case INC: {
                    jsUnaryOperator = JsUnaryOperator.INC;
                    break;
                }
                case DEC: {
                    jsUnaryOperator = JsUnaryOperator.DEC;
                    break;
                }
                case NOT: {
                    jsUnaryOperator = JsUnaryOperator.NOT;
                    arg = this.rtt.addTypeCheck(this.getCurrentClass(), arg, this.typeProvider.getBoolType(), x.getArg().getType(), x.getArg());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected unary operator " + operator.name()));
                }
            }
            JsUnaryOperation result = x.isPrefix() ? new JsPrefixOperation(jsUnaryOperator, arg) : new JsPostfixOperation(jsUnaryOperator, arg);
            return ((JsNode)result).setSourceRef(x);
        }

        @Override
        public JsNode visitPropertyAccess(DartPropertyAccess x) {
            FieldElement element = this.optStrategy.findOptimizableFieldElementFor(x, TypeHeuristic.FieldKind.GETTER);
            return this.generateLoad(x.getQualifier(), x.getName(), element).setSourceRef(x);
        }

        @Override
        public JsNode visitArrayAccess(DartArrayAccess x) {
            JsExpression target = (JsExpression)this.generate(x.getTarget());
            JsExpression key = (JsExpression)this.generate(x.getKey());
            if (this.optStrategy.canSkipArrayAccessShim(x, false)) {
                return AstUtil.newArrayAccess(target, this.inlineArrayIndexCheck(target, key));
            }
            JsNameRef ref = AstUtil.newNameRef(target, this.mangler.createOperatorSyntax(Token.INDEX));
            JsInvocation invoke = AstUtil.newInvocation(ref, key);
            return invoke.setSourceRef(x);
        }

        @Override
        public JsNode visitUnqualifiedInvocation(DartUnqualifiedInvocation x) {
            JsExpression qualifier;
            String mangledName;
            DartIdentifier target = x.getTarget();
            Element element = target.getTargetSymbol();
            ElementKind kind = ElementKind.of(element);
            MethodElement method = null;
            switch (kind) {
                case FUNCTION_OBJECT: {
                    mangledName = null;
                    qualifier = (JsExpression)this.generate(target);
                    EnclosingElement enclosingElement = element.getEnclosingElement();
                    if (enclosingElement == null || enclosingElement.getKind() != ElementKind.CLASS) break;
                    method = (MethodElement)element;
                    break;
                }
                case FIELD: 
                case VARIABLE: 
                case PARAMETER: {
                    mangledName = null;
                    qualifier = (JsExpression)this.generate(target);
                    break;
                }
                case NONE: {
                    mangledName = this.mangler.mangleMethod(x.getTarget().getTargetName(), this.unitLibrary);
                    qualifier = new JsThisRef();
                    break;
                }
                case METHOD: {
                    method = (MethodElement)element;
                    mangledName = this.mangler.mangleMethod(method, this.unitLibrary);
                    if (element.getModifiers().isStatic()) {
                        qualifier = this.referenceName(element.getEnclosingElement(), x.getTarget());
                        break;
                    }
                    if (Elements.isTopLevel(element)) {
                        qualifier = null;
                        break;
                    }
                    qualifier = new JsThisRef();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Cannot be an unqualified invocation " + (Object)((Object)kind)));
                }
            }
            return this.generateInvocation(x, qualifier, false, mangledName, method);
        }

        @Override
        public JsNode visitFunctionObjectInvocation(DartFunctionObjectInvocation x) {
            DartFunctionExpression functionExpression;
            DartExpression target = x.getTarget();
            if (target instanceof DartFunctionExpression && (functionExpression = (DartFunctionExpression)target).getSymbol().getModifiers().isInlinable() && !this.shouldGenerateDeveloperModeChecks()) {
                return new FunctionExpressionInliner(functionExpression, x.getArgs()).call();
            }
            JsExpression qualifier = (JsExpression)this.generate(target);
            return this.generateInvocation(x, qualifier, false, null, null);
        }

        @Override
        public JsNode visitMethodInvocation(DartMethodInvocation x) {
            Object qualifier;
            String mangledName;
            Element element = this.optStrategy.findElementFor(x);
            MethodElement method = null;
            if (element == null) {
                mangledName = this.mangler.mangleNamedMethod(x.getFunctionNameString(), this.unitLibrary);
                qualifier = (JsExpression)this.generate(x.getTarget());
            } else {
                switch (element.getKind()) {
                    case METHOD: {
                        mangledName = this.mangler.mangleMethod((MethodElement)element, this.unitLibrary);
                        qualifier = element.getModifiers().isStatic() ? this.referenceName(element.getEnclosingElement(), x.getTarget()) : (Elements.isTopLevel(element) ? null : (JsExpression)this.generate(x.getTarget()));
                        method = (MethodElement)element;
                        break;
                    }
                    case FIELD: {
                        if (ElementKind.of(x.getTarget().getSymbol()) == ElementKind.LIBRARY) {
                            mangledName = null;
                            qualifier = (JsExpression)this.generate(x.getFunctionName());
                            break;
                        }
                        mangledName = this.mangler.mangleNamedMethod(x.getFunctionNameString(), this.unitLibrary);
                        qualifier = (JsExpression)this.generate(x.getTarget());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unexpected invocation target.");
                    }
                }
            }
            boolean isSuperCall = GenerateJavascriptVisitor.isSuperCall(x.getTarget().getSymbol());
            return this.generateInvocation(x, (JsExpression)qualifier, isSuperCall, mangledName, method);
        }

        private JsExpression generateConstructorInvocation(DartNewExpression x, JsExpression qualifier, MethodElement method) {
            JsInvocation invoke = (JsInvocation)this.generateInvocation(x, qualifier, false, null, method);
            this.rtt.mayAddRuntimeTypeToConstrutorOrFactoryCall(this.getCurrentClass(), x, invoke);
            return invoke;
        }

        private JsExpression generateInvocation(DartInvocation x, JsExpression qualifier, boolean isSuperCall, String mangledName, MethodElement method) {
            JsInvocation jsInvoke = new JsInvocation();
            if (method != null) {
                if (!this.generateDirectCallArgs(x, method, jsInvoke)) {
                    return AstUtil.newInvocation(new JsNameRef("$nsme"), new JsExpression[0]);
                }
            } else {
                this.generateNamedCallArgs(x, jsInvoke);
            }
            JsThisRef explicitReceiver = null;
            int argsLength = jsInvoke.getArguments().size();
            qualifier = this.referenceMethodMember(qualifier, mangledName);
            if (isSuperCall) {
                qualifier = AstUtil.newNameRef(qualifier, "call");
            }
            if (isSuperCall) {
                assert (explicitReceiver == null);
                explicitReceiver = new JsThisRef();
            }
            if (explicitReceiver != null) {
                jsInvoke.getArguments().add(0, explicitReceiver);
            }
            jsInvoke.setQualifier(qualifier);
            return jsInvoke.setSourceRef(x);
        }

        private boolean generateDirectCallArgs(DartInvocation x, MethodElement target, JsInvocation jsInvoke) {
            List<DartExpression> args = x.getArgs();
            List<JsExpression> jsArgs = jsInvoke.getArguments();
            ArrayList<DartExpression> posArgs = new ArrayList<DartExpression>();
            HashMap<String, DartExpression> namedArgs = new HashMap<String, DartExpression>();
            for (DartExpression arg : args) {
                if (arg instanceof DartNamedExpression) {
                    DartNamedExpression named = (DartNamedExpression)arg;
                    namedArgs.put(named.getName().getTargetName(), named.getExpression());
                    continue;
                }
                posArgs.add(arg);
            }
            int idx = 0;
            int posUsed = 0;
            for (VariableElement param : target.getParameters()) {
                String name = param.getName();
                if (name != null) {
                    DartExpression namedArg = (DartExpression)namedArgs.get(param.getName());
                    if (namedArg != null) {
                        if (!param.getModifiers().isNamed()) {
                            return false;
                        }
                        jsArgs.add((JsExpression)this.generate(namedArg));
                    } else if (idx < posArgs.size()) {
                        ++posUsed;
                        jsArgs.add((JsExpression)this.generate((DartNode)posArgs.get(idx)));
                    } else if (param.getDefaultValue() != null) {
                        assert (param.isNamed());
                        jsArgs.add(this.generateDefaultValue(param.getDefaultValue()));
                    } else if (param.isNamed()) {
                        jsArgs.add(this.undefined());
                    } else {
                        return false;
                    }
                }
                ++idx;
            }
            return posUsed == posArgs.size();
        }

        private JsExpression generateDefaultValue(DartExpression defaultValue) {
            if (defaultValue != null && defaultValue instanceof DartFunctionExpression) {
                return this.nulle();
            }
            return (JsExpression)this.generate(defaultValue);
        }

        private void generateNamedCallArgs(DartInvocation invoke, JsInvocation jsInvoke) {
            JsExpression argmap;
            List<DartExpression> args = invoke.getArgs();
            List<JsExpression> jsArgs = jsInvoke.getArguments();
            int namedCount = 0;
            for (DartExpression arg : args) {
                if (!(arg instanceof DartNamedExpression)) continue;
                ++namedCount;
            }
            if (namedCount == 0) {
                argmap = new JsNameRef("$noargs");
            } else {
                JsObjectLiteral bag = new JsObjectLiteral();
                for (DartExpression arg : args) {
                    if (!(arg instanceof DartNamedExpression)) continue;
                    DartNamedExpression namedExpr = (DartNamedExpression)arg;
                    JsStringLiteral targetName = this.string(this.getPropNameForNamedParameter(namedExpr));
                    JsPropertyInitializer propInit = new JsPropertyInitializer(targetName, (JsExpression)this.generate(namedExpr.getExpression()));
                    bag.getPropertyInitializers().add(propInit);
                }
                JsPropertyInitializer countProp = new JsPropertyInitializer(this.string("count"), this.number(namedCount));
                bag.getPropertyInitializers().add(countProp);
                argmap = bag;
            }
            jsArgs.add(this.number(args.size() - namedCount));
            jsArgs.add(argmap);
            for (DartExpression arg : args) {
                if (arg instanceof DartNamedExpression) continue;
                jsArgs.add((JsExpression)this.generate(arg));
            }
        }

        private JsExpression referenceMethodMember(JsExpression qualifier, String mangledName) {
            if (mangledName != null) {
                qualifier = AstUtil.newNameRef(qualifier, mangledName);
            }
            return qualifier;
        }

        @Override
        public JsNode visitThisExpression(DartThisExpression x) {
            return new JsThisRef().setSourceRef(x);
        }

        @Override
        public JsNode visitSuperExpression(DartSuperExpression x) {
            ClassElement element = x.getSymbol().getClassElement();
            JsNameRef superRef = AstUtil.newPrototypeNameRef(this.getJsName(element).makeRef());
            return superRef.setSourceRef(x);
        }

        @Override
        public JsNode visitSuperConstructorInvocation(DartSuperConstructorInvocation x) {
            return this.generateSuperConstructorInvocation(x);
        }

        @Override
        public JsNode visitNativeBlock(DartNativeBlock x) {
            JsInvocation nativeCall;
            JsBlock jsBlock = new JsBlock();
            DartMethodDefinition method = (DartMethodDefinition)this.currentScopeInfo.getContainingClassMember();
            String name = this.mangler.mangleNativeMethod(method.getSymbol());
            JsNameRef nativeRef = new JsNameRef(name);
            if (method.getModifiers().isStatic()) {
                nativeCall = AstUtil.newInvocation(nativeRef, new JsExpression[0]);
            } else {
                JsNameRef callRef = AstUtil.newNameRef((JsExpression)nativeRef, "call");
                nativeCall = AstUtil.newInvocation(callRef, new JsThisRef());
            }
            for (DartParameter p : method.getFunction().getParams()) {
                nativeCall.getArguments().add(this.getJsName(p.getSymbol()).makeRef());
            }
            jsBlock.getStatements().add(new JsReturn(nativeCall));
            return jsBlock.setSourceRef(x);
        }

        @Override
        public JsNode visitNewExpression(DartNewExpression x) {
            JsExpression newExpr;
            ConstructorElement element = x.getSymbol();
            if (element != null && element.getConstructorType() != null) {
                String className = element.getConstructorType().getName();
                String name = this.mangler.createFactorySyntax(className, element.getName(), this.unitLibrary);
                JsName classJsName = this.getJsName(element.getEnclosingElement());
                JsNameRef consName = AstUtil.newNameRef((JsExpression)classJsName.makeRef(), name);
                newExpr = this.generateConstructorInvocation(x, consName, element);
                if (x.isConst()) {
                    newExpr = this.maybeInternConst(newExpr, Types.constructorType(x).getArguments());
                }
            } else {
                JsInvocation jsInvocation = AstUtil.newInvocation(new JsNameRef("$nsme2"), new JsExpression[0]);
                JsStringLiteral ctorName = this.translationContext.getProgram().getStringLiteral(x.getConstructor().toSource());
                JsArrayLiteral jsArgsArray = new JsArrayLiteral();
                List<JsExpression> expressions = jsArgsArray.getExpressions();
                List<DartExpression> dartArgs = x.getArgs();
                for (DartExpression arg : dartArgs) {
                    expressions.add((JsExpression)this.generate(arg));
                }
                List<JsExpression> jsInvocationArguments = jsInvocation.getArguments();
                jsInvocationArguments.add(ctorName);
                jsInvocationArguments.add(jsArgsArray);
                newExpr = jsInvocation;
            }
            return newExpr;
        }

        private JsExpression maybeInternConst(JsExpression newExpr, List<? extends Type> typeParams) {
            JsInvocation intern = AstUtil.newInvocation(new JsNameRef("$intern"), newExpr);
            if (typeParams != null && typeParams.size() != 0) {
                JsArrayLiteral arr = new JsArrayLiteral();
                for (Type type : typeParams) {
                    JsExpression typeName = type.getKind() != TypeKind.DYNAMIC ? this.rtt.getRTTClassId((ClassElement)type.getElement()) : this.string("");
                    arr.getExpressions().add(typeName);
                }
                intern.getArguments().add(arr);
            }
            return intern;
        }

        private boolean shouldBindThis(ScopeRootInfo.ClosureInfo info) {
            if (this.shouldGenerateDeveloperModeChecks()) {
                return true;
            }
            return !this.inFactoryOrStaticContext && info.referencesThis;
        }

        private boolean shouldGenerateDeveloperModeChecks() {
            return this.context.getCompilerConfiguration().developerModeChecks();
        }

        @Override
        public JsNode visitFunctionExpression(DartFunctionExpression x) {
            ScopeRootInfo scopeInfo;
            ScopeRootInfo.DartScope scope;
            JsExpression replacement;
            JsName hoistedName;
            JsName fnDeclaredName;
            JsFunction fn = (JsFunction)this.generate(x.getFunction());
            String hoistedRttName = null;
            boolean fnWasPreviouslyHoisted = fn.isHoisted();
            if (fnWasPreviouslyHoisted) {
                fnDeclaredName = fn.getName();
                hoistedName = fn.getName();
                hoistedRttName = this.mangler.mangleRttLookupMethod(hoistedName.toString(), this.unitLibrary);
            } else {
                fnDeclaredName = fn.getName();
                hoistedName = this.makeClosureHoistedJsName(this.currentHolder, this.currentScopeInfo, x);
                fn.setName(hoistedName);
                fn.rebaseScope(this.globalScope);
                this.globalBlock.getStatements().add(fn.makeStmt());
                fn.setHoisted();
            }
            ScopeRootInfo.ClosureInfo info = this.currentScopeInfo.getClosureInfo(x.getFunction());
            List<ScopeRootInfo.DartScope> list = info.getSortedReferencedScopeList();
            if (!fnWasPreviouslyHoisted) {
                boolean includesClosureScope = !list.isEmpty();
                boolean preserveThis = this.shouldBindThis(info);
                JsFunction tramp = this.generateNamedParameterTrampoline(x.getFunction(), hoistedName.makeRef(), list.size(), preserveThis);
                String mangled = this.mangler.mangleNamedMethod(hoistedName.getIdent(), this.unitLibrary);
                hoistedName = this.globalScope.declareName(mangled);
                tramp.setName(hoistedName);
                this.globalBlock.getStatements().add(tramp.makeStmt());
                if (x.getParent() != null && !(x.getParent() instanceof DartFunctionObjectInvocation)) {
                    hoistedRttName = this.mangler.mangleRttLookupMethod(hoistedName.toString(), this.unitLibrary);
                    this.rtt.generateRuntimeTypeInfo(x, hoistedRttName);
                }
            } else {
                String mangled = this.mangler.mangleNamedMethod(hoistedName.getIdent(), this.unitLibrary);
                hoistedName = this.globalScope.declareName(mangled);
                hoistedRttName = this.mangler.mangleRttLookupMethod(hoistedName.toString(), this.unitLibrary);
            }
            if (x.getParent() == null || x.getParent() instanceof DartFunctionObjectInvocation) {
                hoistedRttName = null;
            }
            if (list.isEmpty() && this.inFactoryOrStaticContext) {
                replacement = AstUtil.newInvocation(new JsNameRef("$bind"), new JsNameRef(hoistedName), hoistedRttName != null ? new JsNameRef(hoistedRttName) : this.nulle(), this.undefined());
            } else {
                JsExpression thisRef = this.undefined();
                if (this.shouldBindThis(info)) {
                    thisRef = new JsThisRef();
                }
                int scopeCount = list.size();
                int argCount = fn.getParameters().size() + 2;
                String jsBindName = "$bind";
                if (this.optStrategy.canOptimizeFunctionExpressionBind(x) && scopeCount <= 3 && argCount <= 5) {
                    jsBindName = "$bind" + scopeCount + "_" + argCount;
                }
                JsInvocation invoke = AstUtil.newInvocation(new JsNameRef(jsBindName), new JsNameRef(hoistedName), hoistedRttName != null ? new JsNameRef(hoistedRttName) : this.nulle(), thisRef);
                int parameterIndex = 0;
                for (ScopeRootInfo.DartScope s : list) {
                    JsName aliasJsName = s.getAliasForJsScope(this.getCurrentFunctionScope());
                    invoke.getArguments().add(new JsNameRef(aliasJsName));
                    JsName jsName = s.findAliasForJsScope(fn.getScope());
                    assert (jsName != null);
                    if (!fnWasPreviouslyHoisted) {
                        fn.getParameters().add(parameterIndex, new JsParameter(jsName));
                    }
                    ++parameterIndex;
                }
                replacement = invoke;
            }
            if (!x.isStatement() && x.getName() != null && (scope = (scopeInfo = this.currentScopeInfo).getScope(x)).definesClosureReferencedSymbols()) {
                JsScope currentFunctionScope = this.getCurrentFunctionScope();
                JsName aliasName = scope.findAliasForJsScope(currentFunctionScope);
                assert (aliasName != null);
                this.registerForDeclaration(aliasName);
                JsBinaryOperation init = AstUtil.newAssignment(new JsNameRef(aliasName), (JsExpression)new JsObjectLiteral());
                JsNameRef scopeF = this.makeScopeAliasNameRef(scope, x.getSymbol());
                JsBinaryOperation assig = AstUtil.newAssignment(scopeF, replacement);
                replacement = new JsBinaryOperation(JsBinaryOperator.COMMA, init, assig);
            }
            if (x.isStatement()) {
                JsNameRef scopeAliasRef = this.maybeMakeScopeAliasReference(x.getSymbol());
                if (scopeAliasRef != null) {
                    JsBinaryOperation assig = AstUtil.newAssignment(scopeAliasRef, replacement);
                    return assig.setSourceRef(x);
                }
                assert (!hoistedName.equals(fnDeclaredName));
                JsVars vars = AstUtil.newVar(x.getName(), fnDeclaredName, replacement);
                return vars.setSourceRef(x);
            }
            return replacement.setSourceRef(x);
        }

        private JsName makeClosureHoistedJsName(Element holder, ScopeRootInfo info, DartFunctionExpression x) {
            Element element = info.getContainingElement();
            String closureIdentifier = info.getNextClosureName();
            String closureName = x.getFunctionName();
            String hoistedName = this.mangler.createHoistedFunctionName(holder, element, closureIdentifier, closureName);
            return this.globalScope.declareName(hoistedName, hoistedName, closureName);
        }

        @Override
        public JsNode visitIdentifier(DartIdentifier x) {
            DartExpression normalizedNode = x.getNormalizedNode();
            if (normalizedNode != x) {
                return normalizedNode.accept(this);
            }
            FieldElement element = this.optStrategy.findOptimizableFieldElementFor(x, TypeHeuristic.FieldKind.GETTER);
            return this.generateLoad(null, x, element).setSourceRef(x);
        }

        private JsNameRef maybeMakeScopeAliasReference(Symbol targetSymbol) {
            ScopeRootInfo.DartScope.DartSymbolInfo symbolInfo;
            ScopeRootInfo methodInfo;
            if (!this.functionStack.isEmpty() && (methodInfo = this.currentScopeInfo) != null && (symbolInfo = methodInfo.getSymbolInfo(targetSymbol)) != null && symbolInfo.isReferencedFromClosure()) {
                return this.makeScopeAliasNameRef(symbolInfo.getOwningScope(), targetSymbol);
            }
            return null;
        }

        private JsNameRef makeScopeAliasNameRef(ScopeRootInfo.DartScope scope, Symbol targetSymbol) {
            JsName qualifier = scope.getAliasForJsScope(this.getCurrentFunctionScope());
            return AstUtil.newNameRef((JsExpression)new JsNameRef(qualifier), this.getJsName(targetSymbol).getIdent());
        }

        @Override
        public JsNode visitNullLiteral(DartNullLiteral x) {
            return this.undefined();
        }

        @Override
        public JsNode visitStringLiteral(DartStringLiteral x) {
            return this.string(x.getValue()).setSourceRef(x);
        }

        @Override
        public JsNode visitStringInterpolation(DartStringInterpolation x) {
            List<DartStringLiteral> strings = x.getStrings();
            List<DartExpression> expressions = x.getExpressions();
            JsExpression res = null;
            Iterator<DartExpression> eIter = expressions.iterator();
            boolean first = true;
            for (DartStringLiteral lit : strings) {
                if (first) {
                    first = false;
                    res = (JsExpression)this.generate(lit);
                    continue;
                }
                assert (eIter.hasNext()) : "DartStringInterpolation invariant broken.";
                JsExpression expr = (JsExpression)this.generate(eIter.next());
                JsInvocation exprToString = new JsInvocation();
                exprToString.setQualifier(new JsNameRef("$toString"));
                exprToString.getArguments().add(expr);
                res = new JsBinaryOperation(JsBinaryOperator.ADD, new JsBinaryOperation(JsBinaryOperator.ADD, res, exprToString), (JsExpression)this.generate(lit)).setSourceRef(x);
            }
            assert (res != null);
            return res;
        }

        @Override
        public JsNode visitBooleanLiteral(DartBooleanLiteral x) {
            return x.getValue() ? this.translationContext.getProgram().getTrueLiteral() : this.translationContext.getProgram().getFalseLiteral();
        }

        @Override
        public JsNode visitIntegerLiteral(DartIntegerLiteral x) {
            return this.number(x.getValue().doubleValue());
        }

        @Override
        public JsNode visitDoubleLiteral(DartDoubleLiteral x) {
            return this.number(x.getValue());
        }

        @Override
        public JsNode visitArrayLiteral(DartArrayLiteral x) {
            JsArrayLiteral jsArray = new JsArrayLiteral();
            this.generateAll(x.getExpressions(), jsArray.getExpressions(), JsExpression.class);
            jsArray.setSourceRef(x);
            JsExpression result = this.rtt.maybeAddRuntimeTypeForArrayLiteral(this.getCurrentClass(), x, jsArray);
            if (x.isConst()) {
                result = this.maybeInternConst(result, x.getType().getArguments());
            }
            return result;
        }

        @Override
        public JsNode visitMapLiteral(DartMapLiteral x) {
            JsBinaryOperation assig;
            JsName tmpVar = this.createTemporary();
            String name = "LinkedHashMapImplementation";
            String mangledMap = this.mangler.mangleClassNameHack(null, name);
            String mangledFactory = this.mangler.createFactorySyntax(name, "", this.unitLibrary);
            JsNameRef runtimeMap = AstUtil.newNameRef((JsExpression)new JsNameRef(mangledMap), mangledFactory);
            JsInvocation invoke = AstUtil.newInvocation(runtimeMap, new JsExpression[0]);
            this.rtt.maybeAddRuntimeTypeToMapLiteralConstructor(this.getCurrentClass(), x, invoke);
            JsExpression result = assig = AstUtil.newAssignment(tmpVar.makeRef(), invoke.setSourceRef(x));
            for (DartMapLiteralEntry entry : x.getEntries()) {
                result = AstUtil.newSequence(result, this.visitMapLiteralEntry(entry, tmpVar));
            }
            result = AstUtil.newSequence(result, tmpVar.makeRef());
            if (x.isConst()) {
                result = this.maybeInternConst(result, x.getType().getArguments());
            }
            return result;
        }

        private JsExpression visitMapLiteralEntry(DartMapLiteralEntry x, JsName map) {
            String addMethod = this.mangler.createOperatorSyntax(Token.ASSIGN_INDEX);
            JsExpression value = (JsExpression)this.generate(x.getValue());
            JsExpression key = (JsExpression)this.generate(x.getKey());
            JsNameRef methodName = AstUtil.newNameRef((JsExpression)map.makeRef(), addMethod);
            return AstUtil.newInvocation(methodName, key, value).setSourceRef(x);
        }

        @Override
        public JsNode visitMapLiteralEntry(DartMapLiteralEntry x) {
            throw new InternalCompilerException("MapLiteralEntries are handled by the 2-arg variant.");
        }

        @Override
        public JsNode visitNamedExpression(DartNamedExpression node) {
            return this.generate(node.getExpression());
        }

        @Override
        public JsNode visitRedirectConstructorInvocation(DartRedirectConstructorInvocation x) {
            return this.generateSuperConstructorInvocation(x);
        }

        private JsNode generateSuperConstructorInvocation(DartInvocation x) {
            String elementName;
            EnclosingElement classElement;
            ConstructorElement element = (ConstructorElement)x.getSymbol();
            if (element == null) {
                classElement = ((ClassElement)this.currentHolder).getSupertype().getElement();
                elementName = classElement.getName();
            } else {
                classElement = element.getEnclosingElement();
                elementName = element.getName();
            }
            if (classElement.equals(this.typeProvider.getObjectType().getElement())) {
                return null;
            }
            String name = this.mangler.mangleConstructor(elementName, this.unitLibrary);
            JsNameRef constructorRef = AstUtil.newNameRef((JsExpression)this.getJsName(classElement).makeRef(), name);
            return this.generateInvocation(x, constructorRef, true, null, element);
        }

        private JsBinaryOperator mapBinaryOp(Token operator) {
            switch (operator) {
                case ASSIGN: {
                    return JsBinaryOperator.ASG;
                }
                case ASSIGN_BIT_OR: {
                    return JsBinaryOperator.ASG_BIT_OR;
                }
                case ASSIGN_BIT_XOR: {
                    return JsBinaryOperator.ASG_BIT_XOR;
                }
                case ASSIGN_BIT_AND: {
                    return JsBinaryOperator.ASG_BIT_AND;
                }
                case ASSIGN_SHL: {
                    return JsBinaryOperator.ASG_SHL;
                }
                case ASSIGN_SAR: {
                    return JsBinaryOperator.ASG_SHR;
                }
                case ASSIGN_SHR: {
                    return JsBinaryOperator.ASG_SHRU;
                }
                case ASSIGN_ADD: {
                    return JsBinaryOperator.ASG_ADD;
                }
                case ASSIGN_SUB: {
                    return JsBinaryOperator.ASG_SUB;
                }
                case ASSIGN_MUL: {
                    return JsBinaryOperator.ASG_MUL;
                }
                case ASSIGN_DIV: {
                    return JsBinaryOperator.ASG_DIV;
                }
                case ASSIGN_MOD: {
                    return JsBinaryOperator.ASG_MOD;
                }
                case OR: {
                    return JsBinaryOperator.OR;
                }
                case AND: {
                    return JsBinaryOperator.AND;
                }
                case BIT_OR: {
                    return JsBinaryOperator.BIT_OR;
                }
                case BIT_XOR: {
                    return JsBinaryOperator.BIT_XOR;
                }
                case BIT_AND: {
                    return JsBinaryOperator.BIT_AND;
                }
                case SHL: {
                    return JsBinaryOperator.SHL;
                }
                case SAR: {
                    return JsBinaryOperator.SHR;
                }
                case SHR: {
                    return JsBinaryOperator.SHRU;
                }
                case ADD: {
                    return JsBinaryOperator.ADD;
                }
                case SUB: {
                    return JsBinaryOperator.SUB;
                }
                case MUL: {
                    return JsBinaryOperator.MUL;
                }
                case DIV: {
                    return JsBinaryOperator.DIV;
                }
                case MOD: {
                    return JsBinaryOperator.MOD;
                }
                case EQ: {
                    return JsBinaryOperator.EQ;
                }
                case NE: {
                    return JsBinaryOperator.NEQ;
                }
                case EQ_STRICT: {
                    return JsBinaryOperator.REF_EQ;
                }
                case NE_STRICT: {
                    return JsBinaryOperator.REF_NEQ;
                }
                case LT: {
                    return JsBinaryOperator.LT;
                }
                case GT: {
                    return JsBinaryOperator.GT;
                }
                case LTE: {
                    return JsBinaryOperator.LTE;
                }
                case GTE: {
                    return JsBinaryOperator.GTE;
                }
                case COMMA: {
                    return JsBinaryOperator.COMMA;
                }
            }
            throw new InternalCompilerException("Invalid binary operator");
        }

        private JsUnaryOperator mapUnaryOp(Token operator) {
            switch (operator) {
                case BIT_NOT: {
                    return JsUnaryOperator.BIT_NOT;
                }
                case NOT: {
                    return JsUnaryOperator.NOT;
                }
                case SUB: {
                    return JsUnaryOperator.NEG;
                }
                case INC: {
                    return JsUnaryOperator.INC;
                }
                case DEC: {
                    return JsUnaryOperator.DEC;
                }
            }
            throw new InternalCompilerException("Invalid unary operator.");
        }

        private Token mapToStrictEquals(Token op) {
            switch (op) {
                case EQ: {
                    return Token.EQ_STRICT;
                }
                case NE: {
                    return Token.NE_STRICT;
                }
                case EQ_STRICT: {
                    return Token.EQ_STRICT;
                }
                case NE_STRICT: {
                    return Token.NE_STRICT;
                }
            }
            throw new InternalCompilerException("Invalid equals operator.");
        }

        private Token mapToNonStrictEquals(Token op) {
            switch (op) {
                case EQ_STRICT: {
                    return Token.EQ;
                }
                case NE_STRICT: {
                    return Token.NE;
                }
                case EQ: {
                    return Token.EQ;
                }
                case NE: {
                    return Token.NE;
                }
            }
            throw new InternalCompilerException("Invalid equals operator.");
        }

        private final JsNode generate(DartNode node) {
            if (node != null) {
                try {
                    return node.getNormalizedNode().accept(this);
                }
                catch (AssertionError e) {
                    this.reportError(node, (Throwable)((Object)e));
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
            return null;
        }

        private JsExpression inlineArrayIndexCheck(JsExpression array, JsExpression index) {
            return AstUtil.newInvocation(new JsNameRef("$inlineArrayIndexCheck"), array, index);
        }

        private void reportError(DartNode node, Throwable exception) {
            this.context.onError(new DartCompilationError(node, (ErrorCode)JsErrorCode.INTERNAL_ERROR, exception.getLocalizedMessage()));
        }

        private final <T> void generateAll(List<? extends DartNode> nodes, List<T> result, Class<? extends T> cls) {
            for (DartNode dartNode : nodes) {
                result.add(cls.cast(this.generate(dartNode)));
            }
        }

        JsNameRef referenceName(Symbol symbol, SourceInfo info) {
            JsNameRef jsNode = this.maybeMakeScopeAliasReference(symbol);
            if (jsNode == null) {
                jsNode = this.getJsName(symbol).makeRef();
            }
            jsNode.setSourceRef(info);
            return jsNode;
        }

        @Override
        public void visit(List<? extends DartNode> nodes) {
            if (nodes != null) {
                for (DartNode dartNode : nodes) {
                    dartNode.accept(this);
                }
            }
        }

        @Override
        public JsNode visitAssertion(DartAssertion node) {
            if (this.inDevMode()) {
                JsExpression expression = (JsExpression)this.generate(node.getExpression());
                JsNameRef assertName = new JsNameRef("assert");
                JsInvocation jsInvoke = AstUtil.newInvocation(assertName, expression);
                return new JsExprStmt(jsInvoke).setSourceRef(node);
            }
            return this.empty();
        }

        private boolean inDevMode() {
            return this.context.getCompilerConfiguration().developerModeChecks();
        }

        @Override
        public JsNode visitParenthesizedExpression(DartParenthesizedExpression node) {
            return node.getExpression().accept(this);
        }

        @Override
        public JsNode visitCatchBlock(DartCatchBlock node) {
            throw new AssertionError((Object)"should never be called directly");
        }

        @Override
        public JsNode visitUnit(DartUnit unit) {
            throw new AssertionError((Object)"should never be called directly");
        }

        @Override
        public JsNode visitFunctionTypeAlias(DartFunctionTypeAlias node) {
            FunctionAliasElement classElement = node.getSymbol();
            JsName classJsName = this.getJsName(classElement);
            JsFunction jsClass = new JsFunction(this.globalScope, classJsName).setSourceRef(node);
            jsClass.setIsConstructor(false);
            jsClass.setBody(new JsBlock());
            this.globalBlock.getStatements().add(jsClass.makeStmt());
            this.rtt.generateRuntimeTypeInfo(node);
            return null;
        }

        private JsExpression generateQualifiedFieldAccess(DartNode qualifier, String accessorName, boolean accessThroughShim) {
            JsExpression jsQualifier = qualifier == null || qualifier instanceof DartThisExpression ? new JsThisRef() : (JsExpression)this.generate(qualifier);
            jsQualifier.setSourceRef(qualifier);
            JsNameRef nameRef = AstUtil.newNameRef(jsQualifier, accessorName);
            if (accessThroughShim) {
                return AstUtil.newInvocation(nameRef, new JsExpression[0]);
            }
            return nameRef;
        }

        private JsExpression generateUnresolvedAccess(DartNode qualifier, String accessorName) {
            if (qualifier == null) {
                return this.generateQualifiedFieldAccess(qualifier, accessorName, true);
            }
            JsExpression jsQualifier = (JsExpression)this.generate(qualifier);
            jsQualifier.setSourceRef(qualifier);
            JsNameRef method = AstUtil.newNameRef(jsQualifier, accessorName);
            return AstUtil.newInvocation(method, new JsExpression[0]);
        }

        private JsInvocation generateSuperFieldAccess(DartNode qualifier, String accessorName) {
            ClassElement superClass = ((SuperElement)qualifier.getSymbol()).getClassElement();
            JsNameRef jsQualifier = AstUtil.newPrototypeNameRef(this.getJsName(superClass).makeRef());
            jsQualifier.setSourceRef(qualifier);
            JsNameRef method = AstUtil.newNameRef((JsExpression)jsQualifier, accessorName);
            method = AstUtil.newNameRef((JsExpression)method, "call");
            JsInvocation jsInvoke = AstUtil.newInvocation(method, new JsExpression[0]);
            jsInvoke.getArguments().add(0, new JsThisRef());
            return jsInvoke;
        }

        private JsInvocation generateStaticFieldAccess(FieldElement element, DartNode qualifier, String accessorName) {
            JsNameRef jsQualifier = this.referenceName(element.getEnclosingElement(), qualifier);
            jsQualifier.setSourceRef(qualifier);
            JsNameRef method = AstUtil.newNameRef((JsExpression)jsQualifier, accessorName);
            return AstUtil.newInvocation(method, new JsExpression[0]);
        }

        private JsInvocation generateLibraryFieldAccess(String accessorName) {
            return AstUtil.newInvocation(new JsNameRef(accessorName), new JsExpression[0]);
        }

        private JsExpression generateFieldAccess(FieldElement field, DartNode qualifier, String accessorName, boolean accessThroughShim) {
            boolean isSuperCall;
            boolean bl = isSuperCall = qualifier != null && GenerateJavascriptVisitor.isSuperCall(qualifier.getSymbol());
            if (isSuperCall) {
                return this.generateSuperFieldAccess(qualifier, accessorName);
            }
            if (Elements.isTopLevel(field)) {
                return this.generateLibraryFieldAccess(accessorName);
            }
            if (field.isStatic()) {
                return this.generateStaticFieldAccess(field, qualifier, accessorName);
            }
            return this.generateQualifiedFieldAccess(qualifier, accessorName, accessThroughShim);
        }

        private JsExpression generateMethodBoundToVariable(DartIdentifier methodNode, MethodElement methodElement, DartNode qualifier) {
            JsExpression boundMethod;
            boolean isSuperCall;
            String mangledName = this.mangler.mangleNamedMethod(methodElement, this.unitLibrary);
            String mangledGetter = this.mangler.createGetterSyntax(methodElement, this.unitLibrary);
            boolean bl = isSuperCall = qualifier != null && GenerateJavascriptVisitor.isSuperCall(qualifier.getSymbol());
            if (isSuperCall) {
                boundMethod = this.generateSuperFieldAccess(qualifier, this.mangler.createGetterSyntax(methodElement.getName(), this.unitLibrary));
            } else if (Elements.isTopLevel(methodElement)) {
                boundMethod = AstUtil.newInvocation(AstUtil.newNameRef(null, mangledGetter), new JsExpression[0]);
            } else if (methodElement.isStatic()) {
                if (qualifier == null) {
                    qualifier = methodElement.getEnclosingElement().getNode();
                    assert (qualifier instanceof DartClass);
                    boundMethod = AstUtil.newNameRef((JsExpression)this.getJsName(qualifier.getSymbol()).makeRef(), mangledGetter);
                } else {
                    boundMethod = AstUtil.newNameRef((JsExpression)this.generate(qualifier), mangledGetter);
                }
                boundMethod = AstUtil.newInvocation(boundMethod, new JsExpression[0]);
            } else {
                if (qualifier == null) {
                    qualifier = DartThisExpression.get();
                }
                JsExpression methodQualifier = (JsExpression)this.generate(qualifier);
                ClassElement classElement = (ClassElement)methodElement.getEnclosingElement();
                String className = this.mangler.mangleClassName(classElement);
                JsNameRef prototypeRef = AstUtil.newPrototypeNameRef(new JsNameRef(className));
                JsNameRef methodToCall = AstUtil.newNameRef((JsExpression)prototypeRef, mangledName);
                JsNameRef methodRtt = AstUtil.newNameRef((JsExpression)prototypeRef, this.mangler.mangleRttLookupMethod(methodElement, this.unitLibrary));
                boundMethod = AstUtil.newInvocation(new JsNameRef("$bind"), methodToCall, methodRtt, methodQualifier);
            }
            boundMethod.setSourceRef(methodNode);
            return boundMethod;
        }

        private JsExpression generateLoadTemporary(Element element, DartIdentifier node) {
            return this.referenceName(element, node);
        }

        private JsExpression generateLoad(DartNode qualifier, DartIdentifier node, Element element) {
            boolean accessThroughShim = true;
            if (element != null) {
                accessThroughShim = false;
            } else {
                element = node.getTargetSymbol();
            }
            switch (ElementKind.of(element)) {
                case CLASS: 
                case VARIABLE: 
                case PARAMETER: 
                case FUNCTION_OBJECT: {
                    return this.generateLoadTemporary(element, node);
                }
                case NONE: {
                    if (qualifier != null && GenerateJavascriptVisitor.isSuperCall(qualifier.getSymbol())) {
                        return this.generateSuperFieldAccess(qualifier, this.mangler.createGetterSyntax(node.getTargetName(), this.unitLibrary));
                    }
                    return this.generateUnresolvedAccess(qualifier, this.mangler.createGetterSyntax(node.getTargetName(), this.unitLibrary));
                }
                case FIELD: {
                    FieldElement field = (FieldElement)element;
                    String accessorName = accessThroughShim ? this.mangler.createGetterSyntax(field, this.unitLibrary) : (this.optStrategy.isWhitelistedNativeField(field, TypeHeuristic.FieldKind.GETTER) ? field.getName() : this.mangler.mangleField(field, this.unitLibrary));
                    return this.generateFieldAccess(field, qualifier, accessorName, accessThroughShim);
                }
                case METHOD: {
                    MethodElement method = (MethodElement)element;
                    return this.generateMethodBoundToVariable(node, method, qualifier);
                }
            }
            throw new AssertionError((Object)("I do not know how to load: " + (Object)((Object)ElementKind.of(element))));
        }

        private JsExpression generateStoreTemporary(Element element, DartIdentifier node, JsExpression rhs) {
            JsNameRef jsName = this.referenceName(element, node);
            return AstUtil.newAssignment(jsName, rhs);
        }

        private JsExpression generateStoreField(JsExpression fieldAccess, JsExpression rhs) {
            if (fieldAccess instanceof JsInvocation) {
                JsNameRef $0 = new JsNameRef(this.createTemporary());
                JsBinaryOperation e = AstUtil.newAssignment($0, rhs);
                ((JsInvocation)fieldAccess).getArguments().add(e);
                return new JsBinaryOperation(JsBinaryOperator.COMMA, fieldAccess, $0);
            }
            assert (fieldAccess instanceof JsNameRef);
            return AstUtil.newAssignment((JsNameRef)fieldAccess, rhs);
        }

        private JsExpression generateStore(DartNode qualifier, DartIdentifier node, JsExpression rhs, Element element) {
            boolean accessThroughShim = true;
            if (element != null) {
                accessThroughShim = false;
            } else {
                element = node.getTargetSymbol();
            }
            switch (ElementKind.of(element)) {
                case VARIABLE: 
                case PARAMETER: {
                    return this.generateStoreTemporary(element, node, rhs);
                }
                case NONE: {
                    JsExpression invoke = this.generateUnresolvedAccess(qualifier, this.mangler.createSetterSyntax(node.getTargetName(), this.unitLibrary));
                    return this.generateStoreField(invoke, rhs);
                }
                case FIELD: {
                    FieldElement field = (FieldElement)element;
                    String accessorName = accessThroughShim ? this.mangler.createSetterSyntax(field, this.unitLibrary) : (this.optStrategy.isWhitelistedNativeField(field, TypeHeuristic.FieldKind.SETTER) ? field.getName() : this.mangler.mangleField(field, this.unitLibrary));
                    JsExpression invoke = this.generateFieldAccess(field, qualifier, accessorName, accessThroughShim);
                    return this.generateStoreField(invoke, rhs);
                }
            }
            throw new AssertionError((Object)("I do not know how to store into: " + (Object)((Object)ElementKind.of(element))));
        }

        @Override
        public JsNode visitParameterizedTypeNode(DartParameterizedTypeNode node) {
            return node.getExpression().accept(this);
        }

        @Override
        public JsNode visitImportDirective(DartImportDirective node) {
            throw new AssertionError((Object)"should never be called directly");
        }

        @Override
        public JsNode visitLibraryDirective(DartLibraryDirective node) {
            throw new AssertionError((Object)"should never be called directly");
        }

        @Override
        public JsNode visitNativeDirective(DartNativeDirective node) {
            throw new AssertionError((Object)"should never be called directly");
        }

        @Override
        public JsNode visitResourceDirective(DartResourceDirective node) {
            throw new AssertionError((Object)"should never be called directly");
        }

        @Override
        public JsNode visitSourceDirective(DartSourceDirective node) {
            throw new AssertionError((Object)"should never be called directly");
        }

        @Override
        public DartClassMember<?> getCurrentClassMember() {
            if (this.currentScopeInfo != null) {
                return this.currentScopeInfo.getContainingClassMember();
            }
            return null;
        }

        private ClassElement getCurrentClass() {
            if (this.currentHolder.getKind() == ElementKind.CLASS) {
                return (ClassElement)this.currentHolder;
            }
            return null;
        }

        class Assignment
        extends DartNodeTraverser<JsNode> {
            private final DartNode info;
            private final JsExpression rhs;
            private final Type rhsType;

            public Assignment(DartNode info, JsExpression rhs, Type rhsType) {
                this.info = info;
                this.rhs = rhs;
                this.rhsType = rhsType;
            }

            @Override
            public JsNode visitNode(DartNode lhs) {
                throw new AssertionError((Object)lhs.getClass().getSimpleName());
            }

            @Override
            public JsNode visitIdentifier(DartIdentifier lhs) {
                DartExpression normalizedNode = lhs.getNormalizedNode();
                if (lhs != normalizedNode) {
                    return normalizedNode.accept(this);
                }
                Type type = GenerateJavascriptVisitor.this.getTypeOfIdentifier(lhs);
                JsExpression wrapped = GenerateJavascriptVisitor.this.rtt.addTypeCheck(GenerateJavascriptVisitor.this.getCurrentClass(), this.rhs, type, this.rhsType, this.info);
                FieldElement element = GenerateJavascriptVisitor.this.optStrategy.findOptimizableFieldElementFor(lhs, TypeHeuristic.FieldKind.SETTER);
                return GenerateJavascriptVisitor.this.generateStore(null, lhs, wrapped, element).setSourceRef(this.info);
            }

            @Override
            public JsNode visitPropertyAccess(DartPropertyAccess lhs) {
                FieldElement element = GenerateJavascriptVisitor.this.optStrategy.findOptimizableFieldElementFor(lhs, TypeHeuristic.FieldKind.SETTER);
                Type type = lhs.getType();
                JsExpression wrapped = GenerateJavascriptVisitor.this.rtt.addTypeCheck(GenerateJavascriptVisitor.this.getCurrentClass(), this.rhs, type, this.rhsType, this.info);
                return GenerateJavascriptVisitor.this.generateStore(lhs.getQualifier(), lhs.getName(), wrapped, element).setSourceRef(this.info);
            }

            @Override
            public JsNode visitArrayAccess(DartArrayAccess lhs) {
                JsExpression key = (JsExpression)GenerateJavascriptVisitor.this.generate(lhs.getKey());
                JsExpression e1 = (JsExpression)GenerateJavascriptVisitor.this.generate(lhs.getTarget());
                Type type = lhs.getType();
                JsExpression wrapped = GenerateJavascriptVisitor.this.rtt.addTypeCheck(GenerateJavascriptVisitor.this.getCurrentClass(), this.rhs, type, this.rhsType, this.info);
                if (GenerateJavascriptVisitor.this.optStrategy.canSkipArrayAccessShim(lhs, true)) {
                    JsBinaryOperation assign = new JsBinaryOperation(JsBinaryOperator.ASG);
                    assign.setArg1(AstUtil.newArrayAccess(e1, GenerateJavascriptVisitor.this.inlineArrayIndexCheck(e1, key)));
                    assign.setArg2(wrapped);
                    return assign.setSourceRef(this.info);
                }
                JsNameRef $0 = new JsNameRef(GenerateJavascriptVisitor.this.createTemporary());
                String $set = GenerateJavascriptVisitor.this.mangler.createOperatorSyntax(Token.ASSIGN_INDEX);
                JsExpression e = AstUtil.newAssignment($0, wrapped);
                e = AstUtil.newInvocation(AstUtil.newNameRef(e1, $set), key, e);
                return new JsBinaryOperation(JsBinaryOperator.COMMA, e, $0).setSourceRef(this.info);
            }
        }

        private class FunctionExpressionInliner
        implements Callable<JsExpression> {
            private final List<DartExpression> arguments;
            private final List<DartParameter> parameters;
            private final Map<Symbol, Element> parameterMap = new HashMap<Symbol, Element>();
            private final List<DartStatement> statements;
            private final JsExpression[] expressions;

            FunctionExpressionInliner(DartFunctionExpression functionExpression, List<DartExpression> arguments) {
                DartFunction function = functionExpression.getFunction();
                this.arguments = arguments;
                this.parameters = function.getParams();
                assert (arguments.size() == this.parameters.size());
                this.statements = function.getBody().getStatements();
                this.expressions = new JsExpression[this.parameters.size() + this.statements.size()];
            }

            @Override
            public JsExpression call() {
                int i = 0;
                Iterator<DartExpression> argumentsIterator = this.arguments.iterator();
                for (DartParameter parameter : this.parameters) {
                    this.expressions[i++] = this.rewriteArgument(parameter, argumentsIterator.next());
                }
                for (DartStatement statement : this.statements) {
                    this.expressions[i++] = this.rewriteStatement(statement);
                }
                if (i == 1) {
                    return this.expressions[0];
                }
                return AstUtil.newSequence(this.expressions);
            }

            private JsExpression rewriteArgument(DartParameter parameter, DartExpression argument) {
                JsName temporary = GenerateJavascriptVisitor.this.createTemporary();
                VariableElement element = Elements.makeVariable(temporary.getIdent());
                this.parameterMap.put(parameter.getSymbol(), element);
                GenerateJavascriptVisitor.this.translationContext.getNames().setName(element, temporary);
                return AstUtil.newAssignment(temporary.makeRef(), (JsExpression)GenerateJavascriptVisitor.this.generate(argument));
            }

            private JsExpression rewriteStatement(DartStatement node) {
                node.accept(new ParameterRewriter());
                JsNode jsNode = GenerateJavascriptVisitor.this.generate(node);
                if (jsNode instanceof JsExprStmt) {
                    return ((JsExprStmt)jsNode).getExpression();
                }
                if (jsNode instanceof JsReturn) {
                    return ((JsReturn)jsNode).getExpr();
                }
                throw new AssertionError(node);
            }

            private class ParameterRewriter
            extends DartNodeTraverser<Void> {
                private ParameterRewriter() {
                }

                @Override
                public Void visitIdentifier(DartIdentifier node) {
                    Element element = (Element)FunctionExpressionInliner.this.parameterMap.get(node.getTargetSymbol());
                    if (element != null) {
                        DartIdentifier identifier = new DartIdentifier(element.getName());
                        identifier.setSourceInfo(node);
                        identifier.setSymbol(element);
                        node.setNormalizedNode(identifier);
                    }
                    return null;
                }
            }
        }
    }
}

