/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.js;

import java.io.IOException;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.common.collect.ArrayListMultimap;
import org.jetbrains.jet.internal.com.google.common.collect.HashMultimap;
import org.jetbrains.jet.internal.com.google.common.collect.HashMultiset;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Multimap;
import org.jetbrains.jet.internal.com.google.common.collect.Multimaps;
import org.jetbrains.jet.internal.com.google.common.io.Closeables;
import org.jetbrains.jet.internal.com.google.dart.compiler.CommandLineOptions;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartSource;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.LibraryNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.LibraryUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.common.AbstractBackend;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.BasicOptimizationStrategy;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.DartMangler;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.DollarMangler;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.GenerateJavascriptAST;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsPrettyNamer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsSourceGenerationVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.NoOptimizationStrategy;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.Normalizer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.OptimizationStrategy;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.TranslationContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.jet.internal.com.google.dart.compiler.metrics.DartEventType;
import org.jetbrains.jet.internal.com.google.dart.compiler.metrics.Tracer;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CoreTypeProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.DefaultTextOutput;

public abstract class AbstractJsBackend
extends AbstractBackend {
    public static final String EXTENSION_JS = "js";
    public static final String EXTENSION_APP_JS = "app.js";
    public static final String EXTENSION_JS_SRC_MAP = "js.map";
    public static final String EXTENSION_APP_JS_SRC_MAP = "app.js.map";
    protected final DartMangler mangler = new DollarMangler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, JsProgram> translateToJS(DartUnit unit, DartCompilerContext context, CoreTypeProvider typeProvider) {
        Tracer.TraceEvent logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.TRANSLATE_TO_JS, "unit", unit.getSourceName()) : null;
        CommandLineOptions.CompilerOptions options = context.getCompilerConfiguration().getCompilerOptions();
        OptimizationStrategy optimizationStrategy = this.shouldOptimize() && !options.disableTypeOptimizations() ? new BasicOptimizationStrategy(unit, typeProvider) : new NoOptimizationStrategy(unit, typeProvider);
        try {
            Tracer.TraceEvent normalizeEvent = Tracer.canTrace() ? Tracer.start(DartEventType.JS_NORMALIZE, "unit", unit.getSourceName()) : null;
            try {
                unit = (DartUnit)new Normalizer().exec(unit, typeProvider, optimizationStrategy).getNormalizedNode();
            }
            catch (Throwable throwable) {
                Tracer.end(normalizeEvent, new String[0]);
                throw throwable;
            }
            Tracer.end(normalizeEvent, new String[0]);
            JsPrettyNamer namer = new JsPrettyNamer();
            LinkedHashMap<String, JsProgram> parts = new LinkedHashMap<String, JsProgram>();
            List<DartNode> topNodes = unit.getTopLevelNodes();
            String baseUnitId = AbstractJsBackend.generateBaseUnitId(unit);
            int partIndex = 0;
            JsProgram nonClassStatements = new JsProgram(baseUnitId + partIndex++);
            GenerateJavascriptAST nonClassGenerator = null;
            TranslationContext nonClassTranslationContext = null;
            JsProgram staticInitStatements = new JsProgram(baseUnitId + partIndex++);
            JsBlock staticInitBlock = staticInitStatements.getGlobalBlock();
            for (DartNode node : topNodes) {
                if ((node = node.getNormalizedNode()) instanceof DartClass) {
                    Tracer.TraceEvent nodeEvent = Tracer.canTrace() ? Tracer.start(DartEventType.TRANSLATE_NODE, "unit", unit.getSourceName(), "node", node.getSymbol().getOriginalSymbolName()) : null;
                    try {
                        JsProgram program = new JsProgram(baseUnitId + partIndex++);
                        TranslationContext translationContext = TranslationContext.createContext(unit, program, this.mangler, node);
                        GenerateJavascriptAST generator = new GenerateJavascriptAST(unit, typeProvider, context, optimizationStrategy, this.generateClosureCompatibleCode());
                        generator.translateNode(translationContext, node, staticInitBlock);
                        Tracer.TraceEvent namerEvent = Tracer.canTrace() ? Tracer.start(DartEventType.NAMER, "unit", unit.getSourceName()) : null;
                        try {
                            namer.exec(program);
                        }
                        finally {
                            Tracer.end(namerEvent, new String[0]);
                        }
                        parts.put(((DartClass)node).getClassName(), program);
                    }
                    catch (Throwable throwable) {
                        Tracer.end(nodeEvent, new String[0]);
                        throw throwable;
                    }
                    Tracer.end(nodeEvent, new String[0]);
                    continue;
                }
                if (nonClassGenerator == null) {
                    Tracer.TraceEvent genInitEvent = Tracer.canTrace() ? Tracer.start(DartEventType.GEN_AST_INIT, "unit", unit.getSourceName()) : null;
                    try {
                        nonClassTranslationContext = TranslationContext.createContext(unit, nonClassStatements, this.mangler, null);
                        nonClassGenerator = new GenerateJavascriptAST(unit, typeProvider, context, optimizationStrategy, this.generateClosureCompatibleCode());
                    }
                    catch (Throwable throwable) {
                        Tracer.end(genInitEvent, new String[0]);
                        throw throwable;
                    }
                    Tracer.end(genInitEvent, new String[0]);
                }
                nonClassGenerator.translateNode(nonClassTranslationContext, node, staticInitBlock);
            }
            Tracer.TraceEvent namerEvent = Tracer.canTrace() ? Tracer.start(DartEventType.NAMER, "unit", unit.getSourceName()) : null;
            try {
                namer.exec(nonClassStatements);
            }
            finally {
                Tracer.end(namerEvent, new String[0]);
            }
            parts.put("", nonClassStatements);
            for (int i = 0; i < staticInitStatements.getFragmentCount(); ++i) {
                if (staticInitStatements.getFragmentBlock(i).getStatements().isEmpty()) continue;
                parts.put("$statics$", staticInitStatements);
                break;
            }
            LinkedHashMap<String, JsProgram> linkedHashMap = parts;
            return linkedHashMap;
        }
        finally {
            Tracer.end(logEvent, new String[0]);
        }
    }

    private static String generateBaseUnitId(DartUnit unit) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"Could not find MD5 digest");
        }
        StringBuilder sb = new StringBuilder();
        byte[] md5 = md.digest(unit.getSource().getUri().toString().getBytes());
        for (int i = 0; i < 3; ++i) {
            sb.append(Integer.toHexString((md5[i] & 0xF0) >> 4));
            sb.append(Integer.toHexString(md5[i] & 0xF));
        }
        return sb.toString();
    }

    protected int writeEntryPointCall(String entry, Writer out) throws IOException {
        String entryPointCall = "RunEntry(" + entry + ", this.arguments ?" + " (this.arguments.slice ? [].concat(this.arguments.slice())" + " : this.arguments) : []);";
        out.write(entryPointCall);
        return entryPointCall.length();
    }

    protected String getMangledEntryPoint(DartCompilerContext context) {
        MethodElement entry = context.getApplicationUnit().getElement().getEntryPoint();
        if (entry == null) {
            return null;
        }
        return this.mangler.mangleEntryPoint(entry, context.getApplicationUnit().getElement());
    }

    @Override
    public boolean isOutOfDate(DartSource src, DartCompilerContext context) {
        return context.isOutOfDate(src, src, EXTENSION_JS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileUnit(DartUnit unit, DartSource src, DartCompilerContext context, CoreTypeProvider typeProvider) throws IOException {
        Map<String, JsProgram> parts = this.translateToJS(unit, context, typeProvider);
        String srcName = src.getName();
        for (Map.Entry<String, JsProgram> entry : parts.entrySet()) {
            Writer w;
            JsSourceGenerationVisitor srcGenerator;
            DefaultTextOutput out = new DefaultTextOutput(false);
            String name = entry.getKey();
            boolean failed = true;
            JsProgram program = entry.getValue();
            JsBlock globalBlock = program.getGlobalBlock();
            Tracer.TraceEvent srcEvent = Tracer.canTrace() ? Tracer.start(DartEventType.JS_SOURCE_GEN, "src", srcName, "name", name) : null;
            try {
                srcGenerator = new JsSourceGenerationVisitor(out);
                srcGenerator.generateSourceMap(true);
                srcGenerator.accept(globalBlock);
                w = context.getArtifactWriter(src, name, EXTENSION_JS);
                try {
                    w.write(((Object)out).toString());
                    failed = false;
                }
                finally {
                    Closeables.close(w, failed);
                }
            }
            catch (Throwable throwable) {
                Tracer.end(srcEvent, new String[0]);
                throw throwable;
            }
            Tracer.end(srcEvent, new String[0]);
            if (globalBlock.getStatements().isEmpty() || !this.generateSourceMap(context)) continue;
            Tracer.TraceEvent sourcemapEvent = Tracer.canTrace() ? Tracer.start(DartEventType.WRITE_SOURCE_MAP, "src", srcName, "name", name) : null;
            try {
                w = context.getArtifactWriter(src, name, EXTENSION_JS_SRC_MAP);
                failed = true;
                try {
                    srcGenerator.writeSourceMap(w, src.getName());
                    failed = false;
                }
                finally {
                    Closeables.close(w, failed);
                }
            }
            catch (Throwable throwable) {
                Tracer.end(sourcemapEvent, new String[0]);
                throw throwable;
            }
            Tracer.end(sourcemapEvent, new String[0]);
        }
    }

    protected abstract boolean shouldOptimize();

    protected boolean generateClosureCompatibleCode() {
        return false;
    }

    protected boolean generateSourceMap(DartCompilerContext context) {
        return context.getCompilerConfiguration().getCompilerOptions().generateSourceMaps();
    }

    protected static class DependencyBuilder {
        private final List<Part> parts;
        private final Part staticSeparator = new Part(null, null, "$seperator$", null, null);

        static void build(LibraryUnit libUnit, DepsCallback callback) throws IOException {
            DependencyBuilder builder = new DependencyBuilder();
            builder.gatherParts(libUnit);
            builder.sortParts();
            builder.writeParts(callback);
        }

        private DependencyBuilder() {
            this.parts = new ArrayList<Part>();
        }

        private void gatherParts(LibraryUnit libUnit) {
            this.gatherParts(libUnit, new HashSet<LibraryUnit>());
        }

        private void gatherParts(LibraryUnit libUnit, Set<LibraryUnit> seenLibs) {
            if (seenLibs.contains(libUnit)) {
                return;
            }
            seenLibs.add(libUnit);
            for (LibraryUnit importUnit : libUnit.getImports()) {
                this.gatherParts(importUnit, seenLibs);
            }
            for (DartUnit unit : libUnit.getUnits()) {
                DartSource src = unit.getSource();
                if (src == null) continue;
                this.gatherUnitParts(libUnit, unit);
            }
        }

        private void gatherUnitParts(LibraryUnit libUnit, DartUnit unit) {
            List<DartNode> nodes = ((DartUnit)unit.getNormalizedNode()).getTopLevelNodes();
            for (DartNode node : nodes) {
                DartNode norm = node.getNormalizedNode();
                if (!(norm instanceof DartClass)) continue;
                DartClass clasz = (DartClass)norm;
                ClassElement selfElement = clasz.getSymbol();
                InterfaceType superType = selfElement.getSupertype();
                ClassElement superElement = null;
                if (superType != null) {
                    superElement = superType.getElement();
                    assert (superElement != null);
                }
                this.parts.add(new Part(libUnit, unit, clasz.getClassName(), selfElement, superElement));
            }
            this.parts.add(new Part(libUnit, unit, "", null, null));
            this.parts.add(new Part(libUnit, unit, "$statics$", null, null));
        }

        private static <T> List<T> topologicalStableSort(List<T> items, Multimap<T, T> deps) {
            final HashMap<T, Integer> originalIndex = Maps.newHashMap();
            for (int i = 0; i < items.size(); ++i) {
                originalIndex.put(items.get(i), i);
            }
            PriorityQueue<Object> inDegreeZero = new PriorityQueue<Object>(items.size(), new Comparator<T>(){

                @Override
                public int compare(T a, T b) {
                    return (Integer)originalIndex.get(a) - (Integer)originalIndex.get(b);
                }
            });
            ArrayList result = Lists.newArrayList();
            HashMultiset<T> inDegree = HashMultiset.create();
            ArrayListMultimap reverseDeps = ArrayListMultimap.create();
            Multimaps.invertFrom(deps, reverseDeps);
            for (T item : items) {
                Collection<T> itemDeps = deps.get(item);
                inDegree.add(item, itemDeps.size());
                if (!itemDeps.isEmpty()) continue;
                inDegreeZero.add(item);
            }
            while (!inDegreeZero.isEmpty()) {
                Object item = inDegreeZero.remove();
                result.add(item);
                for (Object inWaiting : reverseDeps.get(item)) {
                    inDegree.remove(inWaiting, 1);
                    if (inDegree.count(inWaiting) != 0) continue;
                    inDegreeZero.add(inWaiting);
                }
            }
            return result;
        }

        private Multimap<Part, Part> buildDependencyMap(List<Part> parts) {
            parts.add(this.staticSeparator);
            HashMap<ClassElement, Part> elementToPartMap = Maps.newHashMap();
            for (Part part : parts) {
                if (part.element == null) continue;
                Part previous = elementToPartMap.put(part.element, part);
                assert (previous == null);
            }
            HashMultimap<Part, Part> deps = HashMultimap.create();
            for (Part part : parts) {
                if (part.superElement != null) {
                    Part superPart = (Part)elementToPartMap.get(part.superElement);
                    assert (superPart != null);
                    deps.put(part, superPart);
                }
                if (part == this.staticSeparator) continue;
                if (part.part.equals("$statics$")) {
                    deps.put(part, this.staticSeparator);
                    continue;
                }
                deps.put(this.staticSeparator, part);
            }
            return deps;
        }

        private void sortParts() {
            List<Part> unsortedParts = this.parts;
            Multimap<Part, Part> deps = this.buildDependencyMap(unsortedParts);
            List<Part> sortParts = DependencyBuilder.topologicalStableSort(unsortedParts, deps);
            this.parts.clear();
            this.parts.addAll(sortParts);
        }

        private long writeParts(DepsCallback callback) throws IOException {
            long charsWritten = 0L;
            HashSet<LibraryUnit> seenLibs = new HashSet<LibraryUnit>();
            for (Part part : this.parts) {
                this.writePart(part, callback, seenLibs);
            }
            return charsWritten;
        }

        private void writePart(Part part, DepsCallback callback, Set<LibraryUnit> seenLibs) throws IOException {
            if (part == this.staticSeparator) {
                return;
            }
            if (!seenLibs.contains(part.lib)) {
                seenLibs.add(part.lib);
                for (LibraryNode node : part.lib.getNativePaths()) {
                    callback.visitNative(part.lib, node);
                }
            }
            callback.visitPart(part);
        }
    }

    protected static interface DepsCallback {
        public void visitNative(LibraryUnit var1, LibraryNode var2) throws IOException;

        public void visitPart(Part var1) throws IOException;
    }

    protected static class Part {
        final LibraryUnit lib;
        final DartUnit unit;
        final String part;
        final ClassElement element;
        final ClassElement superElement;

        public Part(LibraryUnit lib, DartUnit unit, String part, ClassElement element, ClassElement superElement) {
            this.lib = lib;
            this.unit = unit;
            this.element = element;
            this.part = part;
            this.superElement = superElement;
        }

        public int hashCode() {
            if (this.element != null) {
                return this.element.hashCode();
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.part == null ? 0 : this.part.hashCode());
            result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Part other = (Part)obj;
            if (this.element != null) {
                return this.element.equals(other.element);
            }
            return this.unit.equals(other.unit) && this.part.equals(other.part);
        }
    }
}

