/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.doc;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.common.io.CharStreams;
import org.jetbrains.jet.internal.com.google.dart.compiler.Source;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartComment;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartField;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNodeTraverser;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.LibraryUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.doc.ElementNameComparator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.doc.LinkInformation;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.AbstractNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ConstructorElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.EnclosingElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FieldElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.VariableElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.FunctionType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeKind;

class DartDocumentationVisitor
extends DartNodeTraverser<Void> {
    private String outputDirectory;
    private String library;
    private PrintStream stream;
    private List<DartComment> dartDocComments;
    private Set<LinkInformation> anchors;
    private Set<LinkInformation> links;
    private char[] unitSource;

    DartDocumentationVisitor(String out, String lib, List<DartComment> comments, Set<LinkInformation> anchors, Set<LinkInformation> links) {
        this.outputDirectory = out;
        this.library = lib;
        this.dartDocComments = comments == null ? Collections.emptyList() : new ArrayList<DartComment>(comments);
        this.anchors = anchors;
        this.links = links;
        this.stream = null;
        this.unitSource = null;
    }

    public void initialize(DartUnit unit) {
        this.readSource(unit.getSource());
    }

    private boolean isPrivateName(String name) {
        return !name.isEmpty() && name.charAt(0) == '_';
    }

    private void readSource(Source source) {
        try {
            Reader reader = source.getSourceReader();
            CharArrayWriter writer = new CharArrayWriter();
            CharStreams.copy(reader, (Appendable)writer);
            this.unitSource = writer.toCharArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private DartComment getDocComment(int position) {
        int commentEnd;
        AbstractNode closest = null;
        for (DartComment comment : this.dartDocComments) {
            if (position <= comment.getSourceStart()) continue;
            if (closest == null) {
                closest = comment;
                continue;
            }
            int bestDistance = position - closest.getSourceStart();
            int currentDistance = position - comment.getSourceStart();
            if (currentDistance >= bestDistance) continue;
            closest = comment;
        }
        if (closest == null) {
            return null;
        }
        for (int i = commentEnd = closest.getSourceStart() + closest.getSourceLength(); i < position; ++i) {
            if (Character.isWhitespace(this.unitSource[i])) continue;
            return null;
        }
        return closest;
    }

    private String anchorEscape(String string) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append(string.codePointAt(i));
        }
        return buffer.toString();
    }

    private void escapeAndPrint(PrintStream stream, String string) {
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stream.print("&lt;");
                    continue block6;
                }
                case '>': {
                    stream.print("&gt;");
                    continue block6;
                }
                case '&': {
                    stream.print("&amp;");
                    continue block6;
                }
                case '\"': {
                    stream.print("&quot;");
                    continue block6;
                }
                default: {
                    stream.print(c);
                }
            }
        }
    }

    private void escapeAndAppendChar(StringBuffer buffer, char c) {
        switch (c) {
            case '<': {
                buffer.append("&lt;");
                break;
            }
            case '>': {
                buffer.append("&gt;");
                break;
            }
            case '&': {
                buffer.append("&amp;");
                break;
            }
            case '\"': {
                buffer.append("&quot;");
                break;
            }
            default: {
                buffer.append(c);
            }
        }
    }

    private String commentToString(DartComment comment) {
        if (comment.isDartDoc()) {
            StringBuffer buffer = new StringBuffer();
            int index = comment.getSourceStart();
            while (this.unitSource[index] != '/') {
                ++index;
            }
            index += 3;
            while (index < this.unitSource.length) {
                while (this.unitSource[index] != '\n' && this.unitSource[index] != '*') {
                    this.escapeAndAppendChar(buffer, this.unitSource[index++]);
                }
                if (this.unitSource[index] == '*') {
                    if (this.unitSource[index + 1] == '/') {
                        return buffer.toString();
                    }
                    buffer.append(this.unitSource[index++]);
                    continue;
                }
                buffer.append('\n');
                while (this.unitSource[index] != '*') {
                    ++index;
                }
                if (this.unitSource[++index] != '/') continue;
                assert (index + 1 - comment.getSourceStart() == comment.getSourceLength());
                return buffer.toString();
            }
        }
        return "";
    }

    private void printClassTypeParameters(ClassElement classElement) {
        List<? extends Type> typeParameters = classElement.getTypeParameters();
        if (typeParameters.size() > 0) {
            this.stream.print("&lt;");
            boolean first = true;
            for (Type type : typeParameters) {
                if (!first) {
                    this.stream.print(",");
                } else {
                    first = false;
                }
                this.escapeAndPrint(this.stream, type.getElement().getName());
            }
            this.stream.print("&gt;");
        }
    }

    private void printClassReference(ClassElement classElement) {
        String name = classElement.getName();
        LinkInformation linkInfo = new LinkInformation(classElement.getLibrary().getName(), name, name + "::" + name);
        this.links.add(linkInfo);
        this.stream.print(linkInfo.anchorReferenceStartTag());
        this.stream.print(name);
        this.printClassTypeParameters(classElement);
        this.stream.print("</a>");
    }

    private boolean printElementReference(Element elm, String name) {
        if (elm.getKind() == ElementKind.METHOD || elm.getKind() == ElementKind.CONSTRUCTOR) {
            MethodElement method = (MethodElement)elm;
            for (VariableElement param : method.getParameters()) {
                if (!param.getName().equals(name)) continue;
                assert (elm.getEnclosingElement().getKind() == ElementKind.CLASS);
                ClassElement enclosingClass = (ClassElement)elm.getEnclosingElement();
                String libraryName = enclosingClass.getLibrary().getName();
                String className = enclosingClass.getName();
                String elementReference = enclosingClass.getName() + "::" + this.anchorEscape(method.getName()) + "::" + name;
                LinkInformation linkInfo = new LinkInformation(libraryName, className, elementReference);
                this.links.add(linkInfo);
                this.stream.print("<code>");
                this.stream.print(linkInfo.anchorReferenceStartTag());
                this.stream.print(name);
                this.stream.print("</a></code>");
                return true;
            }
        }
        EnclosingElement enclosing = elm.getEnclosingElement();
        if (elm.getKind() == ElementKind.CLASS) {
            enclosing = (ClassElement)elm;
        }
        while (enclosing != null) {
            if (this.printElementReferenceFromEnclosingElement(name, enclosing)) {
                return true;
            }
            enclosing = enclosing.getEnclosingElement();
        }
        return false;
    }

    private boolean printElementReferenceFromEnclosingElement(String name, EnclosingElement enclosing) {
        Element localElement = enclosing.lookupLocalElement(name);
        if (localElement != null) {
            switch (localElement.getKind()) {
                case METHOD: 
                case FIELD: {
                    assert (localElement.getEnclosingElement().getKind() == ElementKind.CLASS);
                    ClassElement enclosingClass = (ClassElement)localElement.getEnclosingElement();
                    if (enclosingClass != null) {
                        String className = enclosingClass.getName();
                        String elementReference = className + "::" + name;
                        LinkInformation linkInformation = new LinkInformation(enclosingClass.getLibrary().getName(), className, elementReference);
                        this.links.add(linkInformation);
                        this.stream.print("<code>");
                        this.stream.print(linkInformation.anchorReferenceStartTag());
                        this.stream.print(name);
                        this.stream.print("</a></code>");
                        return true;
                    }
                    return false;
                }
                case CLASS: {
                    this.stream.print("<code>");
                    this.printClassReference((ClassElement)localElement);
                    this.stream.print("</code>");
                    return true;
                }
            }
            return false;
        }
        if (enclosing.getKind() == ElementKind.CLASS) {
            ClassElement classElement;
            ClassElement classElement2 = (ClassElement)enclosing;
            List<? extends Type> typeParameters = classElement2.getTypeParameters();
            for (Type type : typeParameters) {
                if (!type.getElement().getName().equals(name)) continue;
                String className = classElement2.getName();
                String elementReference = className + "::" + className;
                LinkInformation linkInfo = new LinkInformation(classElement2.getLibrary().getName(), className, elementReference);
                this.links.add(linkInfo);
                this.stream.print("<code>");
                this.stream.print(linkInfo.anchorReferenceStartTag());
                this.escapeAndPrint(this.stream, type.getElement().getName());
                this.stream.print("</a></code>");
                return true;
            }
            InterfaceType supertype = classElement2.getSupertype();
            if (supertype != null && this.printElementReferenceFromEnclosingElement(name, classElement = supertype.getElement())) {
                return true;
            }
            List<InterfaceType> list = classElement2.getInterfaces();
            for (InterfaceType interfaceType : list) {
                if (!this.printElementReferenceFromEnclosingElement(name, interfaceType.getElement())) continue;
                return true;
            }
        }
        return false;
    }

    private void printElementComment(Element elm) {
        DartComment comment = this.getDocComment(elm.getNode().getSourceStart());
        if (comment != null) {
            String rawComment = this.commentToString(comment);
            int length = rawComment.length();
            int index = 0;
            while (index < length) {
                int escapeIndex = rawComment.indexOf(91, index);
                if (escapeIndex == -1) {
                    this.stream.print(rawComment.substring(index));
                    break;
                }
                this.stream.print(rawComment.substring(index, escapeIndex));
                int escapeEndIndex = rawComment.indexOf(93, escapeIndex);
                if (escapeEndIndex == -1) {
                    this.stream.print("[");
                    index = escapeIndex + 1;
                    continue;
                }
                if (rawComment.charAt(escapeIndex + 1) == ':' && rawComment.charAt(escapeEndIndex - 1) == ':') {
                    String code = rawComment.substring(escapeIndex + 2, escapeEndIndex - 1);
                    this.stream.print("<code>");
                    if (code.contains("\n")) {
                        this.stream.println("<br>");
                    }
                    this.stream.print(code.replaceAll("\n", "<br>").replaceAll(" ", "&nbsp;"));
                    if (code.contains("\n")) {
                        this.stream.println("<br>");
                    }
                    this.stream.println("</code>\n");
                } else {
                    String name = rawComment.substring(escapeIndex + 1, escapeEndIndex);
                    if (!this.printElementReference(elm, name)) {
                        this.stream.print("[");
                        this.stream.print(name);
                        this.stream.print("]");
                    }
                }
                index = escapeEndIndex + 1;
            }
        }
    }

    @Override
    public Void visitMethodDefinition(DartMethodDefinition node) {
        this.documentToplevelMethod(node.getSymbol());
        return null;
    }

    @Override
    public Void visitField(DartField node) {
        this.documentToplevelField(node.getSymbol());
        return null;
    }

    @Override
    public Void visitClass(DartClass node) {
        this.documentClass(node.getSymbol());
        return null;
    }

    private void printFunctionTypeParameterList(FunctionType type, Element element) {
        List<? extends Type> paramTypes = type.getParameterTypes();
        this.stream.print("(");
        boolean first = true;
        for (Type type2 : paramTypes) {
            if (first) {
                first = false;
            } else {
                this.stream.print(", ");
            }
            if (this.printElementReference(element, type2.getElement().getName())) continue;
            this.escapeAndPrint(this.stream, type2.getElement().getName());
        }
        this.stream.print(")");
    }

    private void printMethodParameterList(MethodElement method, ClassElement classElement) {
        String className = classElement.getName();
        this.stream.print("(");
        boolean first = true;
        boolean foundOptionalParam = false;
        for (VariableElement param : method.getParameters()) {
            Type paramType;
            if (first) {
                first = false;
            } else {
                this.stream.print(", ");
            }
            if (!foundOptionalParam && param.isNamed()) {
                this.stream.print("[");
                foundOptionalParam = true;
            }
            boolean isFunctionType = (paramType = param.getType()).getKind() == TypeKind.FUNCTION;
            Element paramTypeElement = paramType.getElement();
            if (isFunctionType) {
                FunctionType functionType = (FunctionType)paramType;
                Element returnTypeElement = functionType.getReturnType().getElement();
                if (!this.printElementReference(method, returnTypeElement.getName())) {
                    this.escapeAndPrint(this.stream, returnTypeElement.getName());
                }
            } else if (!this.printElementReference(method, paramTypeElement.getName())) {
                this.escapeAndPrint(this.stream, paramTypeElement.getName());
            }
            this.stream.print(" ");
            String elementReference = className + "::" + this.anchorEscape(method.getName()) + "::" + param.getName();
            LinkInformation linkInfo = new LinkInformation(classElement.getLibrary().getName(), className, elementReference);
            this.anchors.add(linkInfo);
            this.stream.print(linkInfo.anchorStartTag());
            this.stream.print(param.getName());
            this.stream.print("</a>");
            if (isFunctionType) {
                FunctionType functionType = (FunctionType)paramType;
                this.printFunctionTypeParameterList(functionType, method);
            }
            if (!foundOptionalParam || param.getDefaultValue() == null) continue;
            this.stream.print(" = ");
            this.stream.print(param.getDefaultValue().toString());
        }
        if (foundOptionalParam) {
            this.stream.print("]");
        }
        this.stream.print(")");
    }

    private void printSupertype(ClassElement classElement) {
        InterfaceType supertype = classElement.getSupertype();
        if (supertype != null && !this.isPrivateName(supertype.getElement().getName())) {
            this.stream.println("\n<section class=\"supertype\">");
            this.stream.println("<h2>Supertype:</h2>");
            this.stream.print("<ul><li>");
            LibraryUnit supertypeLibraryUnit = supertype.getElement().getLibrary().getLibraryUnit();
            if (this.library == null || this.library.equals(supertypeLibraryUnit.getName())) {
                this.printClassReference(supertype.getElement());
            } else {
                this.stream.print(supertype.getElement().getName());
            }
            this.stream.println("</li></ul>");
            this.stream.println("</section>");
        }
    }

    private void printInterfaces(ClassElement classElement) {
        List<InterfaceType> interfaces = classElement.getInterfaces();
        LinkedList<ClassElement> nonPrivateInterfaces = new LinkedList<ClassElement>();
        for (InterfaceType type : interfaces) {
            ClassElement element = type.getElement();
            if (this.isPrivateName(element.getName())) continue;
            nonPrivateInterfaces.add(element);
        }
        if (nonPrivateInterfaces.size() > 0) {
            Collections.sort(nonPrivateInterfaces, new ElementNameComparator());
            this.stream.println("\n<section class=\"interfaces\">");
            this.stream.println("<h2>Implemented interfaces:</h2>");
            this.stream.println("<ul>");
            boolean first = true;
            for (ClassElement element : nonPrivateInterfaces) {
                this.stream.print("<li>");
                this.printClassReference(element);
                this.stream.println("</li>");
            }
            this.stream.println("</ul>");
            this.stream.println("</section>");
        }
    }

    private void printSubTypes(ClassElement classElement) {
        Set<InterfaceType> subtypes = classElement.getSubtypes();
        LinkedList<ClassElement> relevantSubtypes = new LinkedList<ClassElement>();
        for (InterfaceType type : subtypes) {
            ClassElement element = type.getElement();
            if (this.isPrivateName(element.getName())) continue;
            LibraryUnit subtypeLibraryUnit = element.getLibrary().getLibraryUnit();
            if (this.library != null && !this.library.equals(subtypeLibraryUnit.getName())) continue;
            relevantSubtypes.add(element);
        }
        if (relevantSubtypes.size() > 1) {
            Collections.sort(relevantSubtypes, new ElementNameComparator());
            this.stream.println("\n<section class=\"subtypes\">");
            this.stream.println("<h2>Subtypes:</h2>");
            this.stream.println("<ul>");
            for (ClassElement subtype : relevantSubtypes) {
                if (subtype == classElement) continue;
                this.stream.print("<li>");
                this.printClassReference(subtype);
                this.stream.println("</li>");
            }
            this.stream.println("</ul>");
            this.stream.println("</section>");
        }
    }

    private void documentFields(ClassElement classElement, List<FieldElement> fields) {
        if (fields.size() == 0) {
            return;
        }
        Collections.sort(fields, new ElementNameComparator());
        this.stream.println("<h2>Fields</h2>");
        this.stream.println("<dl>");
        for (FieldElement field : fields) {
            this.documentMemberField(field, classElement);
        }
        this.stream.println("</dl>");
    }

    private void documentConstructors(ClassElement classElement, List<ConstructorElement> constructors) {
        if (constructors.size() == 0) {
            return;
        }
        this.stream.println("<h2>Constructors</h2>");
        this.stream.println("<dl>");
        for (ConstructorElement constr : constructors) {
            this.documentConstructor(constr, classElement);
        }
        this.stream.println("</dl>");
    }

    private void documentMethods(ClassElement classElement, List<MethodElement> methods) {
        if (methods.size() == 0) {
            return;
        }
        Collections.sort(methods, new ElementNameComparator());
        this.stream.println("<h2>Methods</h2>");
        this.stream.println("<dl>");
        for (MethodElement method : methods) {
            this.documentMemberField(method, classElement);
        }
        this.stream.println("</dl>");
    }

    private void documentClass(ClassElement classElement) {
        String name = classElement.getName();
        if (this.isPrivateName(name)) {
            return;
        }
        String fileName = this.outputDirectory + File.separator + name + ".html";
        try {
            this.stream = new PrintStream(fileName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.stream.println("<!DOCTYPE html>");
        this.stream.println("<html>");
        this.stream.println("\n<head>");
        this.stream.println("<meta charset=\"utf-8\">");
        this.stream.print("<title>");
        this.stream.print("Dart : Libraries : ");
        this.stream.print(this.library + " : ");
        this.stream.print(name);
        this.stream.println("</title>");
        this.stream.println("</head>");
        this.stream.println("\n<body>");
        this.stream.println("\n<header></header>\n");
        this.stream.print("<h1 id=\"title\">");
        if (classElement.isInterface()) {
            this.stream.print("interface ");
        } else {
            this.stream.print("class ");
        }
        LinkInformation linkInfo = new LinkInformation(classElement.getLibrary().getName(), name, name + "::" + name);
        this.anchors.add(linkInfo);
        this.stream.print(linkInfo.anchorStartTag());
        this.stream.print(name);
        this.printClassTypeParameters(classElement);
        this.stream.println("</a></h1>");
        this.stream.println("\n<section id=\"inheritance\">");
        this.printSupertype(classElement);
        this.printInterfaces(classElement);
        this.printSubTypes(classElement);
        this.stream.println("\n</section>");
        this.stream.println("\n<section id=\"summary\">");
        this.printElementComment(classElement);
        this.stream.println("</section>");
        ArrayList<FieldElement> fields = new ArrayList<FieldElement>(10);
        ArrayList<MethodElement> methods = new ArrayList<MethodElement>(10);
        ArrayList<ConstructorElement> constructors = new ArrayList<ConstructorElement>(10);
        this.getNonPrivateMembers(classElement, fields, methods, constructors);
        this.stream.println("\n<section id=\"fields\">");
        this.documentFields(classElement, fields);
        this.stream.println("</section>");
        this.stream.println("\n<section id=\"constructors\">");
        this.documentConstructors(classElement, constructors);
        this.stream.println("</section>");
        this.stream.println("\n<section id=\"methods\">");
        this.documentMethods(classElement, methods);
        this.stream.println("</section>");
        this.stream.println("\n<footer></footer>\n");
        this.stream.println("</body></html>");
    }

    private void getNonPrivateMembers(ClassElement classElement, List<FieldElement> fields, List<MethodElement> methods, List<ConstructorElement> constructors) {
        for (Element member : classElement.getMembers()) {
            String elementName = member.getName();
            if (this.isPrivateName(elementName)) continue;
            switch (member.getKind()) {
                case METHOD: {
                    methods.add((MethodElement)member);
                    break;
                }
                case FIELD: {
                    fields.add((FieldElement)member);
                }
            }
        }
        List<ConstructorElement> constructorList = classElement.getConstructors();
        for (ConstructorElement c : constructorList) {
            if (this.isPrivateName(c.getName())) continue;
            constructors.add(c);
        }
    }

    private void documentMemberField(MethodElement method, ClassElement classElement) {
        Type returnType;
        String returnTypeName;
        String className = classElement.getName();
        this.stream.println("<dt>");
        this.stream.print("<code>");
        if (method.isStatic()) {
            this.stream.print("static ");
        }
        if (!this.printElementReference(method, returnTypeName = (returnType = ((FunctionType)method.getType()).getReturnType()).getElement().getName())) {
            this.escapeAndPrint(this.stream, returnTypeName);
        }
        this.stream.print(" ");
        String elementReference = className + "::" + this.anchorEscape(method.getName());
        LinkInformation linkInfo = new LinkInformation(classElement.getLibrary().getName(), className, elementReference);
        this.anchors.add(linkInfo);
        this.stream.print(linkInfo.anchorStartTag());
        this.escapeAndPrint(this.stream, method.getName());
        this.stream.print("</a>");
        this.printMethodParameterList(method, classElement);
        this.stream.print("</code>");
        this.stream.println("</dt>");
        this.stream.println("<dd>");
        this.printElementComment(method);
        this.stream.println("</dd>");
    }

    private void documentMemberField(FieldElement field, ClassElement classElement) {
        String className = classElement.getName();
        this.stream.println("<dt>");
        this.stream.print("<span class=\"field-type\"><code>");
        String typeName = field.getType().getElement().getName();
        if (!this.printElementReference(field, typeName)) {
            this.escapeAndPrint(this.stream, typeName);
        }
        this.stream.println("</code></span>");
        this.stream.print("<span class=\"field-name\"><code>");
        LinkInformation linkInfo = new LinkInformation(classElement.getLibrary().getName(), className, className + "::" + field.getName());
        this.anchors.add(linkInfo);
        this.stream.print(linkInfo.anchorStartTag());
        this.stream.println(field.getName());
        this.stream.println("</a></code></span>");
        this.stream.println("</dt>");
        this.stream.println("<dd>");
        this.printElementComment(field);
        this.stream.println("</dd>");
    }

    private void documentConstructor(ConstructorElement constr, ClassElement classElement) {
        String className = classElement.getName();
        this.stream.println("<dt>");
        this.stream.print("<code>");
        this.printClassReference(constr.getConstructorType());
        if (!constr.getName().isEmpty()) {
            this.stream.print(".");
            String elementReference = className + "::" + constr.getName();
            LinkInformation linkInfo = new LinkInformation(classElement.getLibrary().getName(), className, elementReference);
            this.anchors.add(linkInfo);
            this.stream.print(linkInfo.anchorStartTag());
            this.stream.print(constr.getName());
            this.stream.print("</a>");
        }
        this.printMethodParameterList(constr, classElement);
        this.stream.println("</code>");
        this.stream.println("</dt>");
        this.stream.println("<dd>");
        this.printElementComment(constr);
        this.stream.println("</dd>");
    }

    private void documentToplevelMethod(MethodElement method) {
    }

    private void documentToplevelField(FieldElement field) {
    }
}

