/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.doc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartSource;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibrarySource;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartField;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.LibraryUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.common.AbstractBackend;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.doc.DartDocumentationVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.doc.ElementNameComparator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.doc.LinkInformation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CoreTypeProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.FieldElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;

public class DartDocumentationGenerator
extends AbstractBackend {
    private String outputDirectory;
    private String library;
    private PrintStream stream;
    private Set<LinkInformation> anchors;
    private Set<LinkInformation> links;

    public DartDocumentationGenerator(String out, String lib) {
        this.library = lib;
        this.outputDirectory = out;
        this.anchors = new HashSet<LinkInformation>();
        this.links = new HashSet<LinkInformation>();
    }

    private void generate(DartUnit unit) {
        LibraryUnit lib = unit.getLibrary();
        if (this.library == null || this.library.equals(lib.getName())) {
            DartDocumentationVisitor visitor = new DartDocumentationVisitor(this.outputDirectory, this.library, unit.getComments(), this.anchors, this.links);
            visitor.initialize(unit);
            visitor.visitNode(unit);
        }
    }

    private boolean isPrivateName(String name) {
        return name.charAt(0) == '_';
    }

    private void setPrintStream(String name) {
        String fileName = this.outputDirectory + File.separator + name + ".html";
        try {
            this.stream = new PrintStream(fileName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void printLibraryMembers(LibraryUnit lib) {
        String name;
        ArrayList<ClassElement> classes = new ArrayList<ClassElement>(10);
        ArrayList<ClassElement> exceptions = new ArrayList<ClassElement>(10);
        ArrayList<FieldElement> fields = new ArrayList<FieldElement>(10);
        ArrayList<MethodElement> methods = new ArrayList<MethodElement>(10);
        for (DartNode dartNode : lib.getTopLevelNodes()) {
            DartMethodDefinition dartMethod;
            MethodElement methodElement;
            String name2;
            if (dartNode instanceof DartClass) {
                DartClass dartClass = (DartClass)dartNode;
                ClassElement classElement = dartClass.getSymbol();
                name2 = classElement.getName();
                if (this.isPrivateName(name2)) continue;
                if (name2.contains("Exception")) {
                    exceptions.add(classElement);
                    continue;
                }
                classes.add(classElement);
                continue;
            }
            if (dartNode instanceof DartField) {
                DartField dartField = (DartField)dartNode;
                FieldElement fieldElement = dartField.getSymbol();
                name2 = fieldElement.getName();
                if (this.isPrivateName(name2)) continue;
                fields.add(fieldElement);
                continue;
            }
            if (!(dartNode instanceof DartMethodDefinition) || this.isPrivateName(name2 = (methodElement = (dartMethod = (DartMethodDefinition)dartNode).getSymbol()).getName())) continue;
            methods.add(methodElement);
        }
        if (classes.size() > 0 || exceptions.size() > 0) {
            Collections.sort(classes, new ElementNameComparator());
            Collections.sort(exceptions, new ElementNameComparator());
            this.stream.println("\n<section id=\"classes-overview\">");
            this.stream.println("<h3>Classes and interfaces</h3>");
            this.stream.print("<ul>");
            this.printClassLibraryMembers(classes);
            this.printClassLibraryMembers(exceptions);
            this.stream.println("</ul>");
            this.stream.println("</section>");
        }
        if (methods.size() > 0) {
            Collections.sort(methods, new ElementNameComparator());
            this.stream.println("\n<section id=\"methods-overview\">");
            this.stream.println("<h3>Top-level methods</h3>");
            this.stream.print("<ul>");
            for (MethodElement methodElement : methods) {
                name = methodElement.getName();
                this.stream.print("<li>");
                this.stream.print(name);
                this.stream.print("</li>");
            }
            this.stream.println("</ul>");
            this.stream.println("</section>");
        }
        if (fields.size() > 0) {
            Collections.sort(fields, new ElementNameComparator());
            this.stream.println("\n<section id=\"fields-overview\">");
            this.stream.println("<h3>Top-level fields</h3>");
            this.stream.print("<ul>");
            for (FieldElement fieldElement : fields) {
                name = fieldElement.getName();
                this.stream.print("<li>");
                this.stream.print(name);
                this.stream.print("</li>");
            }
            this.stream.println("</ul>");
            this.stream.println("</section>");
        }
    }

    private void printClassLibraryMembers(List<ClassElement> classes) {
        for (ClassElement classElement : classes) {
            String name = classElement.getName();
            this.stream.print("<li>");
            LinkInformation linkInfo = new LinkInformation(classElement.getLibrary().getName(), name, name + "::" + name);
            this.links.add(linkInfo);
            this.stream.print(linkInfo.anchorReferenceStartTag());
            this.stream.print(name);
            List<? extends Type> typeParameters = classElement.getTypeParameters();
            if (typeParameters.size() > 0) {
                this.stream.print("&lt;");
                boolean first = true;
                for (Type type : typeParameters) {
                    if (!first) {
                        this.stream.print(",");
                    } else {
                        first = false;
                    }
                    this.stream.print(type.getElement().getName());
                }
                this.stream.print("&gt;");
            }
            this.stream.print("</a>");
            this.stream.print("</li>");
        }
    }

    @Override
    public boolean isOutOfDate(DartSource src, DartCompilerContext context) {
        return true;
    }

    @Override
    public void compileUnit(DartUnit unit, DartSource src, DartCompilerContext context, CoreTypeProvider typeProvider) {
        this.generate(unit);
    }

    @Override
    public void packageApp(LibrarySource app, Collection<LibraryUnit> libraries, DartCompilerContext context, CoreTypeProvider typeProvider) {
        this.setPrintStream("index");
        this.stream.println("<!DOCTYPE html>");
        this.stream.println("<html>");
        this.stream.println("<head>");
        this.stream.println("<meta charset=\"utf-8\">");
        this.stream.print("<title>");
        this.stream.print("Dart : Libraries");
        this.stream.println("</title>");
        this.stream.print("</head>");
        this.stream.println("<body>");
        this.stream.println("\n<header></header>\n");
        this.stream.println("<h1 id=\"title\">Library Reference</h1>");
        this.stream.println("<section id=\"libraries-overview\">");
        for (LibraryUnit lib : libraries) {
            if (this.library != null && !this.library.equals(lib.getName()) || lib.getTopLevelNodes().size() <= 0) continue;
            this.stream.print("<h2>");
            this.stream.print(lib.getName());
            this.stream.println("</h2>");
            this.printLibraryMembers(lib);
        }
        this.stream.println("</section>");
        this.stream.println("\n<footer></footer>\n");
        this.stream.println("</body></html>");
        for (LinkInformation linkInfo : this.links) {
            if (this.anchors.contains(linkInfo)) continue;
            System.out.print("Warning: link to element without anchor: ");
            System.out.println(linkInfo.className + "::" + linkInfo.elementName);
        }
    }

    @Override
    public String getAppExtension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSourceMapExtension() {
        throw new UnsupportedOperationException();
    }
}

