/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.backend.dart;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import org.jetbrains.jet.internal.com.google.common.io.CharStreams;
import org.jetbrains.jet.internal.com.google.common.io.Closeables;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartSource;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibrarySource;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartToSourceVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.LibraryUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.common.AbstractBackend;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CoreTypeProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.DefaultTextOutput;

public class DartBackend
extends AbstractBackend {
    public static final String EXTENSION_DART = "opt.dart";
    public static final String EXTENSION_DART_SRC_MAP = "opt.dart.map";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void packageLibs(Collection<LibraryUnit> libraries, Writer w, DartCompilerContext context) throws IOException {
        for (LibraryUnit libUnit : libraries) {
            for (DartUnit unit : libUnit.getUnits()) {
                DartSource src = unit.getSource();
                if (src == null) continue;
                Reader r = context.getArtifactReader(src, "", EXTENSION_DART);
                boolean failed = true;
                try {
                    CharStreams.copy(r, (Appendable)w);
                    failed = false;
                }
                finally {
                    Closeables.close(r, failed);
                }
            }
        }
    }

    @Override
    public boolean isOutOfDate(DartSource src, DartCompilerContext context) {
        return context.isOutOfDate(src, src, EXTENSION_DART);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileUnit(DartUnit unit, DartSource src, DartCompilerContext context, CoreTypeProvider typeProvider) throws IOException {
        DefaultTextOutput out = new DefaultTextOutput(false);
        DartToSourceVisitor srcGenerator = new DartToSourceVisitor(out);
        srcGenerator.generateSourceMap(true);
        srcGenerator.accept(unit);
        Writer w = context.getArtifactWriter(src, "", EXTENSION_DART);
        boolean failed = true;
        try {
            w.write(((Object)out).toString());
            failed = false;
        }
        finally {
            Closeables.close(w, failed);
        }
        w = context.getArtifactWriter(src, "", EXTENSION_DART_SRC_MAP);
        failed = true;
        try {
            srcGenerator.writeSourceMap(w, src.getName());
            failed = false;
        }
        finally {
            Closeables.close(w, failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void packageApp(LibrarySource app, Collection<LibraryUnit> libraries, DartCompilerContext context, CoreTypeProvider typeProvider) throws IOException {
        Writer out = context.getArtifactWriter(app, "", EXTENSION_DART);
        boolean failed = true;
        try {
            DartBackend.packageLibs(libraries, out, context);
            failed = false;
        }
        finally {
            Closeables.close(out, failed);
        }
    }

    @Override
    public String getAppExtension() {
        return EXTENSION_DART;
    }

    @Override
    public String getSourceMapExtension() {
        return EXTENSION_DART_SRC_MAP;
    }
}

