/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast.viz;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.jetbrains.jet.internal.com.google.common.io.Closeables;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.viz.ConsoleWriter;

public class TextWriter
extends ConsoleWriter {
    public TextWriter(String outputDir) {
        super(outputDir);
    }

    @Override
    protected void startHook(DartUnit unit) {
        if (!this.isIgnored(unit)) {
            String txtFilePath = this.outputDir + File.separator + unit.getSource().getUri() + ".ast.txt";
            this.makeParentDirs(txtFilePath);
            try {
                this.out = new FileWriter(new File(txtFilePath));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void endHook(DartUnit unit) {
        if (!this.isIgnored(unit)) {
            try {
                Closeables.close(this.out, true);
            }
            catch (IOException e) {
                System.err.println("Error closing AST output file");
                e.printStackTrace();
            }
        }
    }
}

