/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast.viz;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.viz.BaseASTWriter;

public class ConsoleWriter
extends BaseASTWriter {
    Map<DartNode, Integer> indentMap = new HashMap<DartNode, Integer>();
    OutputStreamWriter out = new OutputStreamWriter(System.out);

    public ConsoleWriter(String outputDir) {
        super(outputDir);
    }

    @Override
    protected void startHook(DartUnit unit) {
    }

    @Override
    protected void endHook(DartUnit unit) {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void write(String nodeType, DartNode node, String data) {
        StringBuffer sb = new StringBuffer();
        int indent = 0;
        DartNode parent = node.getParent();
        if (parent != null) {
            indent = this.indentMap.get(parent) + 1;
        }
        for (int i = 0; i < indent; ++i) {
            sb.append('\t');
        }
        try {
            this.out.write(sb.toString());
            this.out.write(nodeType);
            if (!data.equals("")) {
                this.out.write(" (" + data + ")");
            }
            this.out.write(10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void visitChildren(DartNode node) {
        DartNode parent = node.getParent();
        if (parent == null) {
            this.indentMap.put(node, 0);
        } else {
            int parentIndent = this.indentMap.get(parent);
            this.indentMap.put(node, parentIndent + 1);
        }
        super.visitChildren(node);
    }
}

