/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.jetbrains.jet.internal.com.google.common.io.CharStreams;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerListener;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartSource;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibraryDeps;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibrarySource;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartField;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNodeTraverser;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.LibraryNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.SourceInfo;
import org.jetbrains.jet.internal.com.google.dart.compiler.metrics.DartEventType;
import org.jetbrains.jet.internal.com.google.dart.compiler.metrics.Tracer;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.DartParser;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.DartScannerParserContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Elements;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElement;

public class LibraryUnit {
    private final LibrarySource libSource;
    private final LibraryNode selfSourcePath;
    private final Collection<LibraryNode> importPaths = new ArrayList<LibraryNode>();
    private final Collection<LibraryNode> sourcePaths = new ArrayList<LibraryNode>();
    private final Collection<LibraryNode> resourcePaths = new ArrayList<LibraryNode>();
    private final Collection<LibraryNode> nativePaths = new ArrayList<LibraryNode>();
    private final Map<String, DartUnit> units = new ConcurrentSkipListMap<String, DartUnit>();
    private final Collection<LibraryUnit> imports = new ArrayList<LibraryUnit>();
    private final Map<LibraryUnit, String> prefixes = new HashMap<LibraryUnit, String>();
    private final LibraryElement element;
    private Map<String, DartNode> topLevelNodes;
    private LibraryDeps deps;
    private LibraryNode entryNode;
    private DartUnit selfDartUnit;
    private String name;
    private DartExpression entryPoint;
    private int sourceCount;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LibraryUnit(LibrarySource libSource) {
        assert (libSource != null);
        this.libSource = libSource;
        this.element = Elements.libraryElement(this);
        String self = libSource.getUri().getSchemeSpecificPart();
        int lastSlash = self.lastIndexOf(47);
        if (lastSlash > -1) {
            self = self.substring(lastSlash + 1);
        }
        this.selfSourcePath = new LibraryNode(self);
    }

    public void addImportPath(LibraryNode path) {
        assert (path != null);
        this.importPaths.add(path);
    }

    public void addSourcePath(LibraryNode path) {
        assert (path != null);
        this.sourcePaths.add(path);
        ++this.sourceCount;
    }

    public void addResourcePath(LibraryNode path) {
        assert (path != null);
        this.resourcePaths.add(path);
    }

    public int getSourceCount() {
        return this.sourceCount;
    }

    public void addNativePath(LibraryNode path) {
        assert (path != null);
        this.nativePaths.add(path);
    }

    public void putUnit(DartUnit unit) {
        unit.setLibrary(this);
        this.units.put(unit.getSourceName(), unit);
    }

    public DartUnit getUnit(String sourceName) {
        return this.units.get(sourceName);
    }

    public void addImport(LibraryUnit unit, LibraryNode node) {
        this.imports.add(unit);
        if (node != null && node.getPrefix() != null) {
            this.prefixes.put(unit, node.getPrefix());
        }
    }

    public String getPrefixOf(LibraryUnit library) {
        return this.prefixes.get(library);
    }

    public LibraryElement getElement() {
        return this.element;
    }

    public Iterable<DartUnit> getUnits() {
        return this.units.values();
    }

    public Iterable<LibraryUnit> getImports() {
        return this.imports;
    }

    public boolean hasImport(LibraryUnit unit) {
        return this.imports.contains(unit);
    }

    public DartExpression getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(DartExpression entry) {
        this.entryPoint = entry;
    }

    public DartUnit getSelfDartUnit() {
        return this.selfDartUnit;
    }

    public void setSelfDartUnit(DartUnit unit) {
        this.selfDartUnit = unit;
    }

    public Iterable<LibraryNode> getImportPaths() {
        return this.importPaths;
    }

    public Set<String> getPrefixes() {
        return new HashSet<String>(this.prefixes.values());
    }

    public LibraryNode getSelfSourcePath() {
        return this.selfSourcePath;
    }

    public LibrarySource getSource() {
        return this.libSource;
    }

    public Iterable<LibraryNode> getSourcePaths() {
        return this.sourcePaths;
    }

    public Iterable<LibraryNode> getResourcePaths() {
        return this.resourcePaths;
    }

    public Iterable<LibraryNode> getNativePaths() {
        return this.nativePaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadApi(DartCompilerContext context, DartCompilerListener listener) throws IOException {
        boolean bl;
        Reader r;
        Tracer.TraceEvent parseEvent;
        block4: {
            parseEvent = Tracer.canTrace() ? Tracer.start(DartEventType.PARSE_API, "src", this.getSource().getUri().toString()) : null;
            r = context.getArtifactReader(this.libSource, "", "api");
            if (r != null) break block4;
            boolean bl2 = false;
            Tracer.end(parseEvent, new String[0]);
            return bl2;
        }
        try {
            String srcCode = CharStreams.toString(r);
            r.close();
            int idx = srcCode.indexOf("--- unit-name: ");
            while (idx != -1) {
                int endIdx = srcCode.indexOf(10, idx += "--- unit-name: ".length());
                String unitName = srcCode.substring(idx, endIdx);
                idx = endIdx;
                idx = srcCode.indexOf("--- unit-uri: ", endIdx);
                endIdx = srcCode.indexOf(10, idx += "--- unit-uri: ".length());
                String unitUri = srcCode.substring(idx, endIdx);
                idx = endIdx;
                String code = (endIdx = srcCode.indexOf("--- unit-name: ", idx)) != -1 ? srcCode.substring(idx, endIdx) : srcCode.substring(idx);
                this.parseApiUnit(unitName, unitUri, code, this.libSource, listener);
                idx = endIdx;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Tracer.end(parseEvent, new String[0]);
            throw throwable;
        }
        Tracer.end(parseEvent, new String[0]);
        return bl;
    }

    public void saveApi(DartCompilerContext context) throws IOException {
        Writer w = context.getArtifactWriter(this.libSource, "", "api");
        for (Map.Entry<String, DartUnit> entry : this.units.entrySet()) {
            String unitName = entry.getKey();
            DartUnit unit = entry.getValue();
            w.write("--- unit-name: " + unitName + "\n");
            w.write("--- unit-uri: " + unit.getSource().getUri() + "\n");
            w.write(unit.toDietSource());
        }
        w.close();
    }

    public void populateTopLevelNodes() {
        assert (this.topLevelNodes == null);
        this.topLevelNodes = new HashMap<String, DartNode>();
        DartNodeTraverser<Void> visitor = new DartNodeTraverser<Void>(){

            @Override
            public Void visitClass(DartClass node) {
                LibraryUnit.this.topLevelNodes.put(node.getClassName(), node);
                return null;
            }

            @Override
            public Void visitMethodDefinition(DartMethodDefinition node) {
                Object name = node.getName();
                if (name instanceof DartIdentifier) {
                    LibraryUnit.this.topLevelNodes.put(((DartIdentifier)name).getTargetName(), node);
                } else {
                    LibraryUnit.this.topLevelNodes.put(((DartNode)node.getName()).toSource(), node);
                }
                return null;
            }

            @Override
            public Void visitField(DartField node) {
                LibraryUnit.this.topLevelNodes.put(((DartIdentifier)node.getName()).getTargetName(), node);
                return null;
            }
        };
        for (DartUnit unit : this.units.values()) {
            visitor.visitUnit(unit);
        }
    }

    public Collection<DartNode> getTopLevelNodes() {
        return Collections.unmodifiableCollection(this.topLevelNodes.values());
    }

    public DartNode getTopLevelNode(String name) {
        assert (this.topLevelNodes != null);
        return this.topLevelNodes.get(name);
    }

    public LibraryNode getEntryNode() {
        return this.entryNode;
    }

    public void setEntryNode(LibraryNode libraryNode) {
        this.entryNode = libraryNode;
    }

    public LibraryDeps getDeps(DartCompilerContext context) throws IOException {
        if (this.deps != null) {
            return this.deps;
        }
        Reader reader = context.getArtifactReader(this.libSource, "", "deps");
        if (reader != null) {
            this.deps = LibraryDeps.fromReader(reader);
            reader.close();
        }
        if (this.deps == null) {
            this.deps = new LibraryDeps();
        }
        return this.deps;
    }

    public void writeDeps(DartCompilerContext context) throws IOException {
        Writer writer = context.getArtifactWriter(this.libSource, "", "deps");
        this.deps.write(writer);
        writer.close();
    }

    private void parseApiUnit(final String unitName, final String unitUri, String srcCode, final LibrarySource libSrc, DartCompilerListener listener) {
        DartSource src = new DartSource(){

            @Override
            public LibrarySource getLibrary() {
                return libSrc;
            }

            @Override
            public String getName() {
                return unitName;
            }

            @Override
            public Reader getSourceReader() {
                return null;
            }

            @Override
            public URI getUri() {
                return URI.create(unitUri);
            }

            @Override
            public boolean exists() {
                return true;
            }

            @Override
            public long getLastModified() {
                return 0L;
            }

            @Override
            public String getRelativePath() {
                return unitName;
            }
        };
        DartScannerParserContext parserContext = new DartScannerParserContext(src, srcCode, listener);
        DartParser parser = new DartParser(parserContext);
        DartUnit unit = parser.parseUnit(src);
        for (DartNode node : unit.getTopLevelNodes()) {
            if (!(node instanceof DartClass)) continue;
            SourceInfo nodeInfo = node.getSourceInfo();
            String nodeString = srcCode.substring(nodeInfo.getSourceStart(), nodeInfo.getSourceStart() + nodeInfo.getSourceLength());
            ((DartClass)node).setHash(nodeString.hashCode());
        }
        unit.setDiet(true);
        this.putUnit(unit);
    }
}

