/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.ElementReference;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.Token;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;

public class DartUnaryExpression
extends DartExpression
implements ElementReference {
    private final Token operator;
    private DartExpression arg;
    private final boolean isPrefix;
    private DartExpression normalizedNode = this;
    private Element referencedElement;

    public DartUnaryExpression(Token operator, DartExpression arg, boolean isPrefix) {
        assert (operator.isUnaryOperator() || operator == Token.SUB);
        this.isPrefix = isPrefix;
        this.operator = operator;
        this.arg = this.becomeParentOf(arg);
    }

    public DartExpression getArg() {
        return this.arg;
    }

    public Token getOperator() {
        return this.operator;
    }

    public boolean isPrefix() {
        return this.isPrefix;
    }

    public void setNormalizedNode(DartExpression normalizedNode) {
        normalizedNode.setSourceInfo(this);
        this.normalizedNode = normalizedNode;
    }

    @Override
    public DartExpression getNormalizedNode() {
        return this.normalizedNode;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.arg = this.operator.isCountOperator() ? this.becomeParentOf(v.acceptLvalue(this.getArg())) : (DartExpression)this.becomeParentOf((DartNode)v.accept(this.getArg()));
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.arg.accept(visitor);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitUnaryExpression(this);
    }

    @Override
    public Element getReferencedElement() {
        return this.referencedElement;
    }

    @Override
    public void setReferencedElement(Element referencedElement) {
        this.referencedElement = referencedElement;
    }
}

