/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import java.util.List;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;

public abstract class DartTypedLiteral
extends DartExpression {
    private List<DartTypeNode> typeArguments;
    private final boolean isConst;
    private InterfaceType type;

    DartTypedLiteral(boolean isConst, List<DartTypeNode> typeArguments) {
        this.isConst = isConst;
        this.setTypeArguments(typeArguments);
    }

    public boolean isConst() {
        return this.isConst;
    }

    public void setTypeArguments(List<DartTypeNode> typeArguments) {
        if (typeArguments == null) {
            typeArguments = Lists.newArrayList();
        }
        this.typeArguments = this.becomeParentOf(typeArguments);
    }

    public List<DartTypeNode> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public void setType(Type type) {
        this.type = (InterfaceType)type;
    }

    @Override
    public InterfaceType getType() {
        return this.type;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (this.typeArguments.size() > 0) {
            v.acceptWithInsertRemove(this, this.typeArguments);
        }
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        if (this.typeArguments.size() > 0) {
            visitor.visit(this.getTypeArguments());
        }
    }
}

