/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import java.util.List;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.HasSymbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ConstructorElement;

public class DartSuperConstructorInvocation
extends DartInvocation
implements HasSymbol {
    private DartIdentifier name;
    private ConstructorElement symbol;

    public DartSuperConstructorInvocation(DartIdentifier name, List<DartExpression> args) {
        super(args);
        this.name = this.becomeParentOf(name);
    }

    public String getConstructorName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getTargetName();
    }

    public DartIdentifier getName() {
        return this.name;
    }

    public void setName(DartIdentifier newName) {
        this.name = this.becomeParentOf(newName);
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.symbol = (ConstructorElement)symbol;
    }

    @Override
    public ConstructorElement getSymbol() {
        return this.symbol;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.name != null) {
                this.name = (DartIdentifier)this.becomeParentOf((DartNode)v.accept(this.name));
            }
            v.acceptWithInsertRemove(this, this.getArgs());
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        if (this.name != null) {
            this.name.accept(visitor);
        }
        visitor.visit(this.getArgs());
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitSuperConstructorInvocation(this);
    }
}

