/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import java.util.List;
import org.jetbrains.jet.internal.com.google.common.base.Preconditions;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartStringLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVisitor;

public class DartStringInterpolation
extends DartLiteral {
    private List<DartStringLiteral> strings;
    private List<DartExpression> expressions;

    public DartStringInterpolation(List<DartStringLiteral> strings, List<DartExpression> expressions) {
        Preconditions.checkNotNull(strings);
        Preconditions.checkNotNull(expressions);
        Preconditions.checkArgument(strings.size() == expressions.size() + 1);
        this.strings = this.becomeParentOf(strings);
        this.expressions = this.becomeParentOf(expressions);
    }

    public List<DartStringLiteral> getStrings() {
        return this.strings;
    }

    public List<DartExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptWithInsertRemove(this, this.strings);
            v.acceptWithInsertRemove(this, this.expressions);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        visitor.visit(this.strings);
        visitor.visit(this.expressions);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitStringInterpolation(this);
    }
}

