/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.ElementReference;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;

public class DartPropertyAccess
extends DartExpression
implements ElementReference {
    private DartNode qualifier;
    private DartIdentifier name;
    private DartExpression normalizedNode = this;
    private Element referencedElement;

    public DartPropertyAccess(DartNode qualifier, DartIdentifier name) {
        this.qualifier = this.becomeParentOf(qualifier);
        this.name = this.becomeParentOf(name);
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    public String getPropertyName() {
        return this.name.getTargetName();
    }

    public DartIdentifier getName() {
        return this.name;
    }

    public DartNode getQualifier() {
        return this.qualifier;
    }

    public void setName(DartIdentifier newName) {
        this.name = this.becomeParentOf(newName);
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.name.setSymbol(symbol);
    }

    public Element getTargetSymbol() {
        return this.name.getTargetSymbol();
    }

    public void setNormalizedNode(DartExpression normalizedNode) {
        normalizedNode.setSourceInfo(this);
        this.normalizedNode = normalizedNode;
    }

    @Override
    public DartExpression getNormalizedNode() {
        return this.normalizedNode;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.qualifier = this.becomeParentOf(v.accept(this.qualifier));
            this.name = (DartIdentifier)this.becomeParentOf((DartNode)v.accept(this.name));
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.qualifier.accept(visitor);
        this.name.accept(visitor);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitPropertyAccess(this);
    }

    @Override
    public Element getReferencedElement() {
        return this.referencedElement;
    }

    @Override
    public void setReferencedElement(Element element) {
        this.referencedElement = element;
    }
}

