/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import java.util.List;
import org.jetbrains.jet.internal.com.google.common.base.Preconditions;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDeclaration;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPropertyAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.HasSymbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.VariableElement;

public class DartParameter
extends DartDeclaration<DartExpression>
implements HasSymbol {
    private VariableElement symbol;
    private DartTypeNode typeNode;
    private List<DartParameter> functionParameters;
    private DartExpression defaultExpr;
    private DartParameter normalizedNode = this;
    private final Modifiers modifiers;

    public DartParameter(DartExpression name, DartTypeNode typeNode, List<DartParameter> functionParameters, DartExpression defaultExpr, Modifiers modifiers) {
        super(name);
        Preconditions.checkArgument(name instanceof DartIdentifier || name instanceof DartPropertyAccess, "name");
        this.typeNode = this.becomeParentOf(typeNode);
        this.functionParameters = this.becomeParentOf(functionParameters);
        this.defaultExpr = this.becomeParentOf(defaultExpr);
        this.modifiers = modifiers;
    }

    public DartExpression getDefaultExpr() {
        return this.defaultExpr;
    }

    public String getParameterName() {
        if (this.getName() instanceof DartIdentifier) {
            return ((DartIdentifier)this.getName()).getTargetName();
        }
        return ((DartPropertyAccess)this.getName()).getPropertyName();
    }

    @Override
    public VariableElement getSymbol() {
        return this.symbol;
    }

    public List<DartParameter> getFunctionParameters() {
        return this.functionParameters;
    }

    public DartTypeNode getTypeNode() {
        return this.typeNode;
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public DartNode getQualifier() {
        if (this.getName() instanceof DartPropertyAccess) {
            return ((DartPropertyAccess)this.getName()).getQualifier();
        }
        return null;
    }

    public void setNormalizedNode(DartParameter normalizedNode) {
        normalizedNode.setSourceInfo(this);
        this.normalizedNode = normalizedNode;
    }

    @Override
    public DartParameter getNormalizedNode() {
        return this.normalizedNode;
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.symbol = (VariableElement)symbol;
    }

    public void setTypeNode(DartTypeNode typeNode) {
        this.typeNode = this.becomeParentOf(typeNode);
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.typeNode != null) {
                this.typeNode = (DartTypeNode)this.becomeParentOf((DartNode)v.accept(this.typeNode));
            }
            if (this.defaultExpr != null) {
                this.defaultExpr = (DartExpression)this.becomeParentOf((DartNode)v.accept(this.defaultExpr));
            }
            if (this.functionParameters != null) {
                v.acceptWithInsertRemove(this, this.functionParameters);
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        if (this.typeNode != null) {
            this.typeNode.accept(visitor);
        }
        if (this.defaultExpr != null) {
            this.defaultExpr.accept(visitor);
        }
        visitor.visit(this.functionParameters);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitParameter(this);
    }
}

