/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import java.util.List;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.HasSymbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ConstructorElement;

public class DartNewExpression
extends DartInvocation
implements HasSymbol {
    private DartNode constructor;
    private ConstructorElement typeSymbol;
    private final boolean isConst;

    public DartNewExpression(DartNode constructor, List<DartExpression> args, boolean isConst) {
        super(args);
        this.constructor = this.becomeParentOf(constructor);
        this.isConst = isConst;
    }

    public DartNode getConstructor() {
        return this.constructor;
    }

    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public ConstructorElement getSymbol() {
        return this.typeSymbol;
    }

    public void setConstructor(DartExpression newConstructor) {
        this.constructor = this.becomeParentOf(newConstructor);
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.typeSymbol = (ConstructorElement)symbol;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.constructor = this.becomeParentOf(v.accept(this.constructor));
            v.acceptWithInsertRemove(this, this.getArgs());
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.constructor.accept(visitor);
        visitor.visit(this.getArgs());
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitNewExpression(this);
    }
}

