/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import java.util.List;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;

public class DartMethodInvocation
extends DartInvocation {
    private DartExpression target;
    private DartIdentifier functionName;
    private Symbol targetSymbol;

    public DartMethodInvocation(DartExpression target, DartIdentifier functionName, List<DartExpression> args) {
        super(args);
        functionName.getClass();
        this.target = this.becomeParentOf(target);
        this.functionName = this.becomeParentOf(functionName);
    }

    @Override
    public DartExpression getTarget() {
        return this.target;
    }

    public String getFunctionNameString() {
        return this.functionName.getTargetName();
    }

    public DartIdentifier getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(DartIdentifier newName) {
        newName.getClass();
        this.functionName = this.becomeParentOf(newName);
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.targetSymbol = symbol;
    }

    public Symbol getTargetSymbol() {
        return this.targetSymbol;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.target = (DartExpression)this.becomeParentOf((DartNode)v.accept(this.target));
            this.functionName = (DartIdentifier)this.becomeParentOf((DartNode)v.accept(this.functionName));
            this.functionName.getClass();
            v.acceptWithInsertRemove(this, this.getArgs());
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.target.accept(visitor);
        this.functionName.accept(visitor);
        visitor.visit(this.getArgs());
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitMethodInvocation(this);
    }
}

